/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.scope.GradleAwareFilterData;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public final class FilterDataImpl
implements GradleAwareFilterData,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filterType;
    private final String identifier;

    public static VariantOutput.FilterType getType(GradleAwareFilterData filter) {
        return VariantOutput.FilterType.valueOf((String)filter.getFilterType());
    }

    public FilterDataImpl(VariantOutput.FilterType filterType2, String identifier) {
        this(filterType2.name(), identifier);
    }

    public FilterDataImpl(String filterType2, String identifier) {
        this.filterType = filterType2;
        this.identifier = identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getFilterType() {
        return this.filterType;
    }

    public static GradleAwareFilterData build(String filterType2, String identifier) {
        return new FilterDataImpl(filterType2, identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDataImpl that = (FilterDataImpl)o;
        return Objects.equals(this.filterType, that.filterType) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.filterType, this.identifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FilterData.class).add("type", (Object)this.filterType).add("value", (Object)this.identifier).toString();
    }
}

