/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class PackageSplitRes
extends AndroidBuilderTask {
    private SigningConfig signingConfig;
    private File incrementalDir;
    public BuildableArtifact processedResources;
    public File splitResApkOutputDirectory;

    @InputFiles
    public BuildableArtifact getProcessedResources() {
        return this.processedResources;
    }

    @OutputDirectory
    public File getSplitResApkOutputDirectory() {
        return this.splitResApkOutputDirectory;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    @TaskAction
    protected void doFullTaskAction() {
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, this.processedResources).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(split, output2) -> {
            if (output2 == null) {
                throw new RuntimeException("Cannot find processed resources for " + split);
            }
            File outFile = new File(this.splitResApkOutputDirectory, this.getOutputFileNameForSplit((ApkInfo)split, this.signingConfig != null));
            File intDir = new File(this.incrementalDir, FileUtils.join((String[])new String[]{split.getFilterName(), "tmp"}));
            try {
                FileUtils.cleanOutputDir((File)intDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder().withSigning(this.signingConfig).withOutputFile(outFile).withProject(this.getProject()).withIntermediateDir(intDir).build();){
                pkg.updateAndroidResources(IncrementalRelativeFileSets.fromZip((File)output2));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return outFile;
        })).into(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.splitResApkOutputDirectory);
    }

    public String getOutputFileNameForSplit(ApkInfo apkData, boolean isSigned) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (isSigned ? "" : "-unsigned") + ".apk";
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitRes> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitResources");
        }

        @Override
        public Class<PackageSplitRes> getType() {
            return PackageSplitRes.class;
        }

        @Override
        public void execute(PackageSplitRes packageSplitResourcesTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            packageSplitResourcesTask.processedResources = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES);
            packageSplitResourcesTask.signingConfig = ((VariantConfiguration)config2).getSigningConfig();
            packageSplitResourcesTask.splitResApkOutputDirectory = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, (Task)packageSplitResourcesTask, "out");
            packageSplitResourcesTask.incrementalDir = this.scope.getIncrementalDir(this.getName());
            packageSplitResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitResourcesTask.setVariantName(config2.getFullName());
        }
    }
}

