/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.tasks.TaskAction;

public class ExternalNativeCleanTask
extends AndroidBuilderTask {
    private List<File> nativeBuildConfigurationsJsons;
    private File objFolder;
    private Map<Abi, File> stlSharedObjectFiles;

    protected void diagnostic(String format, Object ... args) {
        this.getLogger().info(String.format(this.getName() + ": " + format, args));
    }

    @TaskAction
    void clean() throws ProcessException, IOException {
        this.diagnostic("starting clean", new Object[0]);
        this.diagnostic("finding existing JSONs", new Object[0]);
        ArrayList existingJsons = Lists.newArrayList();
        for (File json : this.nativeBuildConfigurationsJsons) {
            if (!json.isFile()) continue;
            existingJsons.add(json);
        }
        List<NativeBuildConfigValueMini> configValueList = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(existingJsons, null);
        ArrayList cleanCommands = Lists.newArrayList();
        ArrayList targetNames = Lists.newArrayList();
        for (NativeBuildConfigValueMini config2 : configValueList) {
            cleanCommands.addAll(config2.cleanCommands);
            HashSet targets = Sets.newHashSet();
            for (NativeLibraryValueMini library : config2.libraries.values()) {
                targets.add(String.format("%s %s", library.artifactName, library.abi));
            }
            targetNames.add(Joiner.on((String)",").join((Iterable)targets));
        }
        this.diagnostic("about to execute %s clean commands", cleanCommands.size());
        this.executeProcessBatch(cleanCommands, targetNames);
        if (!this.stlSharedObjectFiles.isEmpty()) {
            this.diagnostic("remove STL shared object files", new Object[0]);
            for (Abi abi : this.stlSharedObjectFiles.keySet()) {
                File stlSharedObjectFile = (File)Preconditions.checkNotNull((Object)this.stlSharedObjectFiles.get((Object)abi));
                File objAbi = FileUtils.join((File)this.objFolder, (String[])new String[]{abi.getName(), stlSharedObjectFile.getName()});
                if (objAbi.delete()) {
                    this.diagnostic("removed file %s", objAbi);
                    continue;
                }
                this.diagnostic("failed to remove file %s", objAbi);
            }
        }
        this.diagnostic("clean complete", new Object[0]);
    }

    protected void executeProcessBatch(List<String> commands, List<String> targetNames) throws ProcessException, IOException {
        for (int commandIndex = 0; commandIndex < commands.size(); ++commandIndex) {
            String command = commands.get(commandIndex);
            String target = targetNames.get(commandIndex);
            this.getLogger().lifecycle(String.format("Clean %s", target));
            List tokens = StringHelper.tokenizeCommandLineToEscaped((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                processBuilder.addArgs((String)tokens.get(i));
            }
            this.diagnostic("%s", processBuilder);
            ExternalNativeBuildTaskUtils.executeBuildProcessAndLogError(this.getBuilder(), processBuilder, true, "");
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ExternalNativeCleanTask> {
        private final ExternalNativeJsonGenerator generator;
        private final VariantScope scope;
        private final AndroidBuilder androidBuilder;

        public ConfigAction(ExternalNativeJsonGenerator generator, VariantScope scope, AndroidBuilder androidBuilder) {
            this.generator = generator;
            this.scope = scope;
            this.androidBuilder = androidBuilder;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("externalNativeBuildClean");
        }

        @Override
        public Class<ExternalNativeCleanTask> getType() {
            return ExternalNativeCleanTask.class;
        }

        @Override
        public void execute(ExternalNativeCleanTask task) {
            BaseVariantData variantData = this.scope.getVariantData();
            task.setVariantName(variantData.getName());
            ArrayList abiNames = Lists.newArrayList();
            for (Abi abi : NdkHandler.getAbiList()) {
                abiNames.add(abi.getName());
            }
            task.setAndroidBuilder(this.androidBuilder);
            task.nativeBuildConfigurationsJsons = ExternalNativeBuildTaskUtils.getOutputJsons(this.generator.getJsonFolder(), abiNames);
            task.stlSharedObjectFiles = this.generator.getStlSharedObjectFiles();
            task.objFolder = this.generator.getObjFolder();
        }
    }
}

