/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.api.dsl.options

import com.android.build.api.dsl.Initializable
import org.gradle.api.Incubating

/** Base interface for ndk-build per-variant info.
 *
 * This interface is not currently usable. It is a work in progress.
 */
@Incubating
interface ExternalNativeNdkBuildOptions : Initializable<ExternalNativeNdkBuildOptions> {
    /** The ndk-build build system Flags  */
    var arguments: List<String>

    /** The C Flags  */
    var cFlags: List<String>

    /** The CPP Flags  */
    var cppFlags: List<String>

    /** The ABI Filters  */
    var abiFilters: Set<String>

    /** The build targets  */
    var targets: Set<String>
}
