/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AutoValue_SdkBundle;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.util.zip.ZipFile;

@Immutable
@AutoValue
public abstract class SdkBundle
implements Bundle {
    public static final ImmutableSet<ZipPath> NON_MODULE_DIRECTORIES = ImmutableSet.of((Object)ZipPath.create("BUNDLE-METADATA"), (Object)ZipPath.create("META-INF"), (Object)ZipPath.create("aar"));

    public static SdkBundle buildFromZip(ZipFile bundleFile, Integer versionCode) {
        Config.BundleConfig bundleConfig = BundleParser.readBundleConfig(bundleFile);
        return SdkBundle.builder().setModule((BundleModule)BundleParser.sanitize(BundleParser.extractModules(bundleFile, bundleConfig, NON_MODULE_DIRECTORIES)).get(0)).setBundleConfig(bundleConfig).setBundleMetadata(BundleParser.readBundleMetadata(bundleFile)).setVersionCode(versionCode).build();
    }

    public abstract BundleModule getModule();

    @Override
    public BundleModule getModule(BundleModuleName moduleName) {
        Preconditions.checkState((boolean)this.getModule().getName().equals(moduleName), (String)"Module '%s' not found.", (Object)moduleName);
        return this.getModule();
    }

    @Override
    public abstract Config.BundleConfig getBundleConfig();

    @Override
    public abstract BundleMetadata getBundleMetadata();

    public abstract Integer getVersionCode();

    public Version getBundletoolVersion() {
        return Version.of(this.getBundleConfig().getBundletool().getVersion());
    }

    @Override
    public String getPackageName() {
        return this.getModule().getAndroidManifest().getPackageName();
    }

    public String getMajorVersion() {
        XmlProtoElement sdkLibraryTag = this.getSdkLibraryTag();
        return ((XmlProtoAttribute)sdkLibraryTag.getAttribute("http://schemas.android.com/apk/res/android", "versionMajor").get()).getValueAsString();
    }

    public String getPatchVersion() {
        return this.getModule().getAndroidManifest().getMetadataValue("shadow.bundletool.com.android.vending.sdkPatchVersion").orElse("0");
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_SdkBundle.Builder();
    }

    private XmlProtoElement getSdkLibraryTag() {
        return (XmlProtoElement)Iterables.getOnlyElement(this.getModule().getAndroidManifest().getSdkLibraryElements());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setModule(BundleModule var1);

        public abstract Builder setBundleConfig(Config.BundleConfig var1);

        public abstract Builder setBundleMetadata(BundleMetadata var1);

        public abstract Builder setVersionCode(Integer var1);

        public abstract SdkBundle build();
    }
}

