/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class GeneratedApks {
    public abstract ImmutableList<ModuleSplit> getInstantApks();

    public abstract ImmutableList<ModuleSplit> getSplitApks();

    public abstract ImmutableList<ModuleSplit> getStandaloneApks();

    public abstract ImmutableList<ModuleSplit> getSystemApks();

    public abstract ImmutableList<ModuleSplit> getArchivedApks();

    public int size() {
        return this.getInstantApks().size() + this.getSplitApks().size() + this.getStandaloneApks().size() + this.getSystemApks().size() + this.getArchivedApks().size();
    }

    public Stream<ModuleSplit> getAllApksStream() {
        return Stream.of(this.getStandaloneApks(), this.getInstantApks(), this.getSplitApks(), this.getSystemApks(), this.getArchivedApks()).flatMap(Collection::stream);
    }

    public ImmutableListMultimap<VariantKey, ModuleSplit> getAllApksGroupedByOrderedVariants() {
        return this.getAllApksStream().collect(CollectorUtils.groupingBySortedKeys(VariantKey::create, Function.identity()));
    }

    public static Builder builder() {
        return new AutoValue_GeneratedApks.Builder().setInstantApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setSplitApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setStandaloneApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setSystemApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setArchivedApks((ImmutableList<ModuleSplit>)ImmutableList.of());
    }

    public static GeneratedApks fromModuleSplits(ImmutableList<ModuleSplit> moduleSplits) {
        ImmutableMap<ModuleSplit.SplitType, ImmutableList<ModuleSplit>> groups = moduleSplits.stream().collect(CollectorUtils.groupingByDeterministic(ModuleSplit::getSplitType));
        return GeneratedApks.builder().setInstantApks((ImmutableList<ModuleSplit>)((ImmutableList)groups.getOrDefault((Object)ModuleSplit.SplitType.INSTANT, (Object)ImmutableList.of()))).setSplitApks((ImmutableList<ModuleSplit>)((ImmutableList)groups.getOrDefault((Object)ModuleSplit.SplitType.SPLIT, (Object)ImmutableList.of()))).setStandaloneApks((ImmutableList<ModuleSplit>)((ImmutableList)groups.getOrDefault((Object)ModuleSplit.SplitType.STANDALONE, (Object)ImmutableList.of()))).setSystemApks((ImmutableList<ModuleSplit>)((ImmutableList)groups.getOrDefault((Object)ModuleSplit.SplitType.SYSTEM, (Object)ImmutableList.of()))).setArchivedApks((ImmutableList<ModuleSplit>)((ImmutableList)groups.getOrDefault((Object)ModuleSplit.SplitType.ARCHIVE, (Object)ImmutableList.of()))).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInstantApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setSplitApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setStandaloneApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setSystemApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setArchivedApks(ImmutableList<ModuleSplit> var1);

        public abstract GeneratedApks build();
    }
}

