/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.util.Optional;
import org.jose4j.jws.JsonWebSignature;

public final class BundleTransparencyCheckUtils {
    public static TransparencyCheckResult checkTransparency(AppBundle bundle) {
        Optional<ByteSource> signedTransparencyFile = bundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency_signed.jwt");
        if (!signedTransparencyFile.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Bundle does not include code transparency metadata. Run `add-transparency` command to add code transparency metadata to the bundle.").build();
        }
        return BundleTransparencyCheckUtils.checkTransparency(bundle, signedTransparencyFile.get());
    }

    public static TransparencyCheckResult checkTransparency(AppBundle bundle, ByteSource signedTransparencyFile) {
        if (bundle.hasSharedUserId()) {
            throw InvalidBundleException.builder().withUserMessage("Transparency file is present in the bundle, but it can not be verified because `sharedUserId` attribute is specified in one of the manifests.").build();
        }
        TransparencyCheckResult.Builder result = TransparencyCheckResult.builder();
        JsonWebSignature jws = CodeTransparencyCryptoUtils.parseJws(signedTransparencyFile);
        if (!CodeTransparencyCryptoUtils.verifySignature(jws)) {
            return result.errorMessage("Verification failed because code transparency signature is invalid.").build();
        }
        result.transparencySignatureVerified(true).transparencyKeyCertificateFingerprint(CodeTransparencyCryptoUtils.getCertificateFingerprint(jws));
        MapDifference difference = Maps.difference(BundleTransparencyCheckUtils.getCodeRelatedFilesFromTransparencyMetadata(jws), BundleTransparencyCheckUtils.getCodeRelatedFilesFromBundle(bundle));
        result.fileContentsVerified(difference.areEqual());
        if (!difference.areEqual()) {
            result.errorMessage(BundleTransparencyCheckUtils.getDiffAsString((MapDifference<String, CodeTransparencyOuterClass.CodeRelatedFile>)difference));
        }
        return result.build();
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromTransparencyMetadata(JsonWebSignature signedTransparencyFile) {
        return (ImmutableMap)CodeTransparencyFactory.parseFrom(signedTransparencyFile.getUnverifiedPayload()).getCodeRelatedFileList().stream().collect(ImmutableMap.toImmutableMap(CodeTransparencyOuterClass.CodeRelatedFile::getPath, codeRelatedFile -> codeRelatedFile));
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromBundle(AppBundle bundle) {
        return (ImmutableMap)CodeTransparencyFactory.createCodeTransparencyMetadata(bundle).getCodeRelatedFileList().stream().collect(ImmutableMap.toImmutableMap(CodeTransparencyOuterClass.CodeRelatedFile::getPath, codeRelatedFile -> codeRelatedFile));
    }

    private static String getDiffAsString(MapDifference<String, CodeTransparencyOuterClass.CodeRelatedFile> codeTransparencyDiff) {
        if (codeTransparencyDiff.areEqual()) {
            return "";
        }
        return "Verification failed because code was modified after transparency metadata generation. \nFiles deleted after transparency metadata generation: " + codeTransparencyDiff.entriesOnlyOnLeft().keySet() + "\nFiles added after transparency metadata generation: " + codeTransparencyDiff.entriesOnlyOnRight().keySet() + "\nFiles modified after transparency metadata generation: " + codeTransparencyDiff.entriesDiffering().keySet();
    }

    private BundleTransparencyCheckUtils() {
    }
}

