/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.androidtools.AdbCommand;
import com.android.tools.build.bundletool.commands.AutoValue_InstallMultiApksCommand;
import com.android.tools.build.bundletool.commands.AutoValue_InstallMultiApksCommand_PackagePathVersion;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.BadgingInfoParser;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.device.PackagesParser;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.auto.value.AutoValue;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.ByteStreams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class InstallMultiApksCommand {
    private static final Logger logger = Logger.getLogger(InstallMultiApksCommand.class.getName());
    public static final String COMMAND_NAME = "install-multi-apks";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<ImmutableList<Path>> APKS_ARCHIVES_FLAG = Flag.pathList("apks");
    private static final Flag<Path> APKS_ARCHIVE_ZIP_FLAG = Flag.path("apks-zip");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<Boolean> STAGED = Flag.booleanFlag("staged");
    private static final Flag<Boolean> ENABLE_ROLLBACK_FLAG = Flag.booleanFlag("enable-rollback");
    private static final Flag<Boolean> UPDATE_ONLY_FLAG = Flag.booleanFlag("update-only");
    private static final Flag<Path> AAPT2_PATH_FLAG = Flag.path("aapt2");
    private static final Flag<Integer> TIMEOUT_MILLIS_FLAG = Flag.positiveInteger("timeout-millis");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    abstract Path getAdbPath();

    abstract Optional<Aapt2Command> getAapt2Command();

    abstract Optional<AdbCommand> getAdbCommand();

    private AdbCommand getOrCreateAdbCommand() {
        return this.getAdbCommand().orElse(AdbCommand.create(this.getAdbPath()));
    }

    abstract ImmutableList<Path> getApksArchivePaths();

    abstract Optional<Path> getApksArchiveZipPath();

    abstract Optional<String> getDeviceId();

    abstract boolean getEnableRollback();

    abstract boolean getStaged();

    abstract boolean getUpdateOnly();

    abstract AdbServer getAdbServer();

    abstract Optional<Duration> getTimeout();

    public static Builder builder() {
        return new AutoValue_InstallMultiApksCommand.Builder().setStaged(false).setEnableRollback(false).setUpdateOnly(false);
    }

    public static InstallMultiApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return InstallMultiApksCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static InstallMultiApksCommand fromFlags(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, systemEnvironmentProvider);
        Builder command = InstallMultiApksCommand.builder().setAdbPath(adbPath).setAdbServer(adbServer);
        CommandUtils.getDeviceSerialName(flags, DEVICE_ID_FLAG, systemEnvironmentProvider).ifPresent(command::setDeviceId);
        ENABLE_ROLLBACK_FLAG.getValue(flags).ifPresent(command::setEnableRollback);
        UPDATE_ONLY_FLAG.getValue(flags).ifPresent(command::setUpdateOnly);
        STAGED.getValue(flags).ifPresent(command::setStaged);
        AAPT2_PATH_FLAG.getValue(flags).ifPresent(aapt2Path -> command.setAapt2Command(Aapt2Command.createFromExecutablePath(aapt2Path)));
        TIMEOUT_MILLIS_FLAG.getValue(flags).ifPresent(timeoutMillis -> command.setTimeout(Duration.ofMillis(timeoutMillis.intValue())));
        Optional<ImmutableList<Path>> apksPaths = APKS_ARCHIVES_FLAG.getValue(flags);
        Optional<Path> apksArchiveZip = APKS_ARCHIVE_ZIP_FLAG.getValue(flags);
        if (apksPaths.isPresent() == apksArchiveZip.isPresent()) {
            throw InvalidCommandException.builder().withInternalMessage("Exactly one of --apks or --apks-zip must be set.").build();
        }
        apksPaths.ifPresent(command::setApksArchivePaths);
        apksArchiveZip.ifPresent(command::setApksArchiveZipPath);
        flags.checkNoUnknownFlags();
        return command.build();
    }

    public void execute() throws TimeoutException, IOException {
        this.validateInput();
        AdbServer adbServer = this.getAdbServer();
        adbServer.init(this.getAdbPath());
        try (TempDirectory tempDirectory = new TempDirectory();){
            DeviceAnalyzer deviceAnalyzer = new DeviceAnalyzer(adbServer);
            Devices.DeviceSpec deviceSpec = deviceAnalyzer.getDeviceSpec(this.getDeviceId());
            Device device = deviceAnalyzer.getAndValidateDevice(this.getDeviceId());
            if (this.getTimeout().isPresent() && !device.getVersion().isGreaterOrEqualThan(31)) {
                throw InvalidCommandException.builder().withInternalMessage("'%s' flag is supported for Android 12+ devices.", TIMEOUT_MILLIS_FLAG.getName()).build();
            }
            Path aapt2Dir = tempDirectory.getPath().resolve("aapt2");
            Files.createDirectory(aapt2Dir, new FileAttribute[0]);
            com.google.common.base.Supplier aapt2CommandSupplier = Suppliers.memoize(() -> this.getOrExtractAapt2Command(aapt2Dir));
            ImmutableMap<String, PackagesParser.InstalledPackageInfo> existingPackages = InstallMultiApksCommand.getPackagesInstalledOnDevice(device);
            ImmutableList installableApksFilesWithBadgingInfo = (ImmutableList)this.getActualApksPaths(tempDirectory).stream().flatMap(arg_0 -> InstallMultiApksCommand.lambda$execute$3(deviceSpec, (Supplier)aapt2CommandSupplier, arg_0)).filter(apks -> this.shouldInstall((PackagePathVersion)apks, existingPackages)).collect(ImmutableList.toImmutableList());
            ImmutableList apkFilesToInstall = (ImmutableList)InstallMultiApksCommand.uniqueApksByPackageName((ImmutableList<PackagePathVersion>)installableApksFilesWithBadgingInfo).stream().flatMap(apks -> InstallMultiApksCommand.extractApkListFromApks(deviceSpec, apks, Optional.ofNullable(existingPackages.get((Object)apks.getPackageName())), tempDirectory).stream()).collect(ImmutableList.toImmutableList());
            ImmutableListMultimap apkToInstallByPackage = (ImmutableListMultimap)apkFilesToInstall.stream().collect(ImmutableListMultimap.toImmutableListMultimap(PackagePathVersion::getPackageName, packagePathVersion -> packagePathVersion.getPath().toAbsolutePath().toString()));
            if (apkFilesToInstall.isEmpty()) {
                logger.warning("No packages found to install! Exiting...");
                return;
            }
            AdbCommand adbCommand = this.getOrCreateAdbCommand();
            ImmutableList<String> commandResults = adbCommand.installMultiPackage((ImmutableListMultimap<String, String>)apkToInstallByPackage, this.getStaged(), this.getEnableRollback(), this.getTimeout(), this.getDeviceId());
            logger.info(String.format("Output:\n%s", String.join((CharSequence)"\n", commandResults)));
            logger.info("Please reboot device to complete installation.");
        }
    }

    private boolean shouldInstall(PackagePathVersion apk, ImmutableMap<String, PackagesParser.InstalledPackageInfo> existingPackages) {
        if (this.getUpdateOnly() && !existingPackages.containsKey((Object)apk.getPackageName())) {
            logger.info(String.format("Package '%s' not present on device, skipping due to --%s.", apk.getPackageName(), UPDATE_ONLY_FLAG.getName()));
            return false;
        }
        if (!existingPackages.containsKey((Object)apk.getPackageName())) {
            return true;
        }
        PackagesParser.InstalledPackageInfo existingPackage = (PackagesParser.InstalledPackageInfo)existingPackages.get((Object)apk.getPackageName());
        if (existingPackage.getVersionCode() <= apk.getVersionCode()) {
            return true;
        }
        logger.warning(String.format("A higher version of package '%s' (%d vs %d) is already present on device, skipping.", apk.getPackageName(), apk.getVersionCode(), existingPackage.getVersionCode()));
        return false;
    }

    private static ImmutableMap<String, PackagesParser.InstalledPackageInfo> getPackagesInstalledOnDevice(Device device) {
        ImmutableList<String> listPackagesOutput = new AdbShellCommandTask(device, "pm list packages --show-versioncode").execute();
        ImmutableList<String> listApexPackagesOutput = new AdbShellCommandTask(device, "pm list packages --apex-only --show-versioncode").execute();
        ImmutableSet<PackagesParser.InstalledPackageInfo> installedApks = new PackagesParser(false).parse(listPackagesOutput);
        ImmutableSet<PackagesParser.InstalledPackageInfo> installedApexPackages = new PackagesParser(true).parse(listApexPackagesOutput);
        return (ImmutableMap)Streams.concat((Stream[])new Stream[]{installedApks.stream(), installedApexPackages.stream()}).collect(ImmutableMap.toImmutableMap(PackagesParser.InstalledPackageInfo::getPackageName, installedPackageInfo -> installedPackageInfo));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<PackagePathVersion> apksWithPackageName(Path apksArchivePath, Devices.DeviceSpec deviceSpec, Supplier<Aapt2Command> aapt2CommandSupplier) {
        try (TempDirectory tempDirectory = new TempDirectory();){
            Path extractedFile = (Path)ExtractApksCommand.builder().setApksArchivePath(apksArchivePath).setDeviceSpec(deviceSpec).setOutputDirectory(tempDirectory.getPath()).build().execute().get(0);
            BadgingInfoParser.BadgingInfo badgingInfo = BadgingInfoParser.parse(aapt2CommandSupplier.get().dumpBadging(extractedFile));
            Optional<PackagePathVersion> optional = Optional.of(PackagePathVersion.create(apksArchivePath, badgingInfo.getPackageName(), badgingInfo.getVersionCode()));
            return optional;
        }
        catch (IncompatibleDeviceException e5) {
            logger.warning(String.format("Unable to determine package name of %s, as it is not compatible with the attached device. Skipping.", apksArchivePath));
            return Optional.empty();
        }
    }

    private void validateInput() {
        this.getApksArchiveZipPath().ifPresent(zip -> {
            FilePreconditions.checkFileExistsAndReadable(zip);
            FilePreconditions.checkFileHasExtension("ZIP file", zip, ".zip");
        });
        this.getApksArchivePaths().forEach(InstallMultiApksCommand::checkValidApksFile);
        FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath());
    }

    private static void checkValidApksFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        FilePreconditions.checkFileHasExtension("APKS file", path, ".apks");
    }

    private static ImmutableList<PackagePathVersion> extractApkListFromApks(Devices.DeviceSpec deviceSpec, PackagePathVersion apksArchive, Optional<PackagesParser.InstalledPackageInfo> installedPackage, TempDirectory tempDirectory) {
        logger.info(String.format("Extracting package '%s'", apksArchive.getPackageName()));
        try {
            Path output = tempDirectory.getPath().resolve(apksArchive.getPackageName());
            Files.createDirectory(output, new FileAttribute[0]);
            ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(apksArchive.getPath()).setDeviceSpec(deviceSpec).setOutputDirectory(output);
            ImmutableList<Path> extractedPaths = InstallMultiApksCommand.fixExtension(extractApksCommand.build().execute(), installedPackage.map(PackagesParser.InstalledPackageInfo::isApex).orElse(false));
            return (ImmutableList)extractedPaths.stream().map(path -> PackagePathVersion.create(path, apksArchive.getPackageName(), apksArchive.getVersionCode())).collect(ImmutableList.toImmutableList());
        }
        catch (IncompatibleDeviceException e5) {
            logger.warning(String.format("Package '%s' is not supported by the attached device (SDK version %d). Skipping.", apksArchive.getPackageName(), deviceSpec.getSdkVersion()));
            return ImmutableList.of();
        }
        catch (IOException e6) {
            throw new UncheckedIOException(e6);
        }
    }

    private static ImmutableList<Path> fixExtension(ImmutableList<Path> extractedPaths, boolean isApex) throws IOException {
        if (!isApex) {
            return extractedPaths;
        }
        ImmutableList.Builder newPaths = ImmutableList.builder();
        for (Path path : extractedPaths) {
            Path withApexExtension = path.resolveSibling(com.google.common.io.Files.getNameWithoutExtension((String)path.toString()) + ".apex");
            Files.move(path, withApexExtension, new CopyOption[0]);
            newPaths.add((Object)withApexExtension);
        }
        return newPaths.build();
    }

    private ImmutableList<Path> getActualApksPaths(TempDirectory tempDirectory) throws IOException {
        return this.getApksArchiveZipPath().isPresent() ? InstallMultiApksCommand.extractApksFromZip(this.getApksArchiveZipPath().get(), tempDirectory) : this.getApksArchivePaths();
    }

    private static ImmutableList<Path> extractApksFromZip(Path zipPath, TempDirectory tempDirectory) throws IOException {
        ImmutableList.Builder extractedApks = ImmutableList.builder();
        Path zipExtractedSubDirectory = tempDirectory.getPath().resolve("extracted");
        Files.createDirectory(zipExtractedSubDirectory, new FileAttribute[0]);
        try (ZipFile apksArchiveContainer = new ZipFile(zipPath.toFile());){
            ImmutableList apksToExtractList = (ImmutableList)apksArchiveContainer.stream().filter(zipEntry -> !zipEntry.isDirectory() && zipEntry.getName().toLowerCase(Locale.ROOT).endsWith(".apks")).collect(ImmutableList.toImmutableList());
            for (ZipEntry apksToExtract : apksToExtractList) {
                Path extractedApksPath = zipExtractedSubDirectory.resolve(ZipPath.create(apksToExtract.getName()).toString());
                Files.createDirectories(extractedApksPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = apksArchiveContainer.getInputStream(apksToExtract);
                Throwable throwable = null;
                try {
                    OutputStream outputApks = Files.newOutputStream(extractedApksPath, new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputApks);
                        extractedApks.add((Object)extractedApksPath);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputApks == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputApks.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        outputApks.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return extractedApks.build();
    }

    private static ImmutableList<PackagePathVersion> uniqueApksByPackageName(ImmutableList<PackagePathVersion> installableApksFiles) {
        return (ImmutableList)installableApksFiles.stream().collect(Collectors.groupingBy(PackagePathVersion::getPackageName, Collectors.maxBy(Comparator.comparing(PackagePathVersion::getVersionCode)))).values().stream().flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Atomically install APKs and APEXs from multiple APK Sets to a connected device.").addAdditionalParagraph("This will extract and install from the APK Sets only the APKs that would be served to that device. If the app is not compatible with the device or if the APK Set was generated for a different type of device, this command will fail. If any one of the APK Sets fails to install, none of the APK Sets will be installed.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set.", "ANDROID_HOME", "PATH").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected.", "ANDROID_SERIAL").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVES_FLAG.getName()).setExampleValue("/path/to/apks1.apks,/path/to/apks2.apks").setOptional(true).setDescription("The list of .apks files to install. Either --apks or --apks-zip is required.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_ZIP_FLAG.getName()).setExampleValue("/path/to/apks_containing.zip").setOptional(true).setDescription("Zip file containing .apks files to install. Either --apks or --apks-zip is required.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(STAGED.getName()).setOptional(true).setDescription("Marks the installation as staged, to be applied on device reboot. Enabled automatically for APEX packages.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ENABLE_ROLLBACK_FLAG.getName()).setOptional(true).setDescription("Enables rollback of the entire atomic install by rolling back any one of the packages.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(UPDATE_ONLY_FLAG.getName()).setOptional(true).setDescription("If set, only packages that are already installed on the device will be updated. Entirely new packages will not be installed.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(AAPT2_PATH_FLAG.getName()).setExampleValue("path/to/aapt2").setOptional(true).setDescription("Path to the aapt2 binary to use.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(TIMEOUT_MILLIS_FLAG.getName()).setExampleValue("60000").setOptional(true).setDescription("Timeout in milliseconds which is passed to 'adb install-multi-package' command. One minute, by default. Only available for Android 12+ devices.").build()).build();
    }

    private Aapt2Command getOrExtractAapt2Command(Path tempDirectoryForJarCommand) {
        if (this.getAapt2Command().isPresent()) {
            return this.getAapt2Command().get();
        }
        return CommandUtils.extractAapt2FromJar(tempDirectoryForJarCommand);
    }

    private static /* synthetic */ Stream lambda$execute$3(Devices.DeviceSpec deviceSpec, Supplier aapt2CommandSupplier, Path apksArchivePath) {
        return Streams.stream(InstallMultiApksCommand.apksWithPackageName(apksArchivePath, deviceSpec, aapt2CommandSupplier));
    }

    @AutoValue
    static abstract class PackagePathVersion {
        public static PackagePathVersion create(Path path, String packageName, long versionCode) {
            return new AutoValue_InstallMultiApksCommand_PackagePathVersion(path, packageName, versionCode);
        }

        public abstract Path getPath();

        public abstract String getPackageName();

        public abstract long getVersionCode();

        PackagePathVersion() {
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setAdbPath(Path var1);

        @CanIgnoreReturnValue
        abstract Builder setAapt2Command(Aapt2Command var1);

        abstract Builder setAdbCommand(AdbCommand var1);

        @CanIgnoreReturnValue
        abstract Builder setApksArchivePaths(ImmutableList<Path> var1);

        abstract ImmutableList.Builder<Path> apksArchivePathsBuilder();

        @CanIgnoreReturnValue
        abstract Builder setApksArchiveZipPath(Path var1);

        @CanIgnoreReturnValue
        Builder addApksArchivePath(Path value) {
            this.apksArchivePathsBuilder().add((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        abstract Builder setDeviceId(String var1);

        abstract Builder setEnableRollback(boolean var1);

        abstract Builder setStaged(boolean var1);

        abstract Builder setUpdateOnly(boolean var1);

        abstract Builder setAdbServer(AdbServer var1);

        abstract Builder setTimeout(Duration var1);

        public abstract InstallMultiApksCommand build();
    }
}

