/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.graph.Z;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.a;
import shadow.bundletool.com.android.tools.r8.q.a.a.b.X;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationParser;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSource;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.T0;
import shadow.bundletool.com.android.tools.r8.utils.e;
import shadow.bundletool.com.android.tools.r8.utils.k0;

public class GenerateMainDexListCommand
extends BaseCommand {
    static final String j = String.join((CharSequence)"\n", X.a("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --lib <file>             # Add <file> as a library resource.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));
    private final List<ProguardConfigurationRule> e;
    private final StringConsumer f;
    private final GraphConsumer g;
    private final Z h;
    private final T0 i;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder parse(String[] stringArray) {
        Builder builder = GenerateMainDexListCommand.builder();
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            String string = stringArray[i4].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.startsWith("--")) {
                builder.b().error(new StringDiagnostic("Unknown option: " + string, a.a));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        return builder;
    }

    private GenerateMainDexListCommand(Z z4, e e4, List<ProguardConfigurationRule> list2, StringConsumer stringConsumer, GraphConsumer graphConsumer, T0 t02) {
        super(e4);
        this.h = z4;
        this.e = list2;
        this.f = stringConsumer;
        this.g = graphConsumer;
        this.i = t02;
    }

    private GenerateMainDexListCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.h = new Z();
        this.e = X.g();
        this.f = null;
        this.g = null;
        this.i = new T0();
    }

    public StringConsumer getMainDexListConsumer() {
        return this.f;
    }

    T0 b() {
        return this.i;
    }

    @Override
    k0 a() {
        k0 k02;
        k0 k03 = k02;
        GenerateMainDexListCommand generateMainDexListCommand = z4;
        GenerateMainDexListCommand generateMainDexListCommand2 = z4;
        GenerateMainDexListCommand generateMainDexListCommand3 = z4;
        GenerateMainDexListCommand generateMainDexListCommand4 = z4;
        Z z4 = generateMainDexListCommand4.h;
        k03(z4, generateMainDexListCommand4.i);
        k03.d = ClassFileConsumer.emptyConsumer();
        k03.W0 = generateMainDexListCommand3.e;
        k03.e1 = generateMainDexListCommand2.f;
        k02.n1 = generateMainDexListCommand.g;
        k02.X0 = k02.R0;
        k02.a0 = false;
        k02.y = false;
        return k02;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final Z f;
        private final List<ProguardConfigurationSource> g;
        private StringConsumer h;
        private GraphConsumer i;

        private Builder() {
            ArrayList arrayList;
            Z z4;
            Object object = z4;
            z4 = new Z();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            ArrayList arrayList;
            Z z4;
            Object object = z4;
            z4 = new Z();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        public Builder addMainDexRulesFiles(Path ... pathArray) {
            Builder builder = this;
            builder.a(() -> {
                for (Path path : pathArray) {
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRulesFiles(List<Path> list2) {
            Builder builder = this;
            builder.a(() -> {
                list2 = list2.iterator();
                while (list2.hasNext()) {
                    Path path = (Path)list2.next();
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRules(List<String> list2, Origin origin) {
            Builder builder = this;
            builder.a(() -> this.g.add(new ProguardConfigurationSourceStrings(list2, Paths.get(".", new String[0]), origin)));
            return builder;
        }

        public Builder setMainDexListOutputPath(Path path) {
            this.h = new StringConsumer.FileConsumer(path);
            return this;
        }

        public Builder setMainDexListConsumer(StringConsumer stringConsumer) {
            this.h = stringConsumer;
            return this;
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.i = graphConsumer;
            return this;
        }

        @Override
        protected BaseCommand c() {
            GenerateMainDexListCommand generateMainDexListCommand;
            if (!((BaseCommand.Builder)((Object)z4)).isPrintHelp() && !((BaseCommand.Builder)((Object)z4)).isPrintVersion()) {
                GenerateMainDexListCommand generateMainDexListCommand2;
                List<ProguardConfigurationRule> list2;
                if (((Builder)((Object)z4)).g.isEmpty()) {
                    list2 = X.g();
                } else {
                    Builder builder = z4;
                    list2 = builder.f;
                    ProguardConfigurationParser proguardConfigurationParser = new ProguardConfigurationParser((Z)((Object)list2), builder.b());
                    proguardConfigurationParser.parse(((Builder)((Object)z4)).g);
                    list2 = proguardConfigurationParser.getConfig().getRules();
                }
                generateMainDexListCommand = generateMainDexListCommand2;
                Builder builder = z4;
                Z z4 = builder.f;
                e e4 = builder.a().a();
                StringConsumer stringConsumer = builder.h;
                GraphConsumer graphConsumer = builder.i;
                T0 t02 = builder.b();
                generateMainDexListCommand2 = new GenerateMainDexListCommand(z4, e4, list2, stringConsumer, graphConsumer, t02);
            } else {
                GenerateMainDexListCommand generateMainDexListCommand3;
                generateMainDexListCommand = generateMainDexListCommand3;
                Builder builder = z4;
                boolean bl = builder.isPrintHelp();
                generateMainDexListCommand3 = new GenerateMainDexListCommand(bl, builder.isPrintVersion());
            }
            return generateMainDexListCommand;
        }

        @Override
        BaseCommand.Builder d() {
            return this;
        }
    }
}

