/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javax.annotation.Nullable;
import shadow.bundletool.com.android.apksig.apk.ApkSigningBlockNotFoundException;
import shadow.bundletool.com.android.apksig.apk.ApkUtils;
import shadow.bundletool.com.android.apksig.internal.apk.ApkSigningBlockUtils;
import shadow.bundletool.com.android.apksig.internal.util.Pair;
import shadow.bundletool.com.android.apksig.util.DataSource;
import shadow.bundletool.com.android.apksig.util.DataSources;
import shadow.bundletool.com.android.apksig.zip.ZipFormatException;

public final class SigningBlockUtils {
    private static final int MAGIC_NUM_BYTES = 16;
    private static final int BLOCK_LENGTH_NUM_BYTES = 8;
    static final int SIZE_OF_BLOCK_NUM_BYTES = 8;
    static final int BLOCK_ID_NUM_BYTES = 4;
    static final int ANDROID_COMMON_PAGE_ALIGNMENT_NUM_BYTES = 4096;
    static final int VERITY_PADDING_BLOCK_ID = 1114793335;

    public static byte[] addToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        if (blockValue == null || blockValue.length == 0) {
            return signingBlock;
        }
        if (signingBlock == null || signingBlock.length == 0) {
            return SigningBlockUtils.createSigningBlock(blockValue, blockId);
        }
        return SigningBlockUtils.appendToSigningBlock(signingBlock, blockValue, blockId);
    }

    private static byte[] appendToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        ImmutableList entries = ImmutableList.builder().addAll(SigningBlockUtils.extractAllSigners(DataSources.asDataSource(ByteBuffer.wrap(signingBlock)))).add(Pair.of(blockValue, blockId)).build();
        return ApkSigningBlockUtils.generateApkSigningBlock((List<Pair<byte[], Integer>>)entries);
    }

    private static byte[] createSigningBlock(byte[] blockValue, int blockId) {
        return ApkSigningBlockUtils.generateApkSigningBlock((List<Pair<byte[], Integer>>)ImmutableList.of(Pair.of(blockValue, blockId)));
    }

    private static ImmutableList<Pair<byte[], Integer>> extractAllSigners(DataSource signingBlock) throws IOException {
        long wholeBlockSize = signingBlock.size();
        DataSource lengthPrefixedIdValuePairsSource = signingBlock.slice(8L, wholeBlockSize - 16L - 16L);
        int lengthAndIdByteCount = 12;
        ByteBuffer lengthAndId = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        ImmutableList.Builder idValuePairs = ImmutableList.builder();
        int index = 0;
        while ((long)index <= lengthPrefixedIdValuePairsSource.size() - 12L) {
            lengthPrefixedIdValuePairsSource.copyTo(index, 12, lengthAndId);
            lengthAndId.flip();
            int blockLength = Ints.checkedCast((long)lengthAndId.getLong());
            int id = lengthAndId.getInt();
            lengthAndId.clear();
            if (id != 1114793335) {
                int blockValueSize = blockLength - 4;
                ByteBuffer blockValue = ByteBuffer.allocate(blockValueSize);
                lengthPrefixedIdValuePairsSource.copyTo(index + 8 + 4, blockValueSize, blockValue);
                idValuePairs.add(Pair.of(blockValue.array(), id));
            }
            index += blockLength + 8;
        }
        return idValuePairs.build();
    }

    @Nullable
    public static ByteBuffer extractBlock(File apk, int blockId) throws IOException, ZipFormatException, ApkSigningBlockNotFoundException {
        try (RandomAccessFile file = new RandomAccessFile(apk, "r");){
            DataSource apkDataSource = DataSources.asDataSource(file);
            ApkUtils.ApkSigningBlock signingBlockInfo = ApkUtils.findApkSigningBlock(apkDataSource, ApkUtils.findZipSections(apkDataSource));
            DataSource wholeV2Block = signingBlockInfo.getContents();
            int lengthAndIdByteCount = 12;
            DataSource signingBlock = wholeV2Block.slice(8L, wholeV2Block.size() - 8L - 16L);
            ByteBuffer lengthAndId = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
            int index = 0;
            while ((long)index <= signingBlock.size() - 12L) {
                signingBlock.copyTo(index, 12, lengthAndId);
                lengthAndId.flip();
                int blockLength = (int)lengthAndId.getLong();
                int id = lengthAndId.getInt();
                lengthAndId.flip();
                if (id == blockId) {
                    ByteBuffer block = ByteBuffer.allocate(blockLength - 4);
                    signingBlock.copyTo(index + 12, blockLength - 4, block);
                    block.flip();
                    ByteBuffer byteBuffer = block;
                    return byteBuffer;
                }
                index += blockLength + 8;
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
    }

    private SigningBlockUtils() {
    }
}

