/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.nio.charset.Charset;

public final class CodeTransparencyChecker {
    public static TransparencyCheckResult checkTransparency(AppBundle bundle, ByteSource transparencyFile) {
        ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromBundle;
        ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromTransparencyMetadata;
        if (bundle.hasSharedUserId()) {
            throw InvalidBundleException.builder().withUserMessage("Transparency file is present in the bundle, but it can not be verified because `sharedUserId` attribute is specified in one of the manifests.").build();
        }
        try {
            codeRelatedFilesFromTransparencyMetadata = CodeTransparencyChecker.getCodeRelatedFilesFromTransparencyMetadata(transparencyFile);
            codeRelatedFilesFromBundle = CodeTransparencyChecker.getCodeRelatedFilesFromBundle(bundle);
        }
        catch (IOException e4) {
            throw InvalidBundleException.builder().withUserMessage("Unable to verify code transparency for bundle.").withCause(e4).build();
        }
        return TransparencyCheckResult.create(codeRelatedFilesFromTransparencyMetadata, codeRelatedFilesFromBundle);
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromTransparencyMetadata(ByteSource transparencyFile) throws IOException {
        CodeTransparencyOuterClass.CodeTransparency.Builder transparencyMetadata = CodeTransparencyOuterClass.CodeTransparency.newBuilder();
        JsonFormat.parser().merge(transparencyFile.asCharSource(Charset.defaultCharset()).read(), (Message.Builder)transparencyMetadata);
        return (ImmutableMap)transparencyMetadata.getCodeRelatedFileList().stream().collect(ImmutableMap.toImmutableMap(CodeTransparencyOuterClass.CodeRelatedFile::getPath, codeRelatedFile -> codeRelatedFile));
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromBundle(AppBundle bundle) {
        return (ImmutableMap)CodeTransparencyFactory.createCodeTransparencyMetadata(bundle).getCodeRelatedFileList().stream().collect(ImmutableMap.toImmutableMap(CodeTransparencyOuterClass.CodeRelatedFile::getPath, codeRelatedFile -> codeRelatedFile));
    }

    private CodeTransparencyChecker() {
    }
}

