/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils.concurrency;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshadow/bundletool/com/android/utils/concurrency/EvictingExecutor;", "Ljava/util/concurrent/AbstractExecutorService;", "delegateExecutor", "Ljava/util/concurrent/ExecutorService;", "maxQueueingTasks", "", "(Ljava/util/concurrent/ExecutorService;I)V", "evictingQueue", "Ljava/util/Queue;", "Ljava/lang/Runnable;", "evictingQueueLock", "Ljava/util/concurrent/locks/ReentrantLock;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "isShutdown", "isTerminated", "queueProcessor", "shutdown", "shutdownNow", "", "common"})
public final class EvictingExecutor
extends AbstractExecutorService {
    @NotNull
    private final ExecutorService delegateExecutor;
    @NotNull
    private final ReentrantLock evictingQueueLock;
    @NotNull
    private final Queue<Runnable> evictingQueue;

    public EvictingExecutor(@NotNull ExecutorService delegateExecutor, int maxQueueingTasks) {
        Intrinsics.checkNotNullParameter((Object)delegateExecutor, (String)"delegateExecutor");
        this.delegateExecutor = delegateExecutor;
        this.evictingQueueLock = new ReentrantLock();
        EvictingQueue evictingQueue = EvictingQueue.create((int)maxQueueingTasks);
        Intrinsics.checkNotNullExpressionValue((Object)evictingQueue, (String)"create<Runnable>(maxQueueingTasks)");
        this.evictingQueue = (Queue)evictingQueue;
    }

    public /* synthetic */ EvictingExecutor(ExecutorService executorService, int n11, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 2) != 0) {
            n11 = 1;
        }
        this(executorService, n11);
    }

    private final void queueProcessor() {
        this.delegateExecutor.execute(new Runnable(this){
            final /* synthetic */ EvictingExecutor this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object object;
                try {
                    Runnable runnable;
                    object = EvictingExecutor.access$getEvictingQueueLock$p(this.this$0);
                    EvictingExecutor evictingExecutor = this.this$0;
                    object.lock();
                    try {
                        boolean bl2 = false;
                        runnable = (Runnable)EvictingExecutor.access$getEvictingQueue$p(evictingExecutor).remove();
                    }
                    finally {
                        object.unlock();
                    }
                    object = runnable;
                }
                catch (NoSuchElementException e11) {
                    return;
                }
                Object runnable = object;
                runnable.run();
            }
        });
    }

    @Override
    public boolean isTerminated() {
        return this.delegateExecutor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (this.delegateExecutor.isTerminated()) {
            return;
        }
        Lock lock = this.evictingQueueLock;
        lock.lock();
        try {
            boolean bl2 = false;
            int before = this.evictingQueue.size();
            this.evictingQueue.offer(command);
            if (before != this.evictingQueue.size()) {
                this.queueProcessor();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List pendingRunnables = new ArrayList();
        Object object = this.evictingQueueLock;
        object.lock();
        try {
            boolean bl2 = false;
            bl2 = CollectionsKt.removeAll((Iterable)this.evictingQueue, (Function1)((Function1)new Function1<Runnable, Boolean>((List<Runnable>)pendingRunnables){
                final /* synthetic */ List<Runnable> $pendingRunnables;
                {
                    this.$pendingRunnables = $pendingRunnables;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Runnable it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return this.$pendingRunnables.add(it);
                }
            }));
        }
        finally {
            object.unlock();
        }
        Object $this$shutdownNow_u24lambda_u242 = object = pendingRunnables;
        boolean bl3 = false;
        List<Runnable> list2 = this.delegateExecutor.shutdownNow();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"delegateExecutor.shutdownNow()");
        $this$shutdownNow_u24lambda_u242.addAll((Collection)list2);
        return object;
    }

    @Override
    public boolean isShutdown() {
        return this.delegateExecutor.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.delegateExecutor.awaitTermination(timeout, unit);
    }

    public static final /* synthetic */ ReentrantLock access$getEvictingQueueLock$p(EvictingExecutor $this) {
        return $this.evictingQueueLock;
    }

    public static final /* synthetic */ Queue access$getEvictingQueue$p(EvictingExecutor $this) {
        return $this.evictingQueue;
    }
}

