/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PathMatcher {
    private static final ImmutableSet<Character> REGEXP_SPECIAL_CHARS = (ImmutableSet)"<([{\\^-=$!|]})?*+.>".chars().mapToObj(c11 -> Character.valueOf((char)c11)).collect(ImmutableSet.toImmutableSet());
    private final Pattern regexpPattern;

    private PathMatcher(Pattern regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    public static PathMatcher createFromGlob(String globPattern) {
        try {
            Pattern regexpPattern = Pattern.compile(PathMatcher.convertGlobToRegexp(globPattern));
            return new PathMatcher(regexpPattern);
        }
        catch (PatternSyntaxException e11) {
            throw new GlobPatternSyntaxException(globPattern, e11);
        }
    }

    public boolean matches(String input) {
        return this.regexpPattern.matcher(input).matches();
    }

    private static String convertGlobToRegexp(String globPattern) {
        StringBuilder regexpBuilder = new StringBuilder().append('^');
        boolean inGroup = false;
        int openingGroupIdx = 0;
        block10: for (int i11 = 0; i11 < globPattern.length(); ++i11) {
            switch (globPattern.charAt(i11)) {
                case '\\': {
                    if (i11 == globPattern.length() - 1) {
                        throw new GlobPatternSyntaxException("No character to escape.", globPattern, i11);
                    }
                    regexpBuilder.append('\\').append(globPattern.charAt(i11 + 1));
                    ++i11;
                    continue block10;
                }
                case '*': {
                    if (i11 + 1 < globPattern.length() && globPattern.charAt(i11 + 1) == '*') {
                        ++i11;
                        regexpBuilder.append(".*?");
                        continue block10;
                    }
                    regexpBuilder.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regexpBuilder.append(".");
                    continue block10;
                }
                case '[': {
                    char currentChar;
                    char nextChar;
                    int openBracketIdx = i11++;
                    regexpBuilder.append('[');
                    char c11 = nextChar = i11 < globPattern.length() ? globPattern.charAt(i11) : (char)'\u0000';
                    if (nextChar == '^') {
                        regexpBuilder.append('\\');
                    } else if (nextChar == '!') {
                        regexpBuilder.append('^');
                    }
                    while (i11 < globPattern.length() && globPattern.charAt(i11) != ']') {
                        currentChar = globPattern.charAt(i11);
                        if (currentChar == '/') {
                            throw new GlobPatternSyntaxException("Character '/' is not allowed within a character set", globPattern, i11);
                        }
                        regexpBuilder.append(globPattern.charAt(i11));
                        ++i11;
                    }
                    if (i11 == globPattern.length()) {
                        throw new GlobPatternSyntaxException("No matching ']' found.", globPattern, openBracketIdx);
                    }
                    if (i11 == openBracketIdx + 1) {
                        throw new GlobPatternSyntaxException("Empty characters set.", globPattern, openBracketIdx);
                    }
                    regexpBuilder.append(globPattern.charAt(i11));
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new GlobPatternSyntaxException("Cannot nest groups.", globPattern, i11);
                    }
                    openingGroupIdx = i11;
                    inGroup = true;
                    regexpBuilder.append("(?:");
                    continue block10;
                }
                case '}': {
                    if (!inGroup) {
                        throw new GlobPatternSyntaxException("No matching '{' found.", globPattern, i11);
                    }
                    regexpBuilder.append(')');
                    inGroup = false;
                    continue block10;
                }
                case ']': {
                    throw new GlobPatternSyntaxException("No matching '[' found.", globPattern, i11);
                }
                case ',': {
                    if (inGroup) {
                        regexpBuilder.append('|');
                        continue block10;
                    }
                    regexpBuilder.append(',');
                    continue block10;
                }
                default: {
                    char currentChar = globPattern.charAt(i11);
                    if (REGEXP_SPECIAL_CHARS.contains((Object)Character.valueOf(currentChar))) {
                        regexpBuilder.append('\\');
                    }
                    regexpBuilder.append(currentChar);
                }
            }
        }
        if (inGroup) {
            throw new GlobPatternSyntaxException("No matching '}' found.", globPattern, openingGroupIdx);
        }
        return regexpBuilder.append('$').toString();
    }

    public static class GlobPatternSyntaxException
    extends RuntimeException {
        private GlobPatternSyntaxException(String message2, String globPattern, int index) {
            super(String.format("Unable to parse glob pattern '%s' at character %d. Error: %s", globPattern, index + 1, message2));
        }

        private GlobPatternSyntaxException(String globPattern, Throwable cause) {
            super(String.format("Unable to parse glob pattern '%s'.", globPattern), cause);
        }
    }
}

