/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import shadow.bundletool.com.android.zipflinger.Ints;
import shadow.bundletool.com.android.zipflinger.Location;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

public class Zip64Eocd {
    private static final int SIGNATURE = 101075792;
    static final int SIZE = 56;
    private long numEntries;
    private Location cdLocation;

    public Zip64Eocd(long numEntries, Location cdLocation) {
        this.numEntries = numEntries;
        this.cdLocation = cdLocation;
    }

    private Zip64Eocd() {
        this(0L, Location.INVALID);
    }

    public Location write(ZipWriter writer) throws IOException {
        ByteBuffer eocd = ByteBuffer.allocate(56).order(ByteOrder.LITTLE_ENDIAN);
        eocd.putInt(101075792);
        eocd.putLong(44L);
        eocd.putShort((short)0);
        eocd.putShort((short)45);
        eocd.putInt(0);
        eocd.putInt(0);
        eocd.putLong(this.numEntries);
        eocd.putLong(this.numEntries);
        eocd.putLong(this.cdLocation.size());
        eocd.putLong(this.cdLocation.first);
        eocd.rewind();
        long position = writer.position();
        writer.write(eocd);
        return new Location(position, 56L);
    }

    Location getCdLocation() {
        return this.cdLocation;
    }

    static Zip64Eocd parse(FileChannel channel, long eocdOffset) throws IOException {
        Zip64Eocd zip64Eocd = new Zip64Eocd();
        long fileSize = channel.size();
        if (eocdOffset < 0L || eocdOffset + 56L > fileSize) {
            return zip64Eocd;
        }
        ByteBuffer buffer = ByteBuffer.allocate(56).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer, eocdOffset);
        buffer.rewind();
        int signature = buffer.getInt();
        if (signature != 101075792) {
            return zip64Eocd;
        }
        buffer.position(buffer.position() + 28);
        long numEntries = buffer.getLong();
        long size = Ints.ulongToLong(buffer.getLong());
        long offset = Ints.ulongToLong(buffer.getLong());
        zip64Eocd.numEntries = numEntries;
        zip64Eocd.cdLocation = new Location(offset, size);
        return zip64Eocd;
    }
}

