/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingGenerator;
import com.android.tools.build.bundletool.model.utils.TargetingNormalizer;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.Int32Value;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class TargetingUtils {
    public static ImmutableList<TargetingDimension> getTargetingDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList.Builder dimensions = new ImmutableList.Builder();
        if (targeting.hasAbi()) {
            dimensions.add((Object)TargetingDimension.ABI);
        }
        if (targeting.hasTextureCompressionFormat()) {
            dimensions.add((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
        }
        if (targeting.hasLanguage()) {
            dimensions.add((Object)TargetingDimension.LANGUAGE);
        }
        if (targeting.hasDeviceTier()) {
            dimensions.add((Object)TargetingDimension.DEVICE_TIER);
        }
        if (targeting.hasCountrySet()) {
            dimensions.add((Object)TargetingDimension.COUNTRY_SET);
        }
        return dimensions.build();
    }

    public static Optional<Targeting.AssetsDirectoryTargeting> extractDimensionTargeting(Targeting.AssetsDirectoryTargeting directoryTargeting, TargetingDimension dimension) {
        if (dimension.equals((Object)TargetingDimension.ABI) && directoryTargeting.hasAbi()) {
            return Optional.of(Targeting.AssetsDirectoryTargeting.newBuilder().setAbi(directoryTargeting.getAbi()).build());
        }
        if (dimension.equals((Object)TargetingDimension.COUNTRY_SET) && directoryTargeting.hasCountrySet()) {
            return Optional.of(Targeting.AssetsDirectoryTargeting.newBuilder().setCountrySet(directoryTargeting.getCountrySet()).build());
        }
        if (dimension.equals((Object)TargetingDimension.DEVICE_TIER) && directoryTargeting.hasDeviceTier()) {
            return Optional.of(Targeting.AssetsDirectoryTargeting.newBuilder().setDeviceTier(directoryTargeting.getDeviceTier()).build());
        }
        if (dimension.equals((Object)TargetingDimension.LANGUAGE) && directoryTargeting.hasLanguage()) {
            return Optional.of(Targeting.AssetsDirectoryTargeting.newBuilder().setLanguage(directoryTargeting.getLanguage()).build());
        }
        if (dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT) && directoryTargeting.hasTextureCompressionFormat()) {
            return Optional.of(Targeting.AssetsDirectoryTargeting.newBuilder().setTextureCompressionFormat(directoryTargeting.getTextureCompressionFormat()).build());
        }
        return Optional.empty();
    }

    public static ImmutableSet<Targeting.VariantTargeting> generateAllVariantTargetings(ImmutableSet<Targeting.VariantTargeting> variantTargetings) {
        if (variantTargetings.size() <= 1) {
            return variantTargetings;
        }
        ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings = TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList())));
        return (ImmutableSet)sdkVersionTargetings.stream().map(sdkVersionTargeting -> Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting((Targeting.SdkVersionTargeting)sdkVersionTargeting).build()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Targeting.VariantTargeting> cropVariantsWithAppSdkRange(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> sdkRange) {
        ImmutableList<Range<Integer>> ranges = TargetingUtils.calculateVariantSdkRanges(variantTargetings, sdkRange);
        return (ImmutableSet)ranges.stream().map(range -> TargetingUtils.sdkVariantTargeting((Integer)range.lowerEndpoint())).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableList<Range<Integer>> calculateVariantSdkRanges(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> appSdkRange) {
        return (ImmutableList)TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList()))).stream().map(sdkTargeting -> Range.closedOpen((Comparable)Integer.valueOf(TargetingUtils.getMinSdk(sdkTargeting)), (Comparable)Integer.valueOf(TargetingUtils.getMaxSdk(sdkTargeting)))).filter(arg_0 -> appSdkRange.isConnected(arg_0)).map(arg_0 -> appSdkRange.intersection(arg_0)).filter((Predicate<Range>)Predicates.not(Range::isEmpty)).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<Targeting.SdkVersionTargeting> disjointSdkTargetings(ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings) {
        sdkVersionTargetings.forEach(sdkVersionTargeting -> Preconditions.checkState((sdkVersionTargeting.getValueList().size() == 1 ? 1 : 0) != 0));
        ImmutableList minSdkValues = (ImmutableList)sdkVersionTargetings.stream().map(sdkVersionTargeting -> sdkVersionTargeting.getValue(0).getMin().getValue()).distinct().sorted().collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersions = (ImmutableSet)minSdkValues.stream().map(TargetingProtoUtils::sdkVersionFrom).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)sdkVersions.stream().map(sdkVersion -> TargetingProtoUtils.sdkVersionTargeting(sdkVersion, (ImmutableSet<Targeting.SdkVersion>)Sets.difference((Set)sdkVersions, (Set)ImmutableSet.of((Object)sdkVersion)).immutableCopy())).collect(ImmutableList.toImmutableList());
    }

    public static int getMinSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        if (sdkVersionTargeting.getValueList().isEmpty()) {
            return 1;
        }
        return ((Targeting.SdkVersion)Iterables.getOnlyElement(sdkVersionTargeting.getValueList())).getMin().getValue();
    }

    public static int getMaxSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        int minSdk = TargetingUtils.getMinSdk(sdkVersionTargeting);
        int alternativeMinSdk = sdkVersionTargeting.getAlternativesList().stream().mapToInt(alternativeSdk -> alternativeSdk.getMin().getValue()).filter(sdkValue -> minSdk < sdkValue).min().orElse(Integer.MAX_VALUE);
        return alternativeMinSdk;
    }

    private static Targeting.VariantTargeting sdkVariantTargeting(int minSdk) {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(TargetingProtoUtils.sdkVersionFrom(minSdk))).build();
    }

    public static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getApkTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = TargetingUtils.sdkVariantTargeting(standaloneApk.getAndroidManifest().getEffectiveMinSdkVersion()).toBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        if (apkTargeting.hasMultiAbiTargeting()) {
            variantTargeting.setMultiAbiTargeting(apkTargeting.getMultiAbiTargeting());
        }
        if (apkTargeting.hasTextureCompressionFormatTargeting()) {
            variantTargeting.setTextureCompressionFormatTargeting(apkTargeting.getTextureCompressionFormatTargeting());
        }
        return variantTargeting.build();
    }

    public static ImmutableSet<TargetedDirectory> extractAssetsTargetedDirectories(BundleModule module) {
        return (ImmutableSet)module.findEntriesUnderPath(BundleModule.ASSETS_DIRECTORY).map(ModuleEntry::getPath).filter(path -> path.getNameCount() > 1).map(ZipPath::getParent).map(TargetedDirectory::parse).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> extractTextureCompressionFormats(ImmutableSet<TargetedDirectory> targetedDirectories) {
        return (ImmutableSet)targetedDirectories.stream().map(directory -> directory.getTargeting(TargetingDimension.TEXTURE_COMPRESSION_FORMAT)).filter(Optional::isPresent).map(Optional::get).flatMap(targeting -> targeting.getTextureCompressionFormat().getValueList().stream()).map(Targeting.TextureCompressionFormat::getAlias).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Integer> extractDeviceTiers(ImmutableSet<TargetedDirectory> targetedDirectories) {
        return (ImmutableSet)targetedDirectories.stream().map(TargetingUtils::extractDeviceTier).flatMap(Streams::stream).collect(ImmutableSet.toImmutableSet());
    }

    public static Optional<Integer> extractDeviceTier(TargetedDirectory targetedDirectory) {
        return targetedDirectory.getTargeting(TargetingDimension.DEVICE_TIER).flatMap(targeting -> (Optional)targeting.getDeviceTier().getValueList().stream().map(Int32Value::getValue).collect(MoreCollectors.toOptional()));
    }

    public static ImmutableSet<String> extractCountrySets(ImmutableSet<TargetedDirectory> targetedDirectories) {
        return (ImmutableSet)targetedDirectories.stream().map(TargetingUtils::extractCountrySet).flatMap(Streams::stream).collect(ImmutableSet.toImmutableSet());
    }

    public static Optional<Files.Assets> generateAssetsTargeting(BundleModule module) {
        ImmutableList<ZipPath> assetDirectories = TargetingUtils.getAssetDirectories(module);
        if (assetDirectories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForAssets((Collection<ZipPath>)assetDirectories));
    }

    public static Optional<Files.NativeLibraries> generateNativeLibrariesTargeting(BundleModule module) {
        ImmutableList libAbiDirs = (ImmutableList)module.findEntriesUnderPath(BundleModule.LIB_DIRECTORY).map(ModuleEntry::getPath).filter(path -> path.getNameCount() > 2).map(path -> path.subpath(0, 2)).map(ZipPath::toString).distinct().collect(ImmutableList.toImmutableList());
        if (libAbiDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForNativeLibraries((Collection<String>)libAbiDirs));
    }

    public static Optional<Files.ApexImages> generateApexImagesTargeting(BundleModule module) {
        ImmutableList apexImageFiles = (ImmutableList)module.findEntriesUnderPath(BundleModule.APEX_DIRECTORY).map(ModuleEntry::getPath).filter(p11 -> p11.toString().endsWith("img")).collect(ImmutableList.toImmutableList());
        boolean hasBuildInfo = module.findEntriesUnderPath(BundleModule.APEX_DIRECTORY).map(ModuleEntry::getPath).anyMatch(p11 -> p11.toString().endsWith("build_info.pb"));
        if (apexImageFiles.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForApexImages((Collection<ZipPath>)apexImageFiles, hasBuildInfo));
    }

    public static ImmutableList<ZipPath> getAssetDirectories(BundleModule module) {
        return (ImmutableList)module.findEntriesUnderPath(BundleModule.ASSETS_DIRECTORY).map(ModuleEntry::getPath).filter(path -> path.getNameCount() > 1).map(ZipPath::getParent).distinct().collect(ImmutableList.toImmutableList());
    }

    public static Targeting.AssetsDirectoryTargeting getAlternativeTargeting(Targeting.AssetsDirectoryTargeting targeting, ImmutableList<Targeting.AssetsDirectoryTargeting> allTargeting) {
        ImmutableMap<TargetingDimension, Targeting.AssetsDirectoryTargeting> targetingByDimension = TargetingUtils.splitAssetsDirectoryTargetingByDimensions(targeting);
        return TargetingNormalizer.normalizeAssetsDirectoryTargeting(TargetingUtils.getAssetsDirectoryTargetingByDimension(allTargeting).asMap().entrySet().stream().flatMap(dimensionValuePair -> ((Collection)dimensionValuePair.getValue()).stream().filter(value -> !value.equals(targetingByDimension.getOrDefault(dimensionValuePair.getKey(), (Object)Targeting.AssetsDirectoryTargeting.getDefaultInstance()))).map(TargetingProtoUtils::toAlternativeTargeting)).reduce(Targeting.AssetsDirectoryTargeting.newBuilder(), Targeting.AssetsDirectoryTargeting.Builder::mergeFrom, (builderA, builderB) -> builderA.mergeFrom(builderB.build())).build());
    }

    public static ImmutableMultimap<TargetingDimension, Targeting.AssetsDirectoryTargeting> getAssetsDirectoryTargetingByDimension(ImmutableList<Targeting.AssetsDirectoryTargeting> directoryAllTargeting) {
        LinkedHashMultimap assetsDirectoryTargetingByDimension = LinkedHashMultimap.create();
        directoryAllTargeting.stream().map(TargetingUtils::splitAssetsDirectoryTargetingByDimensions).map(Multimaps::forMap).forEach(x$0 -> assetsDirectoryTargetingByDimension.putAll(x$0));
        if (assetsDirectoryTargetingByDimension.containsKey((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT)) {
            assetsDirectoryTargetingByDimension.put((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT, (Object)Targeting.AssetsDirectoryTargeting.getDefaultInstance());
        }
        if (assetsDirectoryTargetingByDimension.containsKey((Object)TargetingDimension.COUNTRY_SET)) {
            assetsDirectoryTargetingByDimension.put((Object)TargetingDimension.COUNTRY_SET, (Object)Targeting.AssetsDirectoryTargeting.getDefaultInstance());
        }
        return ImmutableMultimap.copyOf((Multimap)assetsDirectoryTargetingByDimension);
    }

    private static ImmutableMap<TargetingDimension, Targeting.AssetsDirectoryTargeting> splitAssetsDirectoryTargetingByDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        return (ImmutableMap)TargetingUtils.getTargetingDimensions(targeting).stream().collect(ImmutableMap.toImmutableMap(Function.identity(), dimension -> TargetingUtils.extractDimensionTargeting(targeting, dimension).get()));
    }

    private static Optional<String> extractCountrySet(TargetedDirectory targetedDirectory) {
        return targetedDirectory.getTargeting(TargetingDimension.COUNTRY_SET).flatMap(targeting -> (Optional)targeting.getCountrySet().getValueList().stream().collect(MoreCollectors.toOptional()));
    }
}

