/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.commands.AutoValue_CheckTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.transparency.ApkModeTransparencyChecker;
import com.android.tools.build.bundletool.transparency.BundleModeTransparencyChecker;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.transparency.ConnectedDeviceModeTransparencyChecker;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

@AutoValue
public abstract class CheckTransparencyCommand {
    public static final String COMMAND_NAME = "check-transparency";
    private static final Flag<Mode> MODE_FLAG = Flag.enumFlag("mode", Mode.class);
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<String> PACKAGE_NAME_FLAG = Flag.string("package-name");
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> APK_ZIP_LOCATION_FLAG = Flag.path("apk-zip");
    private static final Flag<Path> TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG = Flag.path("transparency-key-certificate");
    private static final Flag<Path> APK_SIGNING_KEY_CERTIFICATE_LOCATION_FLAG = Flag.path("apk-signing-key-certificate");
    private static final String MODE_FLAG_OPTIONS = Arrays.stream(Mode.values()).map(Mode::getLowerCaseName).collect(Collectors.joining("|"));
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    public abstract Mode getMode();

    public abstract Optional<Path> getAdbPath();

    public abstract Optional<String> getDeviceId();

    public abstract Optional<String> getPackageName();

    public abstract Optional<AdbServer> getAdbServer();

    public abstract Optional<Path> getBundlePath();

    public abstract Optional<Path> getApkZipPath();

    abstract Optional<X509Certificate> getTransparencyKeyCertificate();

    abstract Optional<X509Certificate> getApkSigningKeyCertificate();

    public static Builder builder() {
        return new AutoValue_CheckTransparencyCommand.Builder();
    }

    public static CheckTransparencyCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return CheckTransparencyCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static CheckTransparencyCommand fromFlags(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Mode mode = MODE_FLAG.getRequiredValue(flags);
        switch (mode.ordinal()) {
            case 0: {
                return CheckTransparencyCommand.fromFlagsInConnectedDeviceMode(flags, systemEnvironmentProvider, adbServer);
            }
            case 1: {
                return CheckTransparencyCommand.fromFlagsInBundleMode(flags);
            }
            case 2: {
                return CheckTransparencyCommand.fromFlagsInApkMode(flags);
            }
        }
        throw new IllegalStateException("Unrecognized value of --mode flag.");
    }

    private static CheckTransparencyCommand fromFlagsInBundleMode(ParsedFlags flags) {
        Builder checkTransparencyCommand = CheckTransparencyCommand.builder().setMode(Mode.BUNDLE).setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags));
        TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getValue(flags).ifPresent(path -> checkTransparencyCommand.setTransparencyKeyCertificate(CodeTransparencyCryptoUtils.getX509Certificate(path)));
        flags.checkNoUnknownFlags();
        return checkTransparencyCommand.build();
    }

    private static CheckTransparencyCommand fromFlagsInApkMode(ParsedFlags flags) {
        Builder checkTransparencyCommand = CheckTransparencyCommand.builder().setMode(Mode.APK).setApkZipPath(APK_ZIP_LOCATION_FLAG.getRequiredValue(flags));
        TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getValue(flags).ifPresent(path -> checkTransparencyCommand.setTransparencyKeyCertificate(CodeTransparencyCryptoUtils.getX509Certificate(path)));
        APK_SIGNING_KEY_CERTIFICATE_LOCATION_FLAG.getValue(flags).ifPresent(path -> checkTransparencyCommand.setApkSigningKeyCertificate(CodeTransparencyCryptoUtils.getX509Certificate(path)));
        flags.checkNoUnknownFlags();
        return checkTransparencyCommand.build();
    }

    private static CheckTransparencyCommand fromFlagsInConnectedDeviceMode(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Builder checkTransparencyCommand = CheckTransparencyCommand.builder().setMode(Mode.CONNECTED_DEVICE).setPackageName(PACKAGE_NAME_FLAG.getRequiredValue(flags));
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        if (!deviceSerialName.isPresent()) {
            deviceSerialName = systemEnvironmentProvider.getVariable("ANDROID_SERIAL");
        }
        deviceSerialName.ifPresent(checkTransparencyCommand::setDeviceId);
        Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, systemEnvironmentProvider);
        checkTransparencyCommand.setAdbPath(adbPath).setAdbServer(adbServer);
        TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getValue(flags).ifPresent(path -> checkTransparencyCommand.setTransparencyKeyCertificate(CodeTransparencyCryptoUtils.getX509Certificate(path)));
        APK_SIGNING_KEY_CERTIFICATE_LOCATION_FLAG.getValue(flags).ifPresent(path -> checkTransparencyCommand.setApkSigningKeyCertificate(CodeTransparencyCryptoUtils.getX509Certificate(path)));
        flags.checkNoUnknownFlags();
        return checkTransparencyCommand.build();
    }

    public void execute() {
        this.validateInput();
        this.checkTransparency(System.out);
    }

    public void checkTransparency(PrintStream outputStream) {
        TransparencyCheckResult result = TransparencyCheckResult.empty();
        switch (this.getMode().ordinal()) {
            case 0: {
                result = ConnectedDeviceModeTransparencyChecker.checkTransparency(this);
                break;
            }
            case 1: {
                result = BundleModeTransparencyChecker.checkTransparency(this);
                break;
            }
            case 2: {
                result = ApkModeTransparencyChecker.checkTransparency(this);
            }
        }
        this.printResult(outputStream, result);
    }

    private void printResult(PrintStream outputStream, TransparencyCheckResult result) {
        boolean apkSignatureVerificationSuccess = this.verifyAndPrintApkSignatureCert(outputStream, result);
        if (apkSignatureVerificationSuccess) {
            this.printCodeTransparencyVerificationResult(outputStream, result);
        }
    }

    private boolean verifyAndPrintApkSignatureCert(PrintStream outputStream, TransparencyCheckResult result) {
        Preconditions.checkState((this.getMode().equals((Object)Mode.BUNDLE) || !result.verified() || result.apkSigningKeyCertificateFingerprint().isPresent() ? 1 : 0) != 0, (Object)"APK signing key certificate fingerprint must be present in TransparencyCheckResult.");
        if (this.getMode().equals((Object)Mode.BUNDLE)) {
            outputStream.println("No APK present. APK signature was not checked.");
            return true;
        }
        if (!result.apkSigningKeyCertificateFingerprint().isPresent()) {
            Preconditions.checkState((!result.verified() ? 1 : 0) != 0, (Object)"Successful TransparencyCheckResult must specify APK signing key certificate.");
            outputStream.println(result.getErrorMessage());
            return false;
        }
        if (!this.getApkSigningKeyCertificate().isPresent()) {
            outputStream.println("APK signature is valid. SHA-256 fingerprint of the apk signing key certificate (must be compared with the developer's public key manually): " + result.getApkSigningKeyCertificateFingerprint());
            return true;
        }
        String providedApkSigningKeyCertificateFingerprint = CodeTransparencyCryptoUtils.getCertificateFingerprint(this.getApkSigningKeyCertificate().get());
        if (result.getApkSigningKeyCertificateFingerprint().equals(providedApkSigningKeyCertificateFingerprint)) {
            outputStream.println("APK signature verified for the provided apk signing key certificate.");
            return true;
        }
        outputStream.println("APK signature verification failed because the provided public key certificate does not match the APK signature.\nSHA-256 fingerprint of the certificate that was used to sign the APKs: " + result.getApkSigningKeyCertificateFingerprint() + "\nSHA-256 fingerprint of the certificate that was provided: " + providedApkSigningKeyCertificateFingerprint);
        return false;
    }

    private void printCodeTransparencyVerificationResult(PrintStream outputStream, TransparencyCheckResult result) {
        if (!result.verified()) {
            outputStream.println(result.getErrorMessage());
            return;
        }
        if (!this.getTransparencyKeyCertificate().isPresent()) {
            outputStream.println("Code transparency signature is valid. SHA-256 fingerprint of the code transparency key certificate (must be compared with the developer's public key manually): " + result.getTransparencyKeyCertificateFingerprint());
            outputStream.println("Code transparency verified: code related file contents match the code transparency file.");
            return;
        }
        String providedTransparencyKeyCertificateFingerprint = CodeTransparencyCryptoUtils.getCertificateFingerprint(this.getTransparencyKeyCertificate().get());
        if (result.getTransparencyKeyCertificateFingerprint().equals(providedTransparencyKeyCertificateFingerprint)) {
            outputStream.println("Code transparency signature verified for the provided code transparency key certificate.");
            outputStream.println("Code transparency verified: code related file contents match the code transparency file.");
        } else {
            outputStream.println("Code transparency verification failed because the provided public key certificate does not match the code transparency file.\nSHA-256 fingerprint of the certificate that was used to sign code transparency file: " + result.getTransparencyKeyCertificateFingerprint() + "\nSHA-256 fingerprint of the certificate that was provided: " + providedTransparencyKeyCertificateFingerprint);
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Verifies code transparency.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODE_FLAG.getName()).setExampleValue(MODE_FLAG_OPTIONS).setOptional(true).setDescription("Specifies which mode to run '%s' command against. Acceptable values are '%s'. If set to '%s' we verify code transparency for a given app installed on a connected device. If set to '%s', we verify code transparency for a given Android App Bundle file. If set to '%s', we verify code transparency for a given set of device-specific APK files.", COMMAND_NAME, MODE_FLAG_OPTIONS, Mode.CONNECTED_DEVICE.getLowerCaseName(), Mode.BUNDLE.getLowerCaseName(), Mode.APK.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. Used only in '%s' mode. If absent, an attempt will be made to locate it if the %s or %s environment variable is set.", Mode.CONNECTED_DEVICE.getLowerCaseName(), "ANDROID_HOME", "PATH").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. Used only in '%s' mode. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected.", Mode.CONNECTED_DEVICE.getLowerCaseName(), "ANDROID_SERIAL").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(PACKAGE_NAME_FLAG.getName()).setExampleValue("package-name").setOptional(true).setDescription("Package name of the app that code transparency will be verified for. Used only in '%s' mode.", Mode.CONNECTED_DEVICE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_LOCATION_FLAG.getName()).setExampleValue("path/to/bundle.aab").setOptional(true).setDescription("Path to the Android App Bundle that we want to verify code transparency for. Used only in '%s' mode. Must have extension .aab.", Mode.BUNDLE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APK_ZIP_LOCATION_FLAG.getName()).setExampleValue("path/to/apks.zip").setOptional(true).setDescription("Path to the zip archive of device specific APKs that we want to verify code transparency for. Used only in '%s' mode. Must have extension .zip.", Mode.APK.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getName()).setExampleValue("path/to/certificate.cert").setOptional(true).setDescription("Path to the file containing the public key certificate that should be used for code transparency signature verification. If not set, fingerprint of the certificate that is used will be printed.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APK_SIGNING_KEY_CERTIFICATE_LOCATION_FLAG.getName()).setExampleValue("path/to/certificate.cert").setOptional(true).setDescription("Path to the file containing the public key certificate that should be used for APK signature verification. Can only be set in '%s and '%s' modes. If not set, fingerprint of the certificate that is used will be printed.", Mode.APK.getLowerCaseName(), Mode.CONNECTED_DEVICE.getLowerCaseName()).build()).build();
    }

    private void validateInput() {
        if (this.getBundlePath().isPresent()) {
            FilePreconditions.checkFileHasExtension("AAB file", this.getBundlePath().get(), ".aab");
            FilePreconditions.checkFileExistsAndReadable(this.getBundlePath().get());
        }
        if (this.getApkZipPath().isPresent()) {
            FilePreconditions.checkFileHasExtension("Zip file", this.getApkZipPath().get(), ".zip");
            FilePreconditions.checkFileExistsAndReadable(this.getApkZipPath().get());
        }
    }

    public static enum Mode {
        CONNECTED_DEVICE,
        BUNDLE,
        APK;


        final String getLowerCaseName() {
            return Ascii.toLowerCase((String)this.name());
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMode(Mode var1);

        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setAdbServer(AdbServer var1);

        public abstract Builder setPackageName(String var1);

        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setApkZipPath(Path var1);

        abstract Builder setTransparencyKeyCertificate(X509Certificate var1);

        abstract Builder setApkSigningKeyCertificate(X509Certificate var1);

        public abstract CheckTransparencyCommand build();
    }
}

