/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shadow.bundletool.com.android.utils.TokenizedCommandLine;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lshadow/bundletool/com/android/utils/StringHelperWindows;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperWindows {
    @NotNull
    public static final StringHelperWindows INSTANCE = new StringHelperWindows();

    private StringHelperWindows() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        int n11;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        int i11 = 0;
        while (i11 < length) {
            char c11 = commandLine.charAt(i11);
            if (c11 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                ++i11;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c11 == '\\') {
                escapingQuotes = true;
                ++i11;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                ++i11;
                continue;
            }
            if (c11 == '^') {
                escapingOthers = true;
                ++i11;
                continue;
            }
            if (!quoting && commandLine.charAt(i11) == '&') {
                String string = commandLine;
                boolean bl2 = false;
                String string2 = string.substring(commandStart, i11);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                commands.add(string2);
                n11 = i11;
                i11 = n11 + 1;
                if (commandLine.length() > i11 && commandLine.charAt(i11) == '&') {
                    n11 = i11;
                    i11 = n11 + 1;
                }
                commandStart = i11;
            }
            ++i11;
        }
        if (commandStart < length) {
            String string = commandLine;
            n11 = 0;
            String string3 = string.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            commands.add(string3);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, false, 2, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, true, 2, null, 8, null).toTokenList();
    }
}

