/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.AdbHelper;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.DdmPreferences;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.internal.AdbSocketUtils;
import shadow.bundletool.com.android.ddmlib.internal.ClientImpl;
import shadow.bundletool.com.android.ddmlib.internal.DeviceImpl;
import shadow.bundletool.com.android.ddmlib.internal.MonitorThread;
import shadow.bundletool.com.android.ddmlib.internal.ProfileableClientImpl;
import shadow.bundletool.com.android.server.adb.protos.AppProcessesProto;

class DeviceClientMonitorTask
implements Runnable {
    private volatile boolean mQuit;
    private final Selector mSelector;
    private final ConcurrentHashMap<SocketChannel, TrackServiceProcessor> mChannelsToRegister = new ConcurrentHashMap();
    private final Set<ClientImpl> mClientsToReopen = new HashSet<ClientImpl>();

    DeviceClientMonitorTask() throws IOException {
        this.mSelector = Selector.open();
    }

    boolean register(DeviceImpl device) {
        SocketChannel socketChannel;
        try {
            socketChannel = AndroidDebugBridge.openConnection();
        }
        catch (IOException exception) {
            Log.e("DeviceClientMonitorTask", "Unable to open connection to ADB server: " + exception);
            return false;
        }
        if (socketChannel != null) {
            try {
                TrackServiceProcessor processor = DeviceClientMonitorTask.isDeviceVersionAtLeastS(device) ? new TrackAppProcessor(device) : new TrackJdwpProcessor(device);
                boolean result = this.sendDeviceMonitoringRequest(socketChannel, processor);
                if (result) {
                    device.setClientMonitoringSocket(socketChannel);
                    socketChannel.configureBlocking(false);
                    this.mChannelsToRegister.put(socketChannel, processor);
                    this.mSelector.wakeup();
                    return true;
                }
            }
            catch (TimeoutException e11) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : timeout");
            }
            catch (AdbCommandRejectedException e12) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Adb refused to start monitoring device '" + device + "' : " + e12.getMessage());
            }
            catch (IOException e13) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : " + e13.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClientToDropAndReopen(ClientImpl client) {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            Log.d("DeviceClientMonitorTask", "Adding " + client + " to list of client to reopen (" + client.getDebuggerListenPort() + ").");
            this.mClientsToReopen.add(client);
        }
        this.mSelector.wakeup();
    }

    void free(ClientImpl client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDropAndReopenClients() {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            MonitorThread monitorThread = MonitorThread.getInstance();
            for (ClientImpl client : this.mClientsToReopen) {
                DeviceImpl device = (DeviceImpl)client.getDevice();
                int pid = client.getClientData().getPid();
                monitorThread.dropClient(client, false);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                Log.d("DeviceClientMonitorTask", "Reopening " + client);
                DeviceClientMonitorTask.openClient(device, pid, monitorThread);
                device.update(2);
            }
            this.mClientsToReopen.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelsToRegister() {
        ArrayList<SocketChannel> channels = Collections.list(this.mChannelsToRegister.keys());
        for (SocketChannel channel : channels) {
            try {
                channel.register(this.mSelector, 1, this.mChannelsToRegister.get(channel));
            }
            catch (ClosedChannelException e11) {
                Log.w("DeviceClientMonitorTask", "Cannot register already-closed channel.");
            }
            finally {
                ((ConcurrentHashMap.KeySetView)this.mChannelsToRegister.keySet()).remove(channel);
            }
        }
    }

    @Override
    public void run() {
        do {
            int count = 0;
            try {
                count = this.mSelector.select();
            }
            catch (IOException e11) {
                Log.e("DeviceClientMonitorTask", "Connection error while monitoring clients.");
                Log.d("DeviceClientMonitorTask", e11);
                return;
            }
            if (this.mQuit) {
                return;
            }
            this.processChannelsToRegister();
            this.processDropAndReopenClients();
            if (count == 0) continue;
            Set<SelectionKey> keys = this.mSelector.selectedKeys();
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                Processor processor;
                SocketChannel socket;
                Object attachment;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isValid() || !key.isReadable() || !((attachment = key.attachment()) instanceof Processor) || (socket = (processor = (Processor)attachment).getSocket()) == null) continue;
                try {
                    processor.processIncomingData();
                }
                catch (IOException ioe) {
                    Log.d("DeviceClientMonitorTask", "Error reading incoming data: " + ioe.getMessage());
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!(processor instanceof TrackServiceProcessor)) continue;
                    this.mChannelsToRegister.remove(socket);
                    DeviceImpl device = processor.getDevice();
                    device.getClientTracker().trackDeviceToDropAndReopen(device);
                }
            }
        } while (!this.mQuit);
    }

    public void stop() {
        this.mQuit = true;
        this.mSelector.wakeup();
    }

    private boolean sendDeviceMonitoringRequest(SocketChannel socket, TrackServiceProcessor processor) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            AdbHelper.setDevice(socket, processor.getDevice());
            AdbHelper.write(socket, AdbHelper.formAdbRequest(processor.getCommand()));
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(socket, false);
            if (!resp.okay) {
                Log.e("DeviceClientMonitorTask", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (TimeoutException e11) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request timed out!");
            throw e11;
        }
        catch (IOException e12) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request failed!");
            throw e12;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJdwpClients(DeviceImpl device, Set<Integer> newPids) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        List<ClientImpl> clients = device.getClientList();
        HashMap<Integer, ClientImpl> existingClients = new HashMap<Integer, ClientImpl>();
        List<ClientImpl> list2 = clients;
        synchronized (list2) {
            for (ClientImpl c11 : clients) {
                existingClients.put(c11.getClientData().getPid(), c11);
            }
        }
        HashSet<ClientImpl> clientsToRemove = new HashSet<ClientImpl>();
        for (Integer pid : existingClients.keySet()) {
            if (newPids.contains(pid)) continue;
            clientsToRemove.add((ClientImpl)existingClients.get(pid));
        }
        HashSet<Integer> pidsToAdd = new HashSet<Integer>(newPids);
        pidsToAdd.removeAll(existingClients.keySet());
        monitorThread.dropClients(clientsToRemove, false);
        Iterator iterator2 = pidsToAdd.iterator();
        while (iterator2.hasNext()) {
            int newPid = (Integer)iterator2.next();
            DeviceClientMonitorTask.openClient(device, newPid, monitorThread);
        }
        if (!pidsToAdd.isEmpty() || !clientsToRemove.isEmpty()) {
            AndroidDebugBridge.deviceChanged(device, 2);
        }
    }

    private static void openClient(DeviceImpl device, int pid, MonitorThread monitorThread) {
        SocketChannel clientSocket;
        try {
            clientSocket = DdmPreferences.isJdwpProxyEnabled() ? AdbHelper.createPassThroughConnection(new InetSocketAddress("localhost", DdmPreferences.getJdwpProxyPort()), device.getSerialNumber(), pid) : AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), pid);
            clientSocket.configureBlocking(false);
        }
        catch (UnknownHostException uhe) {
            Log.d("DeviceClientMonitorTask", "Unknown Jdwp pid: " + pid);
            return;
        }
        catch (TimeoutException e11) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': timeout");
            return;
        }
        catch (AdbCommandRejectedException e12) {
            Log.d("DeviceClientMonitorTask", "Adb rejected connection to client '" + pid + "': " + e12.getMessage());
            return;
        }
        catch (IOException ioe) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': " + ioe.getMessage());
            return;
        }
        DeviceClientMonitorTask.createClient(device, pid, clientSocket, monitorThread);
    }

    private static void createClient(DeviceImpl device, int pid, SocketChannel socket, MonitorThread monitorThread) {
        ClientImpl client = new ClientImpl(device, socket, pid);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger();
                    String msg = String.format(Locale.US, "Opening a debugger listener at port %1$d for client with pid %2$d", client.getDebuggerListenPort(), pid);
                    Log.d("ddms", msg);
                }
            }
            catch (IOException ioe) {
                client.getClientData().setDebuggerConnectionStatus(ClientData.DebuggerStatus.ERROR);
                Log.e("ddms", "Can't bind to local " + client.getDebuggerListenPort() + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        }
    }

    private static boolean isDeviceVersionAtLeastS(DeviceImpl device) {
        return device.getVersion().getFeatureLevel() >= 31;
    }

    private class CmdlineFileProcessor
    extends Processor {
        private final int mPid;
        private int mRetryCount;
        SocketChannel mSocket;

        CmdlineFileProcessor(DeviceImpl device, int pid) {
            this(device, pid, 5);
        }

        CmdlineFileProcessor(DeviceImpl device, int pid, int retryCount) {
            super(device);
            this.mPid = pid;
            this.mRetryCount = retryCount;
        }

        void connect() {
            if (this.mRetryCount <= 0) {
                Log.w("DeviceClientMonitorTask", "Unexpected cmdline file for PID " + this.mPid);
                return;
            }
            String[] parameters = new String[]{"/proc/" + this.mPid + "/cmdline"};
            try {
                this.mSocket = this.getDevice().rawExec("cat", parameters);
            }
            catch (IOException | AdbCommandRejectedException | TimeoutException exception) {
                // empty catch block
            }
            if (this.mSocket == null) {
                Log.w("DeviceClientMonitorTask", "Cannot register null socket for PID " + this.mPid);
                return;
            }
            try {
                this.mSocket.register(DeviceClientMonitorTask.this.mSelector, 1, this);
            }
            catch (ClosedChannelException e11) {
                Log.w("DeviceClientMonitorTask", "Cannot register already-closed channel to read the name for PID " + this.mPid);
            }
        }

        @Override
        SocketChannel getSocket() {
            return this.mSocket;
        }

        @Override
        void processIncomingData() throws IOException {
            if (this.mSocket == null) {
                return;
            }
            String name = AdbSocketUtils.readNullTerminatedString(this.mSocket);
            this.mSocket.close();
            if (name.equals("<pre-initialized>")) {
                new CmdlineFileProcessor(this.getDevice(), this.mPid, --this.mRetryCount).connect();
                return;
            }
            if (name.contains("No such file or directory")) {
                return;
            }
            this.getDevice().updateProfileableClientName(this.mPid, name);
            AndroidDebugBridge.deviceChanged(this.getDevice(), 8);
        }
    }

    private class TrackJdwpProcessor
    extends TrackServiceProcessor {
        TrackJdwpProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        String getCommand() {
            return "track-jdwp";
        }

        @Override
        void processIncomingData() throws IOException {
            if (this.getSocket() == null) {
                return;
            }
            byte[] lengthBuffer = new byte[4];
            int length = AdbSocketUtils.readLength(this.getSocket(), lengthBuffer);
            if (length >= 0) {
                HashSet<Integer> newPids = new HashSet<Integer>();
                if (length > 0) {
                    String[] pids;
                    byte[] buffer = new byte[length];
                    String result = AdbSocketUtils.read(this.getSocket(), buffer);
                    for (String pid : pids = result.split("\n")) {
                        try {
                            newPids.add(Integer.valueOf(pid));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                DeviceClientMonitorTask.this.updateJdwpClients(this.getDevice(), newPids);
            }
        }
    }

    private class TrackAppProcessor
    extends TrackServiceProcessor {
        TrackAppProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        String getCommand() {
            return "track-app";
        }

        @Override
        void processIncomingData() throws IOException {
            if (this.getSocket() == null) {
                return;
            }
            byte[] lengthBuffer = new byte[4];
            int length = AdbSocketUtils.readLength(this.getSocket(), lengthBuffer);
            if (length < 0) {
                return;
            }
            ByteBuffer buffer = AdbSocketUtils.read(this.getSocket(), length);
            AppProcessesProto.AppProcesses processes = AppProcessesProto.AppProcesses.parseFrom(buffer);
            HashSet<Integer> newJdwpPids = new HashSet<Integer>();
            HashMap<Integer, ProfileableClientImpl> newProfileable = new HashMap<Integer, ProfileableClientImpl>();
            for (AppProcessesProto.ProcessEntry process : processes.getProcessList()) {
                if (process.getDebuggable()) {
                    newJdwpPids.add((int)process.getPid());
                }
                if (!process.getProfileable() && !process.getDebuggable()) continue;
                ProfileableClientImpl client = new ProfileableClientImpl((int)process.getPid(), "", process.getArchitecture());
                newProfileable.put((int)process.getPid(), client);
            }
            DeviceClientMonitorTask.this.updateJdwpClients(this.getDevice(), newJdwpPids);
            this.updateProfileableClients(this.getDevice(), newProfileable);
        }

        void updateProfileableClients(DeviceImpl device, Map<Integer, ProfileableClientImpl> currentProfileable) {
            HashMap<Integer, ProfileableClientImpl> previousProfileable = new HashMap<Integer, ProfileableClientImpl>();
            for (ProfileableClientImpl client2 : device.getProfileableClients()) {
                previousProfileable.put(client2.getProfileableClientData().getPid(), client2);
            }
            Sets.SetView addPids = Sets.difference(currentProfileable.keySet(), previousProfileable.keySet());
            Sets.SetView removePids = Sets.difference(previousProfileable.keySet(), currentProfileable.keySet());
            if (addPids.isEmpty() && removePids.isEmpty()) {
                return;
            }
            TreeSet pidsWithoutNames = Sets.newTreeSet((Iterable)addPids);
            previousProfileable.forEach((pid, client) -> {
                if (!currentProfileable.containsKey(pid)) {
                    return;
                }
                String name = client.getProfileableClientData().getProcessName();
                if (name != null && !name.isEmpty()) {
                    ((ProfileableClientImpl)currentProfileable.get(pid)).getProfileableClientData().setProcessName(name);
                } else {
                    pidsWithoutNames.add(pid);
                }
            });
            this.findProcessJdwpNames(device, currentProfileable, pidsWithoutNames);
            device.updateProfileableClientList(Lists.newArrayList(currentProfileable.values()));
            AndroidDebugBridge.deviceChanged(device, 8);
            for (Integer pid2 : pidsWithoutNames) {
                new CmdlineFileProcessor(device, pid2).connect();
            }
        }

        private void findProcessJdwpNames(DeviceImpl device, Map<Integer, ProfileableClientImpl> pidClientMap, Set<Integer> pidsWithoutNames) {
            HashMap<Integer, String> jdwpClientNames = new HashMap<Integer, String>();
            for (ClientImpl client : device.getClients()) {
                ClientData clientData = client.getClientData();
                jdwpClientNames.put(clientData.getPid(), clientData.getPackageName());
            }
            for (Integer pid : Sets.newTreeSet(pidsWithoutNames)) {
                String name = (String)jdwpClientNames.get(pid);
                if (name == null || name.isEmpty()) continue;
                pidClientMap.get(pid).getProfileableClientData().setProcessName(name);
                pidsWithoutNames.remove(pid);
            }
        }
    }

    private abstract class TrackServiceProcessor
    extends Processor {
        TrackServiceProcessor(DeviceImpl device) {
            super(device);
        }

        @Override
        SocketChannel getSocket() {
            return this.getDevice().getClientMonitoringSocket();
        }

        abstract String getCommand();
    }

    private abstract class Processor {
        final DeviceImpl mDevice;

        Processor(DeviceImpl device) {
            this.mDevice = device;
        }

        DeviceImpl getDevice() {
            return this.mDevice;
        }

        abstract SocketChannel getSocket();

        abstract void processIncomingData() throws IOException;
    }
}

