/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

public final class ApkSerializerHelper {
    static final ImmutableSet<String> NO_COMPRESSION_EXTENSIONS = ImmutableSet.of((Object)"3g2", (Object)"3gp", (Object)"3gpp", (Object)"3gpp2", (Object)"aac", (Object)"amr", (Object[])new String[]{"awb", "gif", "imy", "jet", "jpeg", "jpg", "m4a", "m4v", "mid", "midi", "mkv", "mp2", "mp3", "mp4", "mpeg", "mpg", "ogg", "png", "rtttl", "smf", "wav", "webm", "wma", "wmv", "xmf"});

    public static ZipPath toApkEntryPath(ZipPath pathInModule) {
        return ApkSerializerHelper.toApkEntryPath(pathInModule, false);
    }

    public static ZipPath toApkEntryPath(ZipPath pathInModule, boolean binaryApk) {
        if (binaryApk && pathInModule.equals(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath())) {
            return ZipPath.create("resources.arsc");
        }
        if (pathInModule.startsWith(BundleModule.MANIFEST_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the manifest directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under manifest/ directory", pathInModule, ".xml");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        if (pathInModule.startsWith(BundleModule.APEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the apex directory are supported but found: %s", (Object)pathInModule);
            Preconditions.checkArgument((pathInModule.toString().endsWith("img") || pathInModule.toString().endsWith("build_info.pb") ? 1 : 0) != 0, (String)"Unexpected filename in apex directory: %s", (Object)pathInModule);
            if (pathInModule.toString().endsWith("img")) {
                return ZipPath.create("apex_payload.img");
            }
            return ZipPath.create("apex_build_info.pb");
        }
        return pathInModule;
    }

    public static boolean requiresAapt2Conversion(ZipPath path) {
        return path.startsWith("res") || path.equals(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()) || path.equals(ZipPath.create("AndroidManifest.xml"));
    }

    private ApkSerializerHelper() {
    }
}

