/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.logcat;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatHeader;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatHeaderParserKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lshadow/bundletool/com/android/ddmlib/logcat/LogCatHeaderParser;", "", "defaultYear", "", "defaultZoneId", "Ljava/time/ZoneId;", "(ILjava/time/ZoneId;)V", "getPackageName", "", "device", "Lshadow/bundletool/com/android/ddmlib/IDevice;", "pid", "parseEpochSeconds", "", "string", "parseHeader", "Lshadow/bundletool/com/android/ddmlib/logcat/LogCatHeader;", "line", "parsePid", "parsePriority", "Lshadow/bundletool/com/android/ddmlib/Log$LogLevel;", "parseThreadId", "ddmlib"})
public final class LogCatHeaderParser {
    private final int defaultYear;
    @NotNull
    private final ZoneId defaultZoneId;

    public LogCatHeaderParser(int defaultYear, @NotNull ZoneId defaultZoneId) {
        Intrinsics.checkParameterIsNotNull((Object)defaultZoneId, (String)"defaultZoneId");
        this.defaultYear = defaultYear;
        this.defaultZoneId = defaultZoneId;
    }

    public /* synthetic */ LogCatHeaderParser(int n11, ZoneId zoneId, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 1) != 0) {
            n11 = ZonedDateTime.now().getYear();
        }
        if ((n12 & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        this(n11, zoneId);
    }

    @Nullable
    public final LogCatHeader parseHeader(@NotNull String line, @Nullable IDevice device) {
        Instant instant;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Matcher m11 = LogCatHeaderParserKt.access$getHEADER$p().matcher(line);
        if (!m11.matches()) {
            return null;
        }
        String epoch = m11.group("epoch");
        Instant timestamp = null;
        if (epoch != null) {
            string = m11.group("epochSec");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"epochSec\")");
            long l11 = this.parseEpochSeconds(string);
            string = m11.group("epochMilli");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"epochMilli\")");
            boolean bl2 = false;
            instant = Instant.ofEpochSecond(l11, TimeUnit.MILLISECONDS.toNanos(Long.parseLong(string)));
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"ofEpochSecond(\n                parseEpochSeconds(m.group(\"epochSec\")),\n                MILLISECONDS.toNanos(m.group(\"epochMilli\").toLong())\n            )");
            timestamp = instant;
        } else {
            string = m11.group("month");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"month\")");
            boolean bl3 = false;
            int n11 = Integer.parseInt(string);
            string = m11.group("day");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"day\")");
            bl3 = false;
            int n12 = Integer.parseInt(string);
            string = m11.group("hour");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"hour\")");
            bl3 = false;
            int n13 = Integer.parseInt(string);
            string = m11.group("min");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"min\")");
            bl3 = false;
            int n14 = Integer.parseInt(string);
            string = m11.group("sec");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"sec\")");
            bl3 = false;
            int n15 = Integer.parseInt(string);
            string = m11.group("milli");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"milli\")");
            bl3 = false;
            instant = Instant.from(ZonedDateTime.of(this.defaultYear, n11, n12, n13, n14, n15, (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(string)), this.defaultZoneId));
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"from(\n                ZonedDateTime.of(\n                    defaultYear,\n                    m.group(\"month\").toInt(),\n                    m.group(\"day\").toInt(),\n                    m.group(\"hour\").toInt(),\n                    m.group(\"min\").toInt(),\n                    m.group(\"sec\").toInt(),\n                    MILLISECONDS.toNanos(m.group(\"milli\").toLong()).toInt(),\n                    defaultZoneId\n                )\n            )");
            timestamp = instant;
        }
        string = m11.group("pid");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"pid\")");
        int pid = this.parsePid(string);
        string = m11.group("priority");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"priority\")");
        Log.LogLevel logLevel = this.parsePriority(string);
        string = m11.group("tid");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"tid\")");
        int n16 = this.parseThreadId(string);
        String string2 = this.getPackageName(device, pid);
        string = m11.group("tag");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"tag\")");
        return new LogCatHeader(logLevel, pid, n16, string2, string, timestamp);
    }

    private final Log.LogLevel parsePriority(String string) {
        Log.LogLevel priority = Log.LogLevel.getByLetterString(string);
        if (priority != null) {
            return priority;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"F")) {
            return Log.LogLevel.WARN;
        }
        return Log.LogLevel.ASSERT;
    }

    private final int parseThreadId(String string) {
        int n11;
        try {
            Integer n12 = Integer.decode(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)n12, (String)"{\n            Integer.decode(string)\n        }");
            n11 = ((Number)n12).intValue();
        }
        catch (NumberFormatException exception) {
            n11 = -1;
        }
        return n11;
    }

    private final int parsePid(String string) {
        int n11;
        try {
            String string2 = string;
            boolean bl2 = false;
            n11 = Integer.parseInt(string2);
        }
        catch (NumberFormatException exception) {
            n11 = -1;
        }
        return n11;
    }

    private final long parseEpochSeconds(String string) {
        long l11;
        try {
            String string2 = string;
            boolean bl2 = false;
            l11 = Long.parseLong(string2);
        }
        catch (NumberFormatException exception) {
            l11 = 0L;
        }
        return l11;
    }

    private final String getPackageName(IDevice device, int pid) {
        Object object = device;
        String clientName = object == null ? null : object.getClientName(pid);
        object = clientName;
        boolean bl2 = false;
        boolean bl3 = false;
        return object == null || object.length() == 0 ? "?" : clientName;
    }

    public LogCatHeaderParser() {
        this(0, null, 3, null);
    }
}

