/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.stream.Collectors;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public final class CodeTransparencyCryptoUtils {
    public static JsonWebSignature parseJws(ByteSource signedTransparencyFile) {
        JsonWebSignature jws;
        try {
            jws = (JsonWebSignature)JsonWebSignature.fromCompactSerialization((String)signedTransparencyFile.asCharSource(Charset.defaultCharset()).read());
        }
        catch (IOException | JoseException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Unable to deserialize JWS from code transparency file.").withCause(e11).build();
        }
        return jws;
    }

    public static boolean verifySignature(JsonWebSignature jws) {
        boolean signatureValid;
        try {
            jws.setKey((Key)jws.getLeafCertificateHeaderValue().getPublicKey());
            jws.setAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"}));
            signatureValid = jws.verifySignature();
        }
        catch (JoseException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Exception while verifying code transparency signature.").withCause(e11).build();
        }
        return signatureValid;
    }

    public static String getCertificateFingerprint(JsonWebSignature jws) {
        X509Certificate certificate;
        try {
            certificate = jws.getLeafCertificateHeaderValue();
        }
        catch (JoseException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Unable to retrieve certificate header value from JWS.").withCause(e11).build();
        }
        return CodeTransparencyCryptoUtils.getCertificateFingerprint(certificate);
    }

    public static String getCertificateFingerprint(X509Certificate certificate) {
        return Bytes.asList((byte[])CodeTransparencyCryptoUtils.getCertificateFingerprintBytes(certificate)).stream().map(b11 -> String.format("%02X", b11)).collect(Collectors.joining(" "));
    }

    public static X509Certificate getX509Certificate(Path certificatePath) {
        ImmutableList<X509Certificate> certificates = CodeTransparencyCryptoUtils.getX509Certificates(certificatePath);
        if (certificates.isEmpty()) {
            throw InvalidCommandException.builder().withInternalMessage("Unable to read public key certificate from the provided path.").build();
        }
        return (X509Certificate)certificates.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImmutableList<X509Certificate> getX509Certificates(Path certificatePath) {
        try (InputStream inputStream = Files.newInputStream(certificatePath, new OpenOption[0]);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ImmutableList immutableList = (ImmutableList)certificateFactory.generateCertificates(inputStream).stream().map(certificate -> (X509Certificate)certificate).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
        catch (IOException e11) {
            throw InvalidCommandException.builder().withInternalMessage("Unable to read public key certificate from the provided path.").withCause(e11).build();
        }
        catch (CertificateException e12) {
            throw InvalidCommandException.builder().withInternalMessage("Unable to generate X509Certificate.").withCause(e12).build();
        }
    }

    private static byte[] getCertificateFingerprintBytes(X509Certificate certificate) {
        byte[] certificateBytes;
        try {
            certificateBytes = ByteSource.wrap((byte[])certificate.getEncoded()).hash(Hashing.sha256()).asBytes();
        }
        catch (IOException | CertificateEncodingException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Unable to get certificate fingerprint value.").withCause(e11).build();
        }
        return certificateBytes;
    }

    private CodeTransparencyCryptoUtils() {
    }
}

