/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import java.util.Optional;

public class OpenGlFeatureMatcher
extends TargetingDimensionMatcher<ImmutableList<Targeting.DeviceFeatureTargeting>> {
    private static final String OPEN_GL_DEVICE_NAME = "reqGlEsVersion";
    static final String CONDITIONAL_MODULES_OPEN_GL_NAME = "android.hardware.opengles.version";
    private final int supportedOpenGlVersion;

    public OpenGlFeatureMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
        this.supportedOpenGlVersion = deviceSpec.getDeviceFeaturesList().stream().filter(feature -> feature.startsWith("reqGlEsVersion=")).map(feature -> feature.split("=", 2)[1]).mapToInt(Integer::decode).findFirst().orElse(0);
    }

    @Override
    public boolean matchesTargeting(ImmutableList<Targeting.DeviceFeatureTargeting> targetingValue) {
        Optional maybeMinRequiredOpenGl = (Optional)targetingValue.stream().map(Targeting.DeviceFeatureTargeting::getRequiredFeature).filter(feature -> feature.getFeatureName().equals(CONDITIONAL_MODULES_OPEN_GL_NAME)).map(Targeting.DeviceFeature::getFeatureVersion).collect(MoreCollectors.toOptional());
        return maybeMinRequiredOpenGl.map(minRequiredOpenGl -> this.supportedOpenGlVersion >= minRequiredOpenGl).orElse(true);
    }

    @Override
    protected void checkDeviceCompatibleInternal(ImmutableList<Targeting.DeviceFeatureTargeting> targetingValue) {
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return !this.getDeviceSpec().getDeviceFeaturesList().isEmpty();
    }

    @Override
    protected ImmutableList<Targeting.DeviceFeatureTargeting> getTargetingValue(Targeting.ModuleTargeting moduleTargeting) {
        return ImmutableList.copyOf(moduleTargeting.getDeviceFeatureTargetingList());
    }
}

