/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.utils.StringHelper;

public class StringHelperWindows
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        for (int i4 = 0; i4 < length; ++i4) {
            char c4 = commandLine.charAt(i4);
            if (c4 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c4 == '\\') {
                escapingQuotes = true;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                continue;
            }
            if (c4 == '^') {
                escapingOthers = true;
                continue;
            }
            if (quoting || commandLine.charAt(i4) != '&') continue;
            commands.add(commandLine.substring(commandStart, i4));
            if (commandLine.length() <= ++i4 || commandLine.charAt(i4) == '&') {
                // empty if block
            }
            commandStart = ++i4;
        }
        if (commandStart < length) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, true);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, false);
    }

    private static List<String> tokenizeCommandLine(String commandLine, boolean returnEscaped) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder token = new StringBuilder();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        boolean skipping = true;
        for (int i4 = 0; i4 < commandLine.length(); ++i4) {
            char c4 = commandLine.charAt(i4);
            if (skipping) {
                if (Character.isWhitespace(c4)) continue;
                skipping = false;
            }
            if (!(!quoting && Character.isWhitespace(c4) || returnEscaped)) {
                token.append(c4);
            }
            if (c4 == '\"') {
                if (returnEscaped) {
                    for (int j4 = token.length() - 2; j4 >= 0 && token.charAt(j4) == '\\' && token.charAt(j4 + 1) == '\\'; j4 -= 2) {
                        token.deleteCharAt(j4);
                    }
                }
                if (escapingQuotes) {
                    if (returnEscaped) {
                        token.deleteCharAt(token.length() - 1);
                    }
                } else {
                    quoting = !quoting;
                    continue;
                }
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c4 == '\\') {
                escapingQuotes = true;
            }
            if (escapingOthers) {
                escapingOthers = false;
                if (c4 == '\n') {
                    continue;
                }
            } else if (!quoting && c4 == '^') {
                escapingOthers = true;
                continue;
            }
            if (!quoting && Character.isWhitespace(c4)) {
                skipping = true;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (!returnEscaped) continue;
            token.append(c4);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

