/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.CommandExecutor;
import com.android.tools.build.bundletool.model.DefaultCommandExecutor;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.time.Duration;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2);

    default public ImmutableList<String> dumpBadging(Path apkPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){
            private final Duration timeoutMillis = Duration.ofMinutes(5L);

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk) {
                new DefaultCommandExecutor().execute((ImmutableList<String>)ImmutableList.of((Object)aapt2Path.toString(), (Object)"convert", (Object)"--output-format", (Object)"binary", (Object)"-o", (Object)binaryApk.toString(), (Object)protoApk.toString()), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public ImmutableList<String> dumpBadging(Path apkPath) {
                return new DefaultCommandExecutor().executeAndCapture((ImmutableList<String>)ImmutableList.of((Object)aapt2Path.toString(), (Object)"dump", (Object)"badging", (Object)apkPath.toString()), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }
        };
    }
}

