/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEventBuilder;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEventVisitor;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugPositionState;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.ClassNaming;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.Range;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class LineNumberOptimizer {
    public static ClassNameMapper run(DexApplication application, NamingLens namingLens, boolean identityMapping) {
        IdentityHashMap classesOfFiles = new IdentityHashMap();
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        for (DexProgramClass clazz : application.classes()) {
            if (!clazz.getSynthesizedFrom().isEmpty()) continue;
            IdentityHashMap methodsByName = new IdentityHashMap(clazz.directMethods().length + clazz.virtualMethods().length);
            clazz.forEachMethod(method -> {
                if (namingLens.lookupName(method.method) != method.method.name || LineNumberOptimizer.doesContainPositions(method)) {
                    methodsByName.compute(method.method.name, (name, methods) -> {
                        if (methods == null) {
                            methods = new ArrayList<DexEncodedMethod>();
                        }
                        methods.add(method);
                        return methods;
                    });
                }
            });
            DexString renamedClassName = namingLens.lookupDescriptor(clazz.getType());
            com.google.common.base.Supplier onDemandClassNamingBuilder = Suppliers.memoize(() -> classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(renamedClassName.toString()), clazz.toString()));
            if (!clazz.toString().equals(renamedClassName.toString())) {
                onDemandClassNamingBuilder.get();
            }
            clazz.forEachField(arg_0 -> LineNumberOptimizer.lambda$run$3(namingLens, (Supplier)onDemandClassNamingBuilder, arg_0));
            for (List methods : methodsByName.values()) {
                if (methods.size() > 1) {
                    methods.sort((lhs, rhs) -> {
                        Code rhsCode;
                        DexCode rhsDexCode;
                        DexDebugInfo rhsDebugInfo;
                        int rhsStartLine;
                        Code lhsCode = lhs.getCode();
                        DexCode lhsDexCode = lhsCode == null || !lhsCode.isDexCode() ? null : lhsCode.asDexCode();
                        DexDebugInfo lhsDebugInfo = lhsDexCode == null ? null : lhsDexCode.getDebugInfo();
                        int lhsStartLine = lhsDebugInfo == null ? 0 : lhsDebugInfo.startLine;
                        int startLineDiff = lhsStartLine - (rhsStartLine = (rhsDebugInfo = (rhsDexCode = (rhsCode = rhs.getCode()) == null || !rhsCode.isDexCode() ? null : rhsCode.asDexCode()) == null ? null : rhsDexCode.getDebugInfo()) == null ? 0 : rhsDebugInfo.startLine);
                        if (startLineDiff != 0) {
                            return startLineDiff;
                        }
                        return DexEncodedMethod.slowCompare(lhs, rhs);
                    });
                }
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper();
                for (DexEncodedMethod method2 : methods) {
                    class MappedPosition {
                        private final DexMethod method;
                        private final int originalLine;
                        private final Position caller;
                        private final int obfuscatedLine;

                        MappedPosition(DexMethod method, int originalLine, Position caller, int obfuscatedLine) {
                            this.method = method;
                            this.originalLine = originalLine;
                            this.caller = caller;
                            this.obfuscatedLine = obfuscatedLine;
                        }
                    }
                    ArrayList mappedPositions = new ArrayList();
                    if (LineNumberOptimizer.doesContainPositions(method2)) {
                        DexCode dexCode = method2.getCode().asDexCode();
                        DexDebugInfo debugInfo = dexCode.getDebugInfo();
                        ArrayList processedEvents = new ArrayList();
                        PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, method2.method, processedEvents);
                        EventFilter eventFilter = new EventFilter(debugInfo.startLine, method2.method, processedEvents::add, positionState -> {
                            int currentLine = positionState.getCurrentLine();
                            assert (currentLine >= 0);
                            Position position = positionRemapper.createRemappedPosition(positionState);
                            mappedPositions.add(new MappedPosition(positionState.getCurrentMethod(), currentLine, positionState.getCurrentCallerPosition(), position.line));
                            positionEventEmitter.emitPositionEvents(positionState.getCurrentPc(), position);
                        });
                        for (DexDebugEvent event : debugInfo.events) {
                            event.accept(eventFilter);
                        }
                        DexDebugInfo optimizedDebugInfo = new DexDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(new DexDebugEvent[processedEvents.size()]));
                        if (identityMapping) {
                            assert (optimizedDebugInfo.startLine == debugInfo.startLine);
                            assert (optimizedDebugInfo.events.length == debugInfo.events.length);
                            for (int i = 0; i < debugInfo.events.length; ++i) {
                                assert (optimizedDebugInfo.events[i].equals(debugInfo.events[i]));
                            }
                        }
                        dexCode.setDebugInfo(optimizedDebugInfo);
                    }
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(method2.method);
                    DexString obfuscatedNameDexString = namingLens.lookupName(method2.method);
                    String obfuscatedName = obfuscatedNameDexString.toString();
                    if (mappedPositions.isEmpty()) {
                        if (obfuscatedNameDexString == method2.method.name) continue;
                        ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappedRange(null, originalSignature, null, obfuscatedName);
                        continue;
                    }
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(method2.method, originalSignature);
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        MappedPosition mp;
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size() && (mp = (MappedPosition)mappedPositions.get(j)).method == lastPosition.method && mp.originalLine - lastPosition.originalLine == mp.obfuscatedLine - lastPosition.obfuscatedLine && Objects.equals(mp.caller, lastPosition.caller); ++j) {
                            lastPosition = mp;
                        }
                        Range obfuscatedRange = new Range(firstPosition.obfuscatedLine, lastPosition.obfuscatedLine);
                        Range originalRange = new Range(firstPosition.originalLine, lastPosition.originalLine);
                        ClassNaming.Builder classNamingBuilder = (ClassNaming.Builder)onDemandClassNamingBuilder.get();
                        classNamingBuilder.addMappedRange(obfuscatedRange, signatures.computeIfAbsent(firstPosition.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, ((MappedPosition)firstPosition).method.holder != clazz.getType())), originalRange, obfuscatedName);
                        Position caller = firstPosition.caller;
                        while (caller != null) {
                            Position finalCaller = caller;
                            classNamingBuilder.addMappedRange(obfuscatedRange, signatures.computeIfAbsent(caller.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, finalCaller.method.holder != clazz.getType())), Math.max(caller.line, 0), obfuscatedName);
                            caller = caller.callerPosition;
                        }
                        i = j;
                    }
                }
            }
        }
        return classNameMapperBuilder.build();
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null || !code.isDexCode()) {
            return false;
        }
        DexDebugInfo debugInfo = code.asDexCode().getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        for (DexDebugEvent event : debugInfo.events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$run$3(NamingLens namingLens, Supplier onDemandClassNamingBuilder, DexEncodedField dexEncodedField) {
        DexField dexField = dexEncodedField.field;
        DexString renamedName = namingLens.lookupName(dexField);
        if (renamedName != dexField.name) {
            MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(dexField.name.toString(), dexField.type.toString());
            MemberNaming memberNaming = new MemberNaming(signature, renamedName.toString());
            ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
        }
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private final DexMethod method;
        private int previousPc = -1;
        private Position previousPosition = null;
        private final List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.line;
                this.previousPosition = new Position(this.startLine, null, this.method, null);
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private int nextLineNumber = 1;

        private OptimizingPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(DexDebugPositionState positionState) {
            Position newPosition = new Position(this.nextLineNumber, positionState.getCurrentFile(), positionState.getCurrentMethod(), null);
            ++this.nextLineNumber;
            return newPosition;
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(DexDebugPositionState positionState) {
            return new Position(positionState.getCurrentLine(), positionState.getCurrentFile(), positionState.getCurrentMethod(), positionState.getCurrentCallerPosition());
        }
    }

    private static interface PositionRemapper {
        public Position createRemappedPosition(DexDebugPositionState var1);
    }

    private static class EventFilter
    implements DexDebugEventVisitor {
        private final BypassedEventReceiver bypassedEventReceiver;
        private final PositionEventReceiver positionEventReceiver;
        private final DexDebugPositionState positionState;

        private EventFilter(int startLine, DexMethod method, BypassedEventReceiver bypassedEventReceiver, PositionEventReceiver positionEventReceiver) {
            this.positionState = new DexDebugPositionState(startLine, method);
            this.bypassedEventReceiver = bypassedEventReceiver;
            this.positionEventReceiver = positionEventReceiver;
        }

        @Override
        public void visit(DexDebugEvent.SetPrologueEnd event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.SetEpilogueBegin event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.StartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.EndLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.RestartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.AdvancePC advancePC) {
            this.positionState.visit(advancePC);
        }

        @Override
        public void visit(DexDebugEvent.AdvanceLine advanceLine) {
            this.positionState.visit(advanceLine);
        }

        @Override
        public void visit(DexDebugEvent.SetInlineFrame setInlineFrame) {
            this.positionState.visit(setInlineFrame);
        }

        @Override
        public void visit(DexDebugEvent.Default defaultEvent) {
            this.positionState.visit(defaultEvent);
            this.positionEventReceiver.receivePositionEvent(this.positionState);
        }

        @Override
        public void visit(DexDebugEvent.SetFile setFile) {
            this.positionState.visit(setFile);
        }

        private static interface PositionEventReceiver {
            public void receivePositionEvent(DexDebugPositionState var1);
        }

        private static interface BypassedEventReceiver {
            public void receiveBypassedEvent(DexDebugEvent var1);
        }
    }
}

