/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.code.RemDouble;
import shadow.bundletool.com.android.tools.r8.code.RemDouble2Addr;
import shadow.bundletool.com.android.tools.r8.code.RemFloat;
import shadow.bundletool.com.android.tools.r8.code.RemFloat2Addr;
import shadow.bundletool.com.android.tools.r8.code.RemInt;
import shadow.bundletool.com.android.tools.r8.code.RemInt2Addr;
import shadow.bundletool.com.android.tools.r8.code.RemIntLit16;
import shadow.bundletool.com.android.tools.r8.code.RemIntLit8;
import shadow.bundletool.com.android.tools.r8.code.RemLong;
import shadow.bundletool.com.android.tools.r8.code.RemLong2Addr;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.Bottom;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.LatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ArithmeticBinop;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class Rem
extends ArithmeticBinop {
    public Rem(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    @Override
    public boolean isRem() {
        return true;
    }

    @Override
    public Rem asRem() {
        return this;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateInt(int dest, int left, int right) {
        return new RemInt(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateLong(int dest, int left, int right) {
        return new RemLong(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateFloat(int dest, int left, int right) {
        return new RemFloat(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateDouble(int dest, int left, int right) {
        return new RemDouble(dest, left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateInt2Addr(int left, int right) {
        return new RemInt2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateLong2Addr(int left, int right) {
        return new RemLong2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateFloat2Addr(int left, int right) {
        return new RemFloat2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateDouble2Addr(int left, int right) {
        return new RemDouble2Addr(left, right);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateIntLit8(int dest, int left, int constant) {
        return new RemIntLit8(dest, left, constant);
    }

    @Override
    public shadow.bundletool.com.android.tools.r8.code.Instruction CreateIntLit16(int dest, int left, int constant) {
        return new RemIntLit16(dest, left, constant);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asRem().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asRem().type.ordinal();
    }

    @Override
    public boolean canBeFolded() {
        return super.canBeFolded() && !this.rightValue().isZero();
    }

    @Override
    int foldIntegers(int left, int right) {
        return left % right;
    }

    @Override
    long foldLongs(long left, long right) {
        return left % right;
    }

    @Override
    float foldFloat(float left, float right) {
        return left % right;
    }

    @Override
    double foldDouble(double left, double right) {
        return left % right;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return this.type != NumericType.DOUBLE && this.type != NumericType.FLOAT;
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        LatticeElement rightLattice = getLatticeElement.apply(this.rightValue());
        if (rightLattice.isConst() && !rightLattice.asConst().getConstNumber().isZero()) {
            return super.evaluate(code, getLatticeElement);
        }
        return Bottom.getInstance();
    }

    @Override
    int getCfOpcode() {
        switch (this.type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 112;
            }
            case FLOAT: {
                return 114;
            }
            case LONG: {
                return 113;
            }
            case DOUBLE: {
                return 115;
            }
        }
        throw new Unreachable("Unexpected numeric type: " + (Object)((Object)this.type));
    }
}

