/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.io.PrintStream;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexByteCodeWriter;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class AssemblyWriter
extends DexByteCodeWriter {
    public AssemblyWriter(DexApplication application, InternalOptions options) {
        super(application, options);
    }

    @Override
    String getFileEnding() {
        return ".dump";
    }

    @Override
    void writeClassHeader(DexProgramClass clazz, PrintStream ps) {
        String clazzName = this.application.getProguardMap() != null ? this.application.getProguardMap().originalNameOf(clazz.type) : clazz.type.toSourceString();
        ps.println("# Bytecode for");
        ps.println("# Class: '" + clazzName + "'");
        ps.println();
    }

    @Override
    void writeField(DexEncodedField field, PrintStream ps) {
    }

    @Override
    void writeMethod(DexEncodedMethod method, PrintStream ps) {
        ClassNameMapper naming = this.application.getProguardMap();
        String methodName = naming != null ? naming.originalSignatureOf(method.method).toString() : method.method.name.toString();
        ps.println("#");
        ps.println("# Method: '" + methodName + "':");
        ps.println("#");
        ps.println();
        Code code = method.getCode();
        if (code != null) {
            ps.println(code.toString(method, naming));
        }
    }

    @Override
    void writeClassFooter(DexProgramClass clazz, PrintStream ps) {
    }
}

