/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipOutputStream;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.InternalProgramOutputPathConsumer;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.IOExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

public interface ClassFileConsumer
extends ProgramConsumer {
    public void accept(byte[] var1, String var2, DiagnosticsHandler var3);

    public static ClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path directory;

        public DirectoryConsumer(Path directory) {
            this(directory, null);
        }

        public DirectoryConsumer(Path directory, ClassFileConsumer consumer) {
            super(consumer);
            this.directory = directory;
        }

        @Override
        public void accept(byte[] data, String descriptor, DiagnosticsHandler handler) {
            super.accept(data, descriptor, handler);
            Path target = this.directory.resolve(ArchiveConsumer.getClassFileName(descriptor));
            try {
                DirectoryConsumer.writeFileFromDescriptor(data, target);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(target)));
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.directory;
        }

        private static void writeFileFromDescriptor(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }
    }

    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path archive;
        private final Origin origin;
        private ZipOutputStream stream = null;
        private boolean closed = false;

        public ArchiveConsumer(Path archive) {
            this(archive, null);
        }

        public ArchiveConsumer(Path archive, ClassFileConsumer consumer) {
            super(consumer);
            this.archive = archive;
            this.origin = new PathOrigin(archive);
        }

        @Override
        public void accept(byte[] data, String descriptor, DiagnosticsHandler handler) {
            super.accept(data, descriptor, handler);
            this.synchronizedWrite(ArchiveConsumer.getClassFileName(descriptor), data, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            assert (!this.closed);
            this.closed = true;
            try {
                if (this.stream != null) {
                    this.stream.close();
                    this.stream = null;
                }
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        @Override
        public Path internalGetOutputPath() {
            return this.archive;
        }

        private ZipOutputStream getStream(DiagnosticsHandler handler) {
            assert (!this.closed);
            if (this.stream == null) {
                try {
                    this.stream = new ZipOutputStream(Files.newOutputStream(this.archive, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                }
                catch (IOException e) {
                    handler.error(new IOExceptionDiagnostic(e, this.origin));
                }
            }
            return this.stream;
        }

        private synchronized void synchronizedWrite(String entry, byte[] content, DiagnosticsHandler handler) {
            try {
                ZipUtils.writeToZipStream(this.getStream(handler), entry, content);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        private static String getClassFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".class";
        }

        public static void writeResources(Path archive, List<ProgramResource> resources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (ProgramResource resource : resources) {
                    assert (resource.getClassDescriptors().size() == 1);
                    String className = resource.getClassDescriptors().iterator().next();
                    String entryName = ArchiveConsumer.getClassFileName(className);
                    byte[] bytes = ByteStreams.toByteArray((InputStream)((InputStream)closer.register((Closeable)resource.getByteStream())));
                    ZipUtils.writeToZipStream(out, entryName, bytes);
                }
            }
        }
    }

    public static class ForwardingConsumer
    implements ClassFileConsumer {
        private static final ClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final ClassFileConsumer consumer;

        public ForwardingConsumer(ClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(byte[] data, String descriptor, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(data, descriptor, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

