/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;

public class ClassesDexNameSanitizer {
    private static final Pattern CLASSES_DEX_REGEX_PATTERN = Pattern.compile("dex/classes(\\d*)\\.dex");
    private static final Predicate<ModuleEntry> IS_DEX_FILE = entry -> entry.getPath().toString().matches(CLASSES_DEX_REGEX_PATTERN.pattern());

    @CheckReturnValue
    public BundleModule sanitize(BundleModule module) {
        if (!module.getEntry(ZipPath.create("dex/classes1.dex")).isPresent()) {
            return module;
        }
        Map partitionedEntries = module.getEntries().stream().collect(Collectors.partitioningBy(IS_DEX_FILE, ImmutableList.toImmutableList()));
        ImmutableList dexEntries = (ImmutableList)partitionedEntries.get(true);
        ImmutableList nonDexEntries = (ImmutableList)partitionedEntries.get(false);
        ImmutableList newEntries = ImmutableList.builder().addAll((Iterable)nonDexEntries).addAll((Iterable)dexEntries.stream().map(entry -> new RenamedModuleEntry((ModuleEntry)entry, this::incrementClassesDexNumber)).collect(ImmutableList.toImmutableList())).build();
        return module.toBuilder().setEntryMap((ImmutableMap<ZipPath, ModuleEntry>)((ImmutableMap)newEntries.stream().collect(ImmutableMap.toImmutableMap(ModuleEntry::getPath, Function.identity())))).build();
    }

    private ZipPath incrementClassesDexNumber(ZipPath entryPath) {
        String fileName = entryPath.toString();
        Matcher matcher = CLASSES_DEX_REGEX_PATTERN.matcher(fileName);
        Preconditions.checkState((boolean)matcher.matches());
        String num = matcher.group(1);
        if (num.isEmpty()) {
            return entryPath;
        }
        return ZipPath.create("dex/classes" + (Integer.parseInt(num) + 1) + ".dex");
    }

    private static class RenamedModuleEntry
    implements ModuleEntry {
        private final ModuleEntry moduleEntry;
        private final Function<ZipPath, ZipPath> renameFunction;

        RenamedModuleEntry(ModuleEntry moduleEntry, Function<ZipPath, ZipPath> renameFunction) {
            this.moduleEntry = moduleEntry;
            this.renameFunction = renameFunction;
        }

        @Override
        public InputStream getContent() {
            return this.moduleEntry.getContent();
        }

        @Override
        public ZipPath getPath() {
            return this.renameFunction.apply(this.moduleEntry.getPath());
        }

        @Override
        public boolean isDirectory() {
            return this.moduleEntry.isDirectory();
        }

        @Override
        public boolean shouldCompress() {
            return this.moduleEntry.shouldCompress();
        }

        @Override
        public ModuleEntry setCompression(boolean shouldCompress) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleEntry)) {
                return false;
            }
            return ModuleEntry.equal(this, (ModuleEntry)obj);
        }

        public int hashCode() {
            return this.moduleEntry.hashCode();
        }
    }
}

