/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbiMatcher;
import com.android.tools.build.bundletool.device.LanguageMatcher;
import com.android.tools.build.bundletool.device.ScreenDensityMatcher;
import com.android.tools.build.bundletool.device.SdkVersionMatcher;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ApkMatcher {
    private final SdkVersionMatcher sdkVersionMatcher;
    private final AbiMatcher abiMatcher;
    private final ScreenDensityMatcher screenDensityMatcher;
    private final LanguageMatcher languageMatcher;
    private final Optional<ImmutableSet<String>> requestedModuleNames;
    private final boolean matchInstant;

    public ApkMatcher(Devices.DeviceSpec deviceSpec) {
        this(deviceSpec, Optional.empty(), false);
    }

    public ApkMatcher(Devices.DeviceSpec deviceSpec, Optional<ImmutableSet<String>> requestedModuleNames, boolean matchInstant) {
        Preconditions.checkArgument((!requestedModuleNames.isPresent() || !requestedModuleNames.get().isEmpty() ? 1 : 0) != 0, (Object)"Set of requested split modules cannot be empty.");
        this.sdkVersionMatcher = new SdkVersionMatcher(deviceSpec);
        this.abiMatcher = new AbiMatcher(deviceSpec);
        this.screenDensityMatcher = new ScreenDensityMatcher(deviceSpec);
        this.languageMatcher = new LanguageMatcher(deviceSpec);
        this.requestedModuleNames = requestedModuleNames;
        this.matchInstant = matchInstant;
    }

    public ImmutableList<ZipPath> getMatchingApks(Commands.BuildApksResult buildApksResult) {
        Optional<Commands.Variant> matchingVariant = this.getMatchingVariant(buildApksResult);
        return matchingVariant.isPresent() ? this.getMatchingApksFromVariant(matchingVariant.get()) : ImmutableList.of();
    }

    private Optional<Commands.Variant> getMatchingVariant(Commands.BuildApksResult buildApksResult) {
        ImmutableList matchingVariants = (ImmutableList)buildApksResult.getVariantList().stream().filter(variant -> ApkMatcher.isVariantInstant(variant) == this.matchInstant).filter(variant -> this.matchesVariantTargeting(variant.getTargeting())).collect(ImmutableList.toImmutableList());
        return matchingVariants.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement((Iterable)matchingVariants));
    }

    private ImmutableList<ZipPath> getMatchingApksFromVariant(Commands.Variant variant) {
        ImmutableList.Builder matchedApksBuilder = ImmutableList.builder();
        Predicate<String> moduleNameMatcher = this.getModuleNameMatcher(variant);
        for (Commands.ApkSet apkSet : variant.getApkSetList()) {
            String moduleName = apkSet.getModuleMetadata().getName();
            boolean isInstallTimeModule = !apkSet.getModuleMetadata().getOnDemand();
            for (Commands.ApkDescription apkDescription : apkSet.getApkDescriptionList()) {
                boolean isSplit;
                Targeting.ApkTargeting apkTargeting = apkDescription.getTargeting();
                if (!this.matchesApk(apkTargeting, isSplit = !apkDescription.hasStandaloneApkMetadata(), isInstallTimeModule, moduleName, moduleNameMatcher)) continue;
                matchedApksBuilder.add((Object)ZipPath.create(apkDescription.getPath()));
            }
        }
        return matchedApksBuilder.build();
    }

    private Predicate<String> getModuleNameMatcher(Commands.Variant variant) {
        if (this.requestedModuleNames.isPresent()) {
            this.validateVariant(variant);
            ImmutableMultimap<String, String> moduleDependenciesMap = ApkMatcher.buildAdjacencyMap(variant);
            HashSet<String> dependencyModules = new HashSet<String>((Collection)this.requestedModuleNames.get());
            for (String requestedModuleName : this.requestedModuleNames.get()) {
                ApkMatcher.addModuleDependencies(requestedModuleName, moduleDependenciesMap, dependencyModules);
            }
            return dependencyModules::contains;
        }
        return Predicates.alwaysTrue();
    }

    private void validateVariant(Commands.Variant variant) {
        Sets.SetView unknownModules;
        if (this.requestedModuleNames.isPresent() && !(unknownModules = Sets.difference((Set)((Set)this.requestedModuleNames.get()), (Set)((Set)variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet())))).isEmpty()) {
            throw ValidationException.builder().withMessage("The APK Set archive does not contain the following modules: %s", unknownModules).build();
        }
    }

    private static ImmutableMultimap<String, String> buildAdjacencyMap(Commands.Variant variant) {
        ImmutableMultimap.Builder moduleDependenciesMap = ImmutableMultimap.builder();
        variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).forEach(moduleMetadata -> {
            moduleDependenciesMap.putAll((Object)moduleMetadata.getName(), (Iterable)moduleMetadata.getDependenciesList());
            moduleDependenciesMap.put((Object)moduleMetadata.getName(), (Object)"base");
        });
        return moduleDependenciesMap.build();
    }

    private static void addModuleDependencies(String moduleName, Multimap<String, String> moduleDependenciesMap, Set<String> dependencyModules) {
        if (!moduleDependenciesMap.containsKey((Object)moduleName)) {
            return;
        }
        for (String moduleDependency : moduleDependenciesMap.get((Object)moduleName)) {
            if (!dependencyModules.add(moduleDependency)) continue;
            ApkMatcher.addModuleDependencies(moduleDependency, moduleDependenciesMap, dependencyModules);
        }
    }

    private boolean matchesApk(Targeting.ApkTargeting apkTargeting, boolean isSplit, boolean isInstallTimeModule, String moduleName, Predicate<String> moduleNameMatcher) {
        boolean matchesTargeting = this.matchesApkTargeting(apkTargeting);
        if (isSplit) {
            return matchesTargeting && (isInstallTimeModule && !this.matchInstant || moduleNameMatcher.test((Object)moduleName));
        }
        if (matchesTargeting && this.requestedModuleNames.isPresent()) {
            throw CommandExecutionException.builder().withMessage("Cannot restrict modules when the device matches a non-split APK.").build();
        }
        return matchesTargeting;
    }

    private boolean matchesApkTargeting(Targeting.ApkTargeting apkTargeting) {
        return this.sdkVersionMatcher.getApkTargetingPredicate().and(this.abiMatcher.getApkTargetingPredicate()).and(this.screenDensityMatcher.getApkTargetingPredicate()).and(this.languageMatcher.getApkTargetingPredicate()).test(apkTargeting);
    }

    public boolean matchesModuleSplitByTargeting(ModuleSplit moduleSplit) {
        return this.matchesVariantTargeting(moduleSplit.getVariantTargeting()) && this.matchesApkTargeting(moduleSplit.getApkTargeting());
    }

    private boolean matchesVariantTargeting(Targeting.VariantTargeting variantTargeting) {
        return this.sdkVersionMatcher.getVariantTargetingPredicate().and(this.abiMatcher.getVariantTargetingPredicate()).and(this.screenDensityMatcher.getVariantTargetingPredicate()).test(variantTargeting);
    }

    private static boolean isVariantInstant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasInstantApkMetadata);
    }
}

