/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.utils.DiagnosticWithThrowable;

public class IOExceptionDiagnostic
extends DiagnosticWithThrowable {
    private final Origin origin;
    private final String message;

    public IOExceptionDiagnostic(IOException e) {
        super(e);
        this.origin = IOExceptionDiagnostic.extractOrigin(e);
        this.message = IOExceptionDiagnostic.extractMessage(e);
    }

    public IOExceptionDiagnostic(IOException e, Origin origin) {
        super(e);
        this.origin = origin;
        this.message = IOExceptionDiagnostic.extractMessage(e);
    }

    private static String extractMessage(IOException e) {
        String message = e.getMessage();
        if (message == null || message.isEmpty()) {
            if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
                message = "File not found";
            } else if (e instanceof FileAlreadyExistsException) {
                message = "File already exists";
            }
        }
        return message;
    }

    private static Origin extractOrigin(IOException e) {
        FileSystemException fse;
        Origin origin = Origin.unknown();
        if (e instanceof FileSystemException && (fse = (FileSystemException)e).getFile() != null && !fse.getFile().isEmpty()) {
            origin = new PathOrigin(Paths.get(fse.getFile(), new String[0]));
        }
        return origin;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }
}

