/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;

public class SetUtils {
    public static <T> Set<T> newIdentityHashSet(T element) {
        Set<T> result = Sets.newIdentityHashSet();
        result.add(element);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(Iterable<T> c) {
        Set result = Sets.newIdentityHashSet();
        c.forEach(result::add);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(int capacity) {
        return Collections.newSetFromMap(new IdentityHashMap(capacity));
    }

    public static <T> Set<T> newIdentityHashSet(T element, int capacity) {
        Set<T> result = SetUtils.newIdentityHashSet(capacity);
        result.add(element);
        return result;
    }

    public static <T, S> Set<T> mapIdentityHashSet(Set<S> set, Function<S, T> fn) {
        Set<T> out = SetUtils.newIdentityHashSet(set.size());
        for (S element : set) {
            out.add(fn.apply(element));
        }
        return out;
    }
}

