/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class FlagFile {
    public static String[] expandFlagFiles(String[] args, BaseCommand.Builder builder) {
        ArrayList<String> flags = new ArrayList<String>(args.length);
        for (String arg : args) {
            if (arg.startsWith("@")) {
                Path flagFilePath = Paths.get(arg.substring(1), new String[0]);
                try {
                    flags.addAll(Files.readAllLines(flagFilePath));
                }
                catch (IOException e) {
                    FlagFileOrigin origin = new FlagFileOrigin(flagFilePath);
                    builder.error(new ExceptionDiagnostic(e, origin));
                }
                continue;
            }
            flags.add(arg);
        }
        return flags.toArray(StringUtils.EMPTY_ARRAY);
    }

    private static class FlagFileOrigin
    extends Origin {
        private final Path path;

        protected FlagFileOrigin(Path path) {
            super(Origin.root());
            this.path = path;
        }

        @Override
        public String part() {
            return "flag file argument: '@" + this.path + "'";
        }
    }
}

