/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashMultiset;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Multiset;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.shaking.VerticalClassMerger;
import shadow.bundletool.com.android.tools.r8.utils.FieldSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.SingletonEquivalence;

public class StaticClassMerger {
    private static final int HEURISTIC_FOR_CAPACITY_OF_REPRESENTATIVES = 30;
    private final AppView<AppInfoWithLiveness> appView;
    private final MainDexClasses mainDexClasses;
    private final Equivalence<DexField> fieldEquivalence;
    private final Equivalence<DexMethod> methodEquivalence;
    private final Map<MergeGroup.Key, Representative> representatives = new HashMap<MergeGroup.Key, Representative>();
    private final BiMap<DexField, DexField> fieldMapping = HashBiMap.create();
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private int numberOfMergedClasses = 0;

    public StaticClassMerger(AppView<AppInfoWithLiveness> appView, InternalOptions options, MainDexClasses mainDexClasses) {
        this.appView = appView;
        if (options.getProguardConfiguration().isOverloadAggressively()) {
            this.fieldEquivalence = FieldSignatureEquivalence.getEquivalenceIgnoreName();
            this.methodEquivalence = MethodSignatureEquivalence.getEquivalenceIgnoreName();
        } else {
            this.fieldEquivalence = new SingletonEquivalence<DexField>();
            this.methodEquivalence = MethodJavaSignatureEquivalence.getEquivalenceIgnoreName();
        }
        this.mainDexClasses = mainDexClasses;
    }

    public GraphLense run() {
        for (DexProgramClass clazz : this.appView.appInfo().app().classesWithDeterministicOrder()) {
            MergeGroup group = this.satisfiesMergeCriteria(clazz);
            if (group == MergeGroup.DONT_MERGE) continue;
            this.merge(clazz, group);
        }
        if (Log.ENABLED) {
            Log.info(this.getClass(), "Merged %s classes with %s members.", this.numberOfMergedClasses, this.fieldMapping.size() + this.methodMapping.size());
        }
        return this.buildGraphLense();
    }

    private GraphLense buildGraphLense() {
        if (!this.fieldMapping.isEmpty() || !this.methodMapping.isEmpty()) {
            BiMap<DexField, DexField> originalFieldSignatures = this.fieldMapping.inverse();
            BiMap<DexMethod, DexMethod> originalMethodSignatures = this.methodMapping.inverse();
            return new GraphLense.NestedGraphLense(ImmutableMap.of(), this.methodMapping, this.fieldMapping, originalFieldSignatures, originalMethodSignatures, this.appView.graphLense(), this.appView.dexItemFactory());
        }
        return this.appView.graphLense();
    }

    private MergeGroup satisfiesMergeCriteria(DexProgramClass clazz) {
        if (this.appView.appInfo().neverMerge.contains(clazz.type)) {
            return MergeGroup.DONT_MERGE;
        }
        if (this.appView.options().featureSplitConfiguration != null && this.appView.options().featureSplitConfiguration.isInFeature(clazz)) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.staticFields().size() + clazz.directMethods().size() + clazz.virtualMethods().size() == 0) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.instanceFields().size() > 0) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.staticFields().stream().anyMatch(field -> this.appView.appInfo().isPinned(field.field))) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.directMethods().stream().anyMatch(DexEncodedMethod::isInitializer)) {
            return MergeGroup.DONT_MERGE;
        }
        if (!clazz.virtualMethods().stream().allMatch(DexEncodedMethod::isPrivateMethod)) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.isInANest()) {
            return MergeGroup.DONT_MERGE;
        }
        if (Streams.stream(clazz.methods()).anyMatch(method -> method.accessFlags.isNative() || this.appView.appInfo().isPinned(method.method) || this.appView.appInfo().alwaysInline.contains(method.method) || this.appView.appInfo().noSideEffects.keySet().contains(method.method))) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.classInitializationMayHaveSideEffects(this.appView)) {
            return MergeGroup.DONT_MERGE;
        }
        if (!this.mainDexClasses.isEmpty()) {
            if (this.mainDexClasses.getRoots().contains(clazz.type)) {
                return MergeGroup.MAIN_DEX_ROOTS;
            }
            if (this.mainDexClasses.getDependencies().contains(clazz.type)) {
                return MergeGroup.MAIN_DEX_DEPENDENCIES;
            }
        }
        return MergeGroup.NOT_MAIN_DEX;
    }

    private boolean isValidRepresentative(DexProgramClass clazz) {
        return !clazz.isInterface();
    }

    private boolean merge(DexProgramClass clazz, MergeGroup group) {
        assert (this.satisfiesMergeCriteria(clazz) == group);
        assert (group != MergeGroup.DONT_MERGE);
        return this.merge(clazz, this.mayMergeAcrossPackageBoundaries(clazz) ? group.globalKey() : group.key(clazz.type.getPackageDescriptor()));
    }

    private boolean merge(DexProgramClass clazz, MergeGroup.Key key) {
        Representative representative = this.representatives.get(key);
        if (representative != null) {
            if (representative.hasSynchronizedMethods && clazz.hasStaticSynchronizedMethods()) {
                return false;
            }
            if (this.appView.appInfo().constClassReferences.contains(clazz.type)) {
                return false;
            }
            if (this.isValidRepresentative(clazz) && !((Representative)representative).clazz.accessFlags.isAtLeastAsVisibleAs(clazz.accessFlags)) {
                assert (clazz.type.getPackageDescriptor().equals(key.packageOrGlobal));
                assert (((Representative)representative).clazz.type.getPackageDescriptor().equals(key.packageOrGlobal));
                Representative newRepresentative = this.getOrCreateRepresentative(key, clazz);
                newRepresentative.include(representative.clazz);
                if (!newRepresentative.isFull()) {
                    this.setRepresentative(key, newRepresentative);
                    this.moveMembersFromSourceToTarget(representative.clazz, clazz);
                    return true;
                }
            } else {
                representative.include(clazz);
                if (!representative.isFull()) {
                    this.moveMembersFromSourceToTarget(clazz, representative.clazz);
                    return true;
                }
            }
        }
        if (this.isValidRepresentative(clazz)) {
            this.setRepresentative(key, this.getOrCreateRepresentative(key, clazz));
        }
        return false;
    }

    private Representative getOrCreateRepresentative(MergeGroup.Key key, DexProgramClass clazz) {
        Representative globalRepresentative = this.representatives.get(key.getMergeGroup().globalKey());
        if (globalRepresentative != null && globalRepresentative.clazz == clazz) {
            return globalRepresentative;
        }
        Representative packageRepresentative = this.representatives.get(key);
        if (packageRepresentative != null && packageRepresentative.clazz == clazz) {
            return packageRepresentative;
        }
        return new Representative(clazz);
    }

    private void setRepresentative(MergeGroup.Key key, Representative representative) {
        assert (this.isValidRepresentative(representative.clazz));
        if (Log.ENABLED) {
            if (key.isGlobal()) {
                Log.info(this.getClass(), "Making %s the global representative in group %s", ((Representative)representative).clazz.type.toSourceString(), key.getMergeGroup().toString());
            } else {
                Log.info(this.getClass(), "Making %s the representative for package %s in group %s", ((Representative)representative).clazz.type.toSourceString(), key.getPackageOrGlobal(), key.getMergeGroup().toString());
            }
        }
        this.representatives.put(key, representative);
    }

    private void clearRepresentative(MergeGroup.Key key) {
        if (Log.ENABLED) {
            if (key.isGlobal()) {
                Log.info(this.getClass(), "Removing the global representative", new Object[0]);
            } else {
                Log.info(this.getClass(), "Removing the representative for package %s", key.getPackageOrGlobal());
            }
        }
        this.representatives.remove(key);
    }

    private boolean mayMergeAcrossPackageBoundaries(DexProgramClass clazz) {
        if (!clazz.accessFlags.isPublic()) {
            return false;
        }
        if (!clazz.directMethods().stream().allMatch(method -> method.accessFlags.isPrivate() || method.accessFlags.isPublic())) {
            return false;
        }
        if (!clazz.staticFields().stream().allMatch(field -> field.accessFlags.isPrivate() || field.accessFlags.isPublic())) {
            return false;
        }
        assert (clazz.instanceFields().size() == 0);
        assert (clazz.virtualMethods().stream().allMatch(method -> method.accessFlags.isPrivate()));
        VerticalClassMerger.IllegalAccessDetector registry = new VerticalClassMerger.IllegalAccessDetector(this.appView, clazz);
        for (DexEncodedMethod method2 : clazz.methods()) {
            registry.setContext(method2);
            method2.registerCodeReferences(registry);
            if (!registry.foundIllegalAccess()) continue;
            return false;
        }
        return true;
    }

    private void moveMembersFromSourceToTarget(DexProgramClass sourceClass, DexProgramClass targetClass) {
        if (Log.ENABLED) {
            Log.info(this.getClass(), "Merging %s into %s", sourceClass.type.toSourceString(), targetClass.type.toSourceString());
        }
        assert (targetClass.accessFlags.isAtLeastAsVisibleAs(sourceClass.accessFlags));
        assert (sourceClass.instanceFields().size() == 0);
        assert (targetClass.instanceFields().size() == 0);
        ++this.numberOfMergedClasses;
        targetClass.appendDirectMethods(this.mergeMethods(sourceClass.directMethods(), targetClass.directMethods(), targetClass));
        targetClass.appendVirtualMethods(this.mergeMethods(sourceClass.virtualMethods(), targetClass.virtualMethods(), targetClass));
        targetClass.setStaticFields(this.mergeFields(sourceClass.staticFields(), targetClass.staticFields(), targetClass));
        sourceClass.setDirectMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setStaticFields(DexEncodedField.EMPTY_ARRAY);
    }

    private List<DexEncodedMethod> mergeMethods(List<DexEncodedMethod> sourceMethods, List<DexEncodedMethod> targetMethods, DexProgramClass targetClass) {
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        Set existingMethods = targetMethods.stream().map(targetMethod -> equivalence.wrap(targetMethod.method)).collect(Collectors.toSet());
        Predicate<DexMethod> availableMethodSignatures = method -> !existingMethods.contains(equivalence.wrap(method));
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(sourceMethods.size());
        for (DexEncodedMethod sourceMethod : sourceMethods) {
            DexEncodedMethod sourceMethodAfterMove = this.renameMethodIfNeeded(sourceMethod, targetClass, availableMethodSignatures);
            newMethods.add(sourceMethodAfterMove);
            DexMethod originalMethod = this.methodMapping.inverse().getOrDefault(sourceMethod.method, sourceMethod.method);
            this.methodMapping.forcePut(originalMethod, sourceMethodAfterMove.method);
            existingMethods.add(equivalence.wrap(sourceMethodAfterMove.method));
        }
        return newMethods;
    }

    private DexEncodedField[] mergeFields(List<DexEncodedField> sourceFields, List<DexEncodedField> targetFields, DexProgramClass targetClass) {
        DexEncodedField[] result = new DexEncodedField[sourceFields.size() + targetFields.size()];
        int index = 0;
        for (DexEncodedField targetField2 : targetFields) {
            result[index++] = targetField2;
        }
        FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
        Set existingFields = targetFields.stream().map(targetField -> equivalence.wrap(targetField.field)).collect(Collectors.toSet());
        Predicate<DexField> availableFieldSignatures = field -> !existingFields.contains(equivalence.wrap(field));
        for (DexEncodedField sourceField : sourceFields) {
            DexEncodedField sourceFieldAfterMove = this.renameFieldIfNeeded(sourceField, targetClass, availableFieldSignatures);
            result[index++] = sourceFieldAfterMove;
            DexField originalField = this.fieldMapping.inverse().getOrDefault(sourceField.field, sourceField.field);
            this.fieldMapping.forcePut(originalField, sourceFieldAfterMove.field);
            existingFields.add(equivalence.wrap(sourceFieldAfterMove.field));
        }
        assert (index == result.length);
        return result;
    }

    private DexEncodedMethod renameMethodIfNeeded(DexEncodedMethod method, DexProgramClass targetClass, Predicate<DexMethod> availableMethodSignatures) {
        assert (!method.accessFlags.isConstructor());
        DexString oldName = method.method.name;
        DexMethod newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, oldName);
        if (!availableMethodSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
        }
        return method.toTypeSubstitutedMethod(newSignature);
    }

    private DexEncodedField renameFieldIfNeeded(DexEncodedField field, DexProgramClass targetClass, Predicate<DexField> availableFieldSignatures) {
        DexString oldName = field.field.name;
        DexField newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, oldName);
        if (!availableFieldSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, newName);
                ++count;
            } while (!availableFieldSignatures.test(newSignature));
        }
        return field.toTypeSubstitutedField(newSignature);
    }

    private class Representative {
        private final DexProgramClass clazz;
        private final HashMultiset<Equivalence.Wrapper<DexField>> fieldBuckets = HashMultiset.create();
        private final HashMultiset<Equivalence.Wrapper<DexMethod>> methodBuckets = HashMultiset.create();
        private boolean hasSynchronizedMethods = false;

        public Representative(DexProgramClass clazz) {
            this.clazz = clazz;
            this.include(clazz);
        }

        public void include(DexProgramClass clazz) {
            for (DexEncodedField field : clazz.fields()) {
                Equivalence.Wrapper<DexField> wrapper = StaticClassMerger.this.fieldEquivalence.wrap(field.field);
                this.fieldBuckets.add((Object)wrapper);
            }
            boolean classHasSynchronizedMethods = false;
            for (DexEncodedMethod method : clazz.methods()) {
                assert (!this.hasSynchronizedMethods || !method.accessFlags.isSynchronized());
                classHasSynchronizedMethods |= method.accessFlags.isSynchronized();
                Equivalence.Wrapper<DexMethod> wrapper = StaticClassMerger.this.methodEquivalence.wrap(method.method);
                this.methodBuckets.add((Object)wrapper);
            }
            this.hasSynchronizedMethods |= classHasSynchronizedMethods;
        }

        public boolean isFull() {
            int numberOfNamesNeeded = 1;
            for (Multiset.Entry entry : this.fieldBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            for (Multiset.Entry entry : this.methodBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            return numberOfNamesNeeded > 30;
        }
    }

    static final class MergeGroup
    extends Enum<MergeGroup> {
        public static final /* enum */ MergeGroup MAIN_DEX_ROOTS = new MergeGroup();
        public static final /* enum */ MergeGroup MAIN_DEX_DEPENDENCIES = new MergeGroup();
        public static final /* enum */ MergeGroup NOT_MAIN_DEX = new MergeGroup();
        public static final /* enum */ MergeGroup DONT_MERGE = new MergeGroup();
        private static final String GLOBAL = "<global>";
        private static Key mainDexRootsGlobalKey;
        private static Key mainDexDependenciesGlobalKey;
        private static Key notMainDexGlobalKey;
        private static final /* synthetic */ MergeGroup[] $VALUES;

        public static MergeGroup[] values() {
            return (MergeGroup[])$VALUES.clone();
        }

        public static MergeGroup valueOf(String name) {
            return Enum.valueOf(MergeGroup.class, name);
        }

        public Key globalKey() {
            switch (this) {
                case NOT_MAIN_DEX: {
                    return notMainDexGlobalKey;
                }
                case MAIN_DEX_ROOTS: {
                    return mainDexRootsGlobalKey;
                }
                case MAIN_DEX_DEPENDENCIES: {
                    return mainDexDependenciesGlobalKey;
                }
            }
            throw new Unreachable("Unexpected MergeGroup value");
        }

        public Key key(String pkg) {
            assert (this != DONT_MERGE);
            return new Key(this, pkg);
        }

        public String toString() {
            switch (this) {
                case NOT_MAIN_DEX: {
                    return "outside main dex";
                }
                case MAIN_DEX_ROOTS: {
                    return "main dex roots";
                }
                case MAIN_DEX_DEPENDENCIES: {
                    return "main dex dependencies";
                }
            }
            assert (this == DONT_MERGE);
            return "don't merge";
        }

        static {
            $VALUES = new MergeGroup[]{MAIN_DEX_ROOTS, MAIN_DEX_DEPENDENCIES, NOT_MAIN_DEX, DONT_MERGE};
            mainDexRootsGlobalKey = new Key(MAIN_DEX_ROOTS, GLOBAL);
            mainDexDependenciesGlobalKey = new Key(MAIN_DEX_DEPENDENCIES, GLOBAL);
            notMainDexGlobalKey = new Key(NOT_MAIN_DEX, GLOBAL);
        }

        private static class Key {
            private final MergeGroup mergeGroup;
            private final String packageOrGlobal;

            public Key(MergeGroup mergeGroup, String packageOrGlobal) {
                this.mergeGroup = mergeGroup;
                this.packageOrGlobal = packageOrGlobal;
            }

            public MergeGroup getMergeGroup() {
                return this.mergeGroup;
            }

            public String getPackageOrGlobal() {
                return this.packageOrGlobal;
            }

            public boolean isGlobal() {
                return this.packageOrGlobal.equals(MergeGroup.GLOBAL);
            }

            public int hashCode() {
                return this.mergeGroup.ordinal() * 13 + this.packageOrGlobal.hashCode();
            }

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Key o = (Key)other;
                return o.mergeGroup == this.mergeGroup && o.packageOrGlobal.equals(this.packageOrGlobal);
            }
        }
    }
}

