/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.function.Consumer;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.retrace.Result;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;

public class RetraceTypeResult
extends Result<Element, RetraceTypeResult> {
    private final TypeReference obfuscatedType;
    private final RetraceBase retraceBase;

    RetraceTypeResult(TypeReference obfuscatedType, RetraceBase retraceBase) {
        this.obfuscatedType = obfuscatedType;
        this.retraceBase = retraceBase;
    }

    @Override
    public Stream<Element> stream() {
        if (this.obfuscatedType == null || this.obfuscatedType.isPrimitive()) {
            return Stream.of(new Element(this.obfuscatedType));
        }
        if (this.obfuscatedType.isArray()) {
            int dimensions = this.obfuscatedType.asArray().getDimensions();
            return this.retraceBase.retrace(this.obfuscatedType.asArray().getBaseType()).stream().map(base -> new Element(Reference.array(base.getTypeReference(), dimensions)));
        }
        return this.retraceBase.retrace(this.obfuscatedType.asClass()).stream().map(clazz -> new Element(clazz.getClassReference()));
    }

    @Override
    public RetraceTypeResult forEach(Consumer<Element> resultConsumer) {
        this.stream().forEach(resultConsumer);
        return this;
    }

    public static class Element {
        private final TypeReference typeReference;

        public Element(TypeReference typeReference) {
            this.typeReference = typeReference;
        }

        public TypeReference getTypeReference() {
            return this.typeReference;
        }
    }
}

