/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.Files;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.FieldReference;
import shadow.bundletool.com.android.tools.r8.references.MethodReference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceClassResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceFieldResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceMethodResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceTypeResult;
import shadow.bundletool.com.android.tools.r8.utils.Box;

public class RetraceBaseImpl
implements RetraceBase {
    private static final Set<String> UNKNOWN_SOURCEFILE_NAMES = Sets.newHashSet("", "SourceFile", "Unknown", "Unknown Source");
    private final ClassNameMapper classNameMapper;

    private RetraceBaseImpl(ClassNameMapper classNameMapper) {
        this.classNameMapper = classNameMapper;
    }

    public static RetraceBase create(ClassNameMapper classNameMapper) {
        return new RetraceBaseImpl(classNameMapper);
    }

    @Override
    public RetraceMethodResult retrace(MethodReference methodReference) {
        return this.retrace(methodReference.getHolderClass()).lookupMethod(methodReference.getMethodName());
    }

    @Override
    public RetraceFieldResult retrace(FieldReference fieldReference) {
        return this.retrace(fieldReference.getHolderClass()).lookupField(fieldReference.getFieldName());
    }

    @Override
    public RetraceClassResult retrace(ClassReference classReference) {
        return RetraceClassResult.create(classReference, this.classNameMapper.getClassNaming(classReference.getTypeName()));
    }

    @Override
    public String retraceSourceFile(ClassReference classReference, String sourceFile) {
        Box retracedSourceFile = new Box();
        this.retrace(classReference).forEach(element -> retracedSourceFile.set(element.retraceSourceFile(sourceFile, this)));
        return (String)retracedSourceFile.get();
    }

    @Override
    public RetraceTypeResult retrace(TypeReference typeReference) {
        return new RetraceTypeResult(typeReference, this);
    }

    @Override
    public String retraceSourceFile(ClassReference obfuscatedClass, String sourceFile, ClassReference retracedClassReference, boolean hasRetraceResult) {
        boolean fileNameProbablyChanged;
        boolean bl = fileNameProbablyChanged = hasRetraceResult && !retracedClassReference.getTypeName().startsWith(obfuscatedClass.getTypeName());
        if (!UNKNOWN_SOURCEFILE_NAMES.contains(sourceFile) && !fileNameProbablyChanged) {
            return sourceFile;
        }
        if (!hasRetraceResult) {
            assert (obfuscatedClass.getTypeName().equals(retracedClassReference.getTypeName()));
            return RetraceBaseImpl.getClassSimpleName(obfuscatedClass.getTypeName()) + ".java";
        }
        String newFileName = RetraceBaseImpl.getClassSimpleName(retracedClassReference.getTypeName());
        String extension = Files.getFileExtension(sourceFile);
        if (extension.isEmpty()) {
            extension = "java";
        }
        return newFileName + "." + extension;
    }

    private static String getClassSimpleName(String clazz) {
        int endIndex;
        int lastIndexOfPeriod = clazz.lastIndexOf(46);
        if (lastIndexOfPeriod > (endIndex = clazz.lastIndexOf(36)) || endIndex < 0) {
            endIndex = clazz.length();
        }
        return clazz.substring(lastIndexOfPeriod + 1, endIndex);
    }
}

