/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DictionaryReader
implements AutoCloseable {
    private final BufferedReader reader;
    private final Path path;

    public DictionaryReader(Path path) throws IOException {
        this.path = path;
        this.reader = Files.newBufferedReader(path);
    }

    public String readName(Reporter reporter) throws IOException {
        int readCharAsInt;
        assert (this.reader != null);
        StringBuilder name = new StringBuilder();
        int lineNumber = 1;
        while ((readCharAsInt = this.reader.read()) != -1) {
            boolean isValidEndOfLineInput;
            char readChar = (char)readCharAsInt;
            if (name.length() != 0 && Character.isJavaIdentifierPart(readChar) || name.length() == 0 && Character.isJavaIdentifierStart(readChar)) {
                name.append(readChar);
                continue;
            }
            boolean isCommentChar = readChar == '#';
            boolean bl = isValidEndOfLineInput = readChar == '\n' || readChar == '\r';
            if (isCommentChar || isValidEndOfLineInput) {
                if (isCommentChar) {
                    this.reader.readLine();
                }
                ++lineNumber;
            }
            if (isValidEndOfLineInput && name.length() != 0) {
                return name.toString();
            }
            name = new StringBuilder();
            if (isValidEndOfLineInput) continue;
            reporter.info(new StringDiagnostic("Invalid character in dictionary '" + readChar + "'", new PathOrigin(this.path), new TextPosition(0L, lineNumber, -1)));
            this.reader.readLine();
            ++lineNumber;
        }
        return name.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static ImmutableList<String> readAllNames(Path path, Reporter reporter) {
        if (path != null) {
            HashSet<String> seenNames = new HashSet<String>();
            ImmutableList.Builder namesBuilder = new ImmutableList.Builder();
            try (DictionaryReader reader = new DictionaryReader(path);){
                String name = reader.readName(reporter);
                while (!name.isEmpty()) {
                    if (!seenNames.add(name)) {
                        reporter.error(new StringDiagnostic("Duplicate entry for '" + name + "' in dictionary", new PathOrigin(path)));
                    }
                    namesBuilder.add(name);
                    name = reader.readName(reporter);
                }
            }
            catch (IOException e) {
                reporter.error(new ExceptionDiagnostic(e, new PathOrigin(path)));
            }
            return namesBuilder.build();
        }
        return ImmutableList.of();
    }
}

