/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.Flag;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.FlagsKt;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmValueParameter;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataJvmExtensionUtils;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class KotlinMetadataSynthesizer {
    static boolean isExtension(KmFunction kmFunction) {
        return kmFunction.getReceiverParameterType() != null;
    }

    static KmType toKmType(String descriptor) {
        KmType kmType = new KmType(FlagsKt.flagsOf(new Flag[0]));
        kmType.visitClass(DescriptorUtils.descriptorToInternalName(descriptor));
        return kmType;
    }

    static KmType toRenamedKmType(DexType type, AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        if (type.isArrayType()) {
            return KotlinMetadataSynthesizer.toKmType(Kotlin.addKotlinPrefix("Array;"));
        }
        if (appView.dexItemFactory().kotlin.knownTypeConversion.containsKey(type)) {
            KmType kmType = new KmType(FlagsKt.flagsOf(new Flag[0]));
            DexType convertedType = appView.dexItemFactory().kotlin.knownTypeConversion.get(type);
            assert (convertedType != null);
            kmType.visitClass(DescriptorUtils.descriptorToInternalName(convertedType.toDescriptorString()));
            return kmType;
        }
        DexClass clazz = appView.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        if (!appView.appInfo().isNonProgramTypeOrLiveProgramType(type)) {
            return null;
        }
        DexType renamedType = lens.lookupType(type, appView.dexItemFactory());
        assert (clazz.isProgramClass() || renamedType == type) : type.toSourceString() + " -> " + renamedType.toSourceString();
        KmType kmType = new KmType(FlagsKt.flagsOf(new Flag[0]));
        kmType.visitClass(DescriptorUtils.descriptorToInternalName(renamedType.toDescriptorString()));
        return kmType;
    }

    private static boolean isCompatible(String desc, DexType type) {
        if (desc == null || type == null) {
            return false;
        }
        return desc.equals(type.toDescriptorString());
    }

    private static boolean isCompatible(KmType kmType, DexType type, AppView<?> appView) {
        if (kmType == null || type == null) {
            return false;
        }
        String descriptor = null;
        if (appView.dexItemFactory().kotlin.knownTypeConversion.containsKey(type)) {
            DexType convertedType = appView.dexItemFactory().kotlin.knownTypeConversion.get(type);
            descriptor = convertedType.toDescriptorString();
        }
        if (descriptor == null) {
            descriptor = type.toDescriptorString();
        }
        assert (descriptor != null);
        return descriptor.equals(DescriptorUtils.getDescriptorFromKmType(kmType));
    }

    private static boolean isCompatibleJvmMethodSignature(JvmMethodSignature signature, DexEncodedMethod method) {
        String methodName = method.method.name.toString();
        if (!signature.getName().equals(methodName)) {
            return false;
        }
        if (!KotlinMetadataSynthesizer.isCompatible(KotlinMetadataJvmExtensionUtils.returnTypeFromJvmMethodSignature(signature), method.method.proto.returnType)) {
            return false;
        }
        List<String> parameterTypes = KotlinMetadataJvmExtensionUtils.parameterTypesFromJvmMethodSignature(signature);
        if (parameterTypes == null || parameterTypes.size() != method.method.proto.parameters.size()) {
            return false;
        }
        for (int i = 0; i < method.method.proto.parameters.size(); ++i) {
            if (KotlinMetadataSynthesizer.isCompatible(parameterTypes.get(i), method.method.proto.parameters.values[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleConstructor(KmConstructor constructor, DexEncodedMethod method, AppView<?> appView) {
        List<KmValueParameter> parameters = constructor.getValueParameters();
        if (method.method.proto.parameters.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < method.method.proto.parameters.size(); ++i) {
            KmType kmType = parameters.get(i).getType();
            if (KotlinMetadataSynthesizer.isCompatible(kmType, method.method.proto.parameters.values[i], appView)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleFunction(KmFunction function, DexEncodedMethod method, AppView<?> appView) {
        KotlinMetadataJvmExtensionUtils.KmFunctionProcessor kmFunctionProcessor = new KotlinMetadataJvmExtensionUtils.KmFunctionProcessor(function);
        JvmMethodSignature jvmMethodSignature = kmFunctionProcessor.signature();
        if (jvmMethodSignature != null && KotlinMetadataSynthesizer.isCompatibleJvmMethodSignature(jvmMethodSignature, method)) {
            return true;
        }
        if (!function.getName().equals(method.method.name.toString())) {
            return false;
        }
        if (!KotlinMetadataSynthesizer.isCompatible(function.getReturnType(), method.method.proto.returnType, appView)) {
            return false;
        }
        List<KmValueParameter> parameters = function.getValueParameters();
        if (method.method.proto.parameters.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < method.method.proto.parameters.size(); ++i) {
            KmType kmType = parameters.get(i).getType();
            if (KotlinMetadataSynthesizer.isCompatible(kmType, method.method.proto.parameters.values[i], appView)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleExtension(KmFunction extension, DexEncodedMethod method, AppView<?> appView) {
        KotlinMetadataJvmExtensionUtils.KmFunctionProcessor kmFunctionProcessor = new KotlinMetadataJvmExtensionUtils.KmFunctionProcessor(extension);
        JvmMethodSignature jvmMethodSignature = kmFunctionProcessor.signature();
        if (jvmMethodSignature != null && KotlinMetadataSynthesizer.isCompatibleJvmMethodSignature(jvmMethodSignature, method)) {
            return true;
        }
        if (!extension.getName().equals(method.method.name.toString())) {
            return false;
        }
        if (!KotlinMetadataSynthesizer.isCompatible(extension.getReturnType(), method.method.proto.returnType, appView)) {
            return false;
        }
        List<KmValueParameter> parameters = extension.getValueParameters();
        if (method.method.proto.parameters.size() != parameters.size() + 1) {
            return false;
        }
        assert (method.method.proto.parameters.size() > 0);
        assert (extension.getReceiverParameterType() != null);
        if (!KotlinMetadataSynthesizer.isCompatible(extension.getReceiverParameterType(), method.method.proto.parameters.values[0], appView)) {
            return false;
        }
        for (int i = 1; i < method.method.proto.parameters.size(); ++i) {
            KmType kmType = parameters.get(i - 1).getType();
            if (KotlinMetadataSynthesizer.isCompatible(kmType, method.method.proto.parameters.values[i], appView)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleProperty(KmProperty kmProperty, DexEncodedMethod method, AppView<?> appView) {
        KotlinMetadataJvmExtensionUtils.KmPropertyProcessor kmPropertyProcessor = new KotlinMetadataJvmExtensionUtils.KmPropertyProcessor(kmProperty);
        JvmMethodSignature getterSignature = kmPropertyProcessor.getterSignature();
        if (getterSignature != null && KotlinMetadataSynthesizer.isCompatibleJvmMethodSignature(getterSignature, method)) {
            return true;
        }
        JvmMethodSignature setterSignature = kmPropertyProcessor.setterSignature();
        if (setterSignature != null && KotlinMetadataSynthesizer.isCompatibleJvmMethodSignature(setterSignature, method)) {
            return true;
        }
        String methodName = method.method.name.toString();
        if (!(methodName.startsWith("is") || methodName.startsWith("get") || methodName.startsWith("set") || methodName.endsWith("$annotations"))) {
            return false;
        }
        String propertyName = kmProperty.getName();
        assert (propertyName.length() > 0);
        String annotations = propertyName + "$annotations";
        if (methodName.equals(annotations)) {
            return true;
        }
        String capitalized = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String returnTypeDescriptor = DescriptorUtils.getDescriptorFromKmType(kmProperty.returnType);
        String getterPrefix = returnTypeDescriptor != null && returnTypeDescriptor.endsWith("Boolean;") ? "is" : "get";
        String getter = getterPrefix + capitalized;
        if (methodName.equals(getter) && method.method.proto.parameters.size() == 0 && KotlinMetadataSynthesizer.isCompatible(kmProperty.returnType, method.method.proto.returnType, appView)) {
            return true;
        }
        String setter = "set" + capitalized;
        return methodName.equals(setter) && method.method.proto.returnType.isVoidType() && method.method.proto.parameters.size() == 1 && KotlinMetadataSynthesizer.isCompatible(kmProperty.returnType, method.method.proto.parameters.values[0], appView);
    }

    static KmConstructor toRenamedKmConstructor(DexEncodedMethod method, KmConstructor original, AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        if (!method.isInstanceInitializer() || !appView.appInfo().liveMethods.contains(method.method)) {
            return null;
        }
        KotlinMetadataJvmExtensionUtils.KmConstructorProcessor kmConstructorProcessor = new KotlinMetadataJvmExtensionUtils.KmConstructorProcessor(original);
        JvmMethodSignature jvmMethodSignature = kmConstructorProcessor.signature();
        KmConstructor kmConstructor = jvmMethodSignature != null ? original : new KmConstructor(method.accessFlags.getAsKotlinFlags());
        List<KmValueParameter> parameters = kmConstructor.getValueParameters();
        parameters.clear();
        KotlinMetadataSynthesizer.populateKmValueParameters(parameters, method, appView, lens, false);
        return kmConstructor;
    }

    static KmFunction toRenamedKmFunction(DexEncodedMethod method, KmFunction original, AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        return KotlinMetadataSynthesizer.toRenamedKmFunctionHelper(method, original, appView, lens, false);
    }

    static KmFunction toRenamedKmFunctionAsExtension(DexEncodedMethod method, KmFunction original, AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        return KotlinMetadataSynthesizer.toRenamedKmFunctionHelper(method, original, appView, lens, true);
    }

    private static KmFunction toRenamedKmFunctionHelper(DexEncodedMethod method, KmFunction original, AppView<AppInfoWithLiveness> appView, NamingLens lens, boolean isExtension) {
        if (!method.isLibraryMethodOverride().isTrue() && !appView.appInfo().liveMethods.contains(method.method)) {
            return null;
        }
        DexMethod renamedMethod = lens.lookupMethod(method.method, appView.dexItemFactory());
        assert (!method.isLibraryMethodOverride().isTrue() || renamedMethod == method.method) : method.toSourceString() + " -> " + renamedMethod.toSourceString();
        assert (!isExtension || original != null);
        KmFunction kmFunction = isExtension ? original : new KmFunction(method.accessFlags.getAsKotlinFlags(), renamedMethod.name.toString());
        KmType kmReturnType = KotlinMetadataSynthesizer.toRenamedKmType(method.method.proto.returnType, appView, lens);
        assert (kmReturnType != null);
        kmFunction.setReturnType(kmReturnType);
        if (isExtension) {
            assert (method.method.proto.parameters.values.length > 0);
            KmType kmReceiverType = KotlinMetadataSynthesizer.toRenamedKmType(method.method.proto.parameters.values[0], appView, lens);
            assert (kmReceiverType != null);
            kmFunction.setReceiverParameterType(kmReceiverType);
        }
        List<KmValueParameter> parameters = kmFunction.getValueParameters();
        parameters.clear();
        KotlinMetadataSynthesizer.populateKmValueParameters(parameters, method, appView, lens, isExtension);
        return kmFunction;
    }

    private static void populateKmValueParameters(List<KmValueParameter> parameters, DexEncodedMethod method, AppView<AppInfoWithLiveness> appView, NamingLens lens, boolean isExtension) {
        int i;
        int n = i = isExtension ? 1 : 0;
        while (i < method.method.proto.parameters.values.length) {
            DexType paramType = method.method.proto.parameters.values[i];
            DebugLocalInfo debugLocalInfo = method.getParameterInfo().get(i);
            String parameterName = debugLocalInfo != null ? debugLocalInfo.name.toString() : "p" + i;
            KmValueParameter kmValueParameter = new KmValueParameter(FlagsKt.flagsOf(new Flag[0]), parameterName);
            KmType kmParamType = KotlinMetadataSynthesizer.toRenamedKmType(paramType, appView, lens);
            assert (kmParamType != null);
            kmValueParameter.setType(kmParamType);
            parameters.add(kmValueParameter);
            ++i;
        }
    }
}

