/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.jar;

import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ConstantDynamic;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Handle;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;

public class JarRegisterEffectsVisitor
extends MethodVisitor {
    private final DexType clazz;
    private final UseRegistry registry;
    private final JarApplicationReader application;

    public JarRegisterEffectsVisitor(DexType clazz, UseRegistry registry, JarApplicationReader application) {
        super(458752);
        this.clazz = clazz;
        this.registry = registry;
        this.application = application;
    }

    @Override
    public void visitTypeInsn(int opcode, String name) {
        DexType type = this.application.getTypeFromName(name);
        if (opcode == 187) {
            this.registry.registerNewInstance(type);
        } else if (opcode == 192) {
            this.registry.registerCheckCast(type);
        } else {
            this.registry.registerTypeReference(type);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.registry.registerTypeReference(this.application.getTypeFromDescriptor(desc));
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            if (((Type)cst).getSort() == 11) {
                String descriptor = ((Type)cst).getDescriptor();
                assert (descriptor.charAt(0) == '(');
                this.registry.registerProto(this.application.getProto(descriptor));
            } else {
                this.registry.registerConstClass(this.application.getType((Type)cst));
            }
        } else {
            if (cst instanceof ConstantDynamic) {
                throw new CompilationError("Unsupported dynamic constant: " + cst.toString());
            }
            if (cst instanceof Handle) {
                DexMethodHandle handle = DexMethodHandle.fromAsmHandle((Handle)cst, this.application, this.clazz);
                this.registry.registerMethodHandle(handle, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
            }
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        DexType ownerType = this.application.getTypeFromName(owner);
        DexMethod method = this.application.getMethod(ownerType, name, desc);
        switch (opcode) {
            case 182: {
                this.registry.registerInvokeVirtual(method);
                break;
            }
            case 184: {
                this.registry.registerInvokeStatic(method);
                break;
            }
            case 185: {
                this.registry.registerInvokeInterface(method);
                break;
            }
            case 183: {
                if (name.equals("<init>") || ownerType == this.clazz) {
                    this.registry.registerInvokeDirect(method);
                    break;
                }
                this.registry.registerInvokeSuper(method);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        DexField field = this.application.getField(owner, name, desc);
        switch (opcode) {
            case 180: {
                this.registry.registerInstanceFieldRead(field);
                break;
            }
            case 181: {
                this.registry.registerInstanceFieldWrite(field);
                break;
            }
            case 178: {
                this.registry.registerStaticFieldRead(field);
                break;
            }
            case 179: {
                this.registry.registerStaticFieldWrite(field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.registry.registerCallSite(DexCallSite.fromAsmInvokeDynamic(this.application, this.clazz, name, desc, bsm, bsmArgs));
    }
}

