/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.jar;

import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ConstantDynamic;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Handle;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.tree.TryCatchBlockNode;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class InliningConstraintVisitor
extends MethodVisitor {
    private final JarApplicationReader application;
    private final AppView<AppInfoWithLiveness> appView;
    private final GraphLense graphLense;
    private final InliningConstraints inliningConstraints;
    private final DexEncodedMethod method;
    private final DexType invocationContext;
    private Inliner.ConstraintWithTarget constraint;

    public InliningConstraintVisitor(JarApplicationReader application, AppView<AppInfoWithLiveness> appView, GraphLense graphLense, DexEncodedMethod method, DexType invocationContext) {
        super(458752);
        assert (graphLense.isContextFreeForMethods());
        this.application = application;
        this.appView = appView;
        this.graphLense = graphLense;
        this.inliningConstraints = new InliningConstraints(appView, graphLense);
        this.method = method;
        this.invocationContext = invocationContext;
        this.constraint = method.accessFlags.isSynchronized() ? this.inliningConstraints.forMonitor() : Inliner.ConstraintWithTarget.ALWAYS;
    }

    public void disallowStaticInterfaceMethodCalls() {
        this.inliningConstraints.disallowStaticInterfaceMethodCalls();
    }

    public Inliner.ConstraintWithTarget getConstraint() {
        return this.constraint;
    }

    private void updateConstraint(Inliner.ConstraintWithTarget other) {
        this.constraint = Inliner.ConstraintWithTarget.meet(this.constraint, other, this.appView);
    }

    public boolean isFinished() {
        return this.constraint == Inliner.ConstraintWithTarget.NEVER;
    }

    public void accept(TryCatchBlockNode tryCatchBlock) {
        this.updateConstraint(this.inliningConstraints.forMoveException());
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        DexField field = this.application.getField(owner, name, desc);
        switch (opcode) {
            case 180: {
                this.updateConstraint(this.inliningConstraints.forInstanceGet(field, this.invocationContext));
                break;
            }
            case 181: {
                this.updateConstraint(this.inliningConstraints.forInstancePut(field, this.invocationContext));
                break;
            }
            case 178: {
                this.updateConstraint(this.inliningConstraints.forStaticGet(field, this.invocationContext));
                break;
            }
            case 179: {
                this.updateConstraint(this.inliningConstraints.forStaticPut(field, this.invocationContext));
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type && ((Type)cst).getSort() != 11) {
            DexType type = this.application.getType((Type)cst);
            this.updateConstraint(this.inliningConstraints.forConstClass(type, this.invocationContext));
        } else if (cst instanceof Handle) {
            this.updateConstraint(this.inliningConstraints.forConstMethodHandle());
        } else {
            if (cst instanceof ConstantDynamic) {
                throw new CompilationError("Unsupported dynamic constant: " + cst.toString());
            }
            this.updateConstraint(this.inliningConstraints.forConstInstruction());
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.updateConstraint(this.inliningConstraints.forInvokeCustom());
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        DexType ownerType = this.application.getTypeFromName(owner);
        DexMethod target = this.application.getMethod(ownerType, name, desc);
        this.updateConstraint(InliningConstraintVisitor.getConstraintForInvoke(opcode, target, this.graphLense, this.appView, this.inliningConstraints, this.invocationContext));
    }

    public static Inliner.ConstraintWithTarget getConstraintForInvoke(int opcode, DexMethod target, GraphLense graphLense, AppView<?> appView, InliningConstraints inliningConstraints, DexType invocationContext) {
        Invoke.Type type;
        switch (opcode) {
            case 185: {
                type = graphLense.lookupMethod(target, null, Invoke.Type.INTERFACE).getType();
                assert (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL);
                break;
            }
            case 183: {
                if (appView.dexItemFactory().isConstructor(target)) {
                    type = Invoke.Type.DIRECT;
                    assert (InliningConstraintVisitor.noNeedToUseGraphLense(target, type, graphLense));
                    break;
                }
                if (target.holder == invocationContext) {
                    type = graphLense.lookupMethod(target, null, Invoke.Type.DIRECT).getType();
                    assert (type == Invoke.Type.DIRECT || type == Invoke.Type.VIRTUAL);
                    break;
                }
                type = Invoke.Type.SUPER;
                assert (InliningConstraintVisitor.noNeedToUseGraphLense(target, type, graphLense));
                break;
            }
            case 184: {
                GraphLense.GraphLenseLookupResult lookup = graphLense.lookupMethod(target, null, Invoke.Type.STATIC);
                target = lookup.getMethod();
                type = lookup.getType();
                break;
            }
            case 182: {
                DexClass clazz;
                type = Invoke.Type.VIRTUAL;
                if (target.holder == invocationContext && (clazz = appView.definitionFor(target.holder)) != null && clazz.lookupDirectMethod(target) != null) {
                    type = Invoke.Type.DIRECT;
                }
                GraphLense.GraphLenseLookupResult lookup = graphLense.lookupMethod(target, null, type);
                target = lookup.getMethod();
                type = lookup.getType();
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
        return inliningConstraints.forInvoke(target, type, invocationContext);
    }

    private static boolean noNeedToUseGraphLense(DexMethod method, Invoke.Type type, GraphLense graphLense) {
        assert (graphLense.lookupMethod(method, null, type).getType() == type);
        return true;
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 194: 
            case 195: {
                this.updateConstraint(this.inliningConstraints.forMonitor());
                break;
            }
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        DexType type = this.application.getTypeFromDescriptor(desc);
        this.updateConstraint(this.inliningConstraints.forInvokeMultiNewArray(type, this.invocationContext));
    }

    @Override
    public void visitTypeInsn(int opcode, String typeName) {
        DexType type = this.application.getTypeFromName(typeName);
        switch (opcode) {
            case 189: {
                this.updateConstraint(this.inliningConstraints.forNewArrayEmpty(type, this.invocationContext));
                break;
            }
            case 192: {
                this.updateConstraint(this.inliningConstraints.forCheckCast(type, this.invocationContext));
                break;
            }
            case 193: {
                this.updateConstraint(this.inliningConstraints.forInstanceOf(type, this.invocationContext));
                break;
            }
            case 187: {
                this.updateConstraint(this.inliningConstraints.forNewInstance(type, this.invocationContext));
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }
}

