/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.ir.code.Dup;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Load;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValue;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValues;
import shadow.bundletool.com.android.tools.r8.ir.code.Store;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Match;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Point;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Wildcard;

public class StoreLoadToDupStorePeephole
implements BasicBlockPeephole {
    private final Point storeExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isStore));
    private final Point loadExp = new Point(Instruction::isLoad);
    private final Wildcard dupsExp = new Wildcard(i -> i.isDup() || i.isDup2());
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.loadExp, this.dupsExp);

    @Override
    public boolean match(InstructionListIterator it) {
        StackValue dupIn;
        StackValue lastOut;
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Store store = this.storeExp.get(match).asStore();
        Load load = this.loadExp.get(match).asLoad();
        if (load.src() != store.outValue() || store.outValue().numberOfAllUsers() <= 1) {
            return false;
        }
        List<Instruction> dups = this.dupsExp.get(match);
        StackValue oldStoreSrc = (StackValue)store.src();
        if (dups.isEmpty()) {
            lastOut = (StackValue)load.outValue();
            dupIn = oldStoreSrc;
        } else {
            assert (dups.get(0).isDup() && dups.get(0).inValues().get(0) == load.outValue());
            dups.get(0).replaceValue(0, (Value)oldStoreSrc);
            PeepholeHelper.moveInstructionsUpToCurrentPosition(it, dups);
            StackValue[] lastDupOutValues = ((StackValues)dups.get(dups.size() - 1).outValue()).getStackValues();
            dupIn = lastOut = lastDupOutValues[lastDupOutValues.length - 1];
        }
        StackValue newLastOut = lastOut.duplicate(lastOut.getHeight());
        StackValue newStoreSrc = lastOut.duplicate(lastOut.getHeight() + 1);
        lastOut.replaceUsers(newLastOut);
        assert (!load.outValue().isUsed());
        Dup dup = new Dup(newLastOut, newStoreSrc, dupIn);
        dup.setPosition(store.getPosition());
        it.add(dup);
        store.replaceValue(0, (Value)newStoreSrc);
        it.nextUntil(i -> i == load);
        it.removeOrReplaceByDebugLocalRead();
        PeepholeHelper.resetNext(it, dups.size() + 1);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

