/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.library;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CodeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.library.BooleanMethodOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.library.LibraryMethodModelCollection;
import shadow.bundletool.com.android.tools.r8.ir.optimize.library.NopLibraryMethodModelCollection;

public class LibraryMethodOptimizer
implements CodeOptimization {
    private final AppView<?> appView;
    private final Map<DexType, LibraryMethodModelCollection> libraryMethodModelCollections = new IdentityHashMap<DexType, LibraryMethodModelCollection>();

    public LibraryMethodOptimizer(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
        this.register(new BooleanMethodOptimizer(appView));
    }

    private void register(LibraryMethodModelCollection optimizer) {
        LibraryMethodModelCollection existing = this.libraryMethodModelCollections.put(optimizer.getType(), optimizer);
        assert (existing == null);
    }

    @Override
    public void optimize(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator instructionIterator = code.instructionListIterator();
        while (instructionIterator.hasNext()) {
            InvokeMethod invoke;
            DexEncodedMethod singleTarget;
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!instruction.isInvokeMethod() || (singleTarget = (invoke = instruction.asInvokeMethod()).lookupSingleTarget(this.appView, code.method.method.holder)) == null) continue;
            this.optimizeInvoke(code, instructionIterator, invoke, singleTarget, affectedValues);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private void optimizeInvoke(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, DexEncodedMethod singleTarget, Set<Value> affectedValues) {
        LibraryMethodModelCollection optimizer = this.libraryMethodModelCollections.getOrDefault(singleTarget.method.holder, NopLibraryMethodModelCollection.getInstance());
        optimizer.optimize(code, instructionIterator, invoke, singleTarget, affectedValues);
    }
}

