/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.DeterminismAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.InitializedClassesOnNormalExitAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.sideeffect.ClassInitializerSideEffectAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerEligibilityInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerReceiverAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ParameterUsagesInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.DefaultInstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.NonTrivialInstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class MethodOptimizationInfoCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions options;
    private final DexItemFactory dexItemFactory;

    public MethodOptimizationInfoCollector(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.options = appView.options();
        this.dexItemFactory = appView.dexItemFactory();
    }

    public void collectMethodOptimizationInfo(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback, DynamicTypeOptimization dynamicTypeOptimization) {
        this.identifyClassInlinerEligibility(method, code, feedback);
        this.identifyParameterUsages(method, code, feedback);
        this.identifyReturnsArgument(method, code, feedback);
        if (this.options.enableInlining) {
            this.identifyInvokeSemanticsForInlining(method, code, this.appView, feedback);
        }
        this.computeDynamicReturnType(dynamicTypeOptimization, feedback, method, code);
        this.computeInitializedClassesOnNormalExit(feedback, method, code);
        this.computeInstanceInitializerInfo(method, code, feedback);
        this.computeMayHaveSideEffects(feedback, method, code);
        this.computeReturnValueOnlyDependsOnArguments(feedback, method, code);
        this.computeNonNullParamOrThrow(feedback, method, code);
        this.computeNonNullParamOnNormalExits(feedback, code);
    }

    private void identifyClassInlinerEligibility(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        boolean instanceInitializer = method.isInstanceInitializer();
        if (method.accessFlags.isNative() || !method.isNonAbstractVirtualMethod() && !instanceInitializer) {
            return;
        }
        feedback.setClassInlinerEligibility(method, null);
        Value receiver = code.getThis();
        if (receiver.numberOfPhiUsers() > 0) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(method.method.holder);
        if (clazz == null) {
            return;
        }
        ArrayList<Pair<Invoke.Type, DexMethod>> callsReceiver = new ArrayList<Pair<Invoke.Type, DexMethod>>();
        boolean seenSuperInitCall = false;
        boolean seenMonitor = false;
        for (Instruction insn : receiver.aliasedUsers()) {
            DexMethod invokedMethod;
            if (insn.isAssume()) continue;
            if (insn.isMonitor()) {
                seenMonitor = true;
                continue;
            }
            if (insn.isInstanceGet() || insn.isInstancePut()) {
                if (insn.isInstancePut()) {
                    InstancePut instancePutInstruction = insn.asInstancePut();
                    if (instancePutInstruction.object().getAliasedValue() != receiver) {
                        return;
                    }
                    if (instancePutInstruction.value().getAliasedValue() == receiver) {
                        return;
                    }
                }
                DexField field = insn.asFieldInstruction().getField();
                if (this.appView.appInfo().resolveFieldOn(clazz, field) != null) continue;
                return;
            }
            if (insn.isInvokeDirect()) {
                InvokeDirect invokedDirect = insn.asInvokeDirect();
                invokedMethod = invokedDirect.getInvokedMethod();
                if (this.dexItemFactory.isConstructor(invokedMethod) && invokedMethod.holder == clazz.superType && ListUtils.lastIndexMatching(invokedDirect.inValues(), v -> v.getAliasedValue() == receiver) == 0 && !seenSuperInitCall && instanceInitializer) {
                    seenSuperInitCall = true;
                    continue;
                }
                return;
            }
            if (insn.isInvokeVirtual()) {
                InvokeVirtual invoke = insn.asInvokeVirtual();
                if (invoke.getReceiver().getAliasedValue() != receiver) {
                    return;
                }
                for (int i = 1; i < invoke.arguments().size(); ++i) {
                    Value argument = invoke.arguments().get(i);
                    if (argument.getAliasedValue() != receiver) continue;
                    return;
                }
                invokedMethod = invoke.getInvokedMethod();
                DexType returnType = invokedMethod.proto.returnType;
                if (returnType.isClassType() && this.appView.appInfo().isRelatedBySubtyping(returnType, method.method.holder)) {
                    return;
                }
                callsReceiver.add(new Pair<Invoke.Type, DexMethod>(Invoke.Type.VIRTUAL, invokedMethod));
                continue;
            }
            if (insn.isReturn()) continue;
            return;
        }
        if (instanceInitializer && !seenSuperInitCall) {
            return;
        }
        boolean synchronizedVirtualMethod = method.accessFlags.isSynchronized() && method.isVirtualMethod();
        feedback.setClassInlinerEligibility(method, new ClassInlinerEligibilityInfo(callsReceiver, new ClassInlinerReceiverAnalysis(this.appView, method, code).computeReturnsReceiver(), seenMonitor || synchronizedVirtualMethod));
    }

    private void identifyParameterUsages(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        ArrayList<ParameterUsagesInfo.ParameterUsage> usages = new ArrayList<ParameterUsagesInfo.ParameterUsage>();
        List<Value> values2 = code.collectArguments();
        for (int i = 0; i < values2.size(); ++i) {
            ParameterUsagesInfo.ParameterUsage usage;
            Value value = values2.get(i);
            if (value.numberOfPhiUsers() > 0 || (usage = this.collectParameterUsages(i, value)) == null) continue;
            usages.add(usage);
        }
        feedback.setParameterUsages(method, usages.isEmpty() ? DefaultMethodOptimizationInfo.UNKNOWN_PARAMETER_USAGE_INFO : new ParameterUsagesInfo(usages));
    }

    private ParameterUsagesInfo.ParameterUsage collectParameterUsages(int i, Value value) {
        ParameterUsagesInfo.ParameterUsageBuilder builder = new ParameterUsagesInfo.ParameterUsageBuilder(value, i);
        for (Instruction user : value.aliasedUsers()) {
            if (builder.note(user)) continue;
            return null;
        }
        return builder.build();
    }

    private void identifyReturnsArgument(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Value aliasedValue;
        List<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.isEmpty()) {
            feedback.methodNeverReturnsNormally(method);
            return;
        }
        Return firstExit = normalExits.get(0).exit().asReturn();
        if (firstExit.isReturnVoid()) {
            return;
        }
        Value returnValue = firstExit.returnValue();
        boolean isNeverNull = returnValue.getTypeLattice().isReference() && returnValue.isNeverNull();
        for (int i = 1; i < normalExits.size(); ++i) {
            Return exit = normalExits.get(i).exit().asReturn();
            Value value = exit.returnValue();
            if (value != returnValue) {
                returnValue = null;
            }
            isNeverNull &= value.getTypeLattice().isReference() && value.isNeverNull();
        }
        if (returnValue != null && !(aliasedValue = returnValue.getAliasedValue()).isPhi()) {
            DexType context;
            AbstractValue abstractReturnValue;
            Instruction definition = aliasedValue.definition;
            if (definition.isArgument()) {
                int index = aliasedValue.computeArgumentPosition(code);
                assert (index >= 0);
                feedback.methodReturnsArgument(method, index);
            }
            if ((abstractReturnValue = definition.getAbstractValue(this.appView, context = method.method.holder)).isNonTrivial()) {
                feedback.methodReturnsAbstractValue(method, this.appView, abstractReturnValue);
            }
        }
        if (isNeverNull) {
            feedback.methodNeverReturnsNull(method);
        }
    }

    private void computeInstanceInitializerInfo(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        assert (!this.appView.appInfo().isPinned(method.method));
        if (!method.isInstanceInitializer()) {
            return;
        }
        if (method.accessFlags.isNative()) {
            return;
        }
        if (this.appView.appInfo().mayHaveSideEffects.containsKey(method.method)) {
            return;
        }
        DexClass clazz = this.appView.appInfo().definitionFor(method.method.holder);
        if (clazz == null) {
            assert (false);
            return;
        }
        InstanceInitializerInfo instanceInitializerInfo = this.analyzeInstanceInitializer(code, clazz);
        feedback.setInstanceInitializerInfo(method, instanceInitializerInfo != null ? instanceInitializerInfo : DefaultInstanceInitializerInfo.getInstance());
    }

    private InstanceInitializerInfo analyzeInstanceInitializer(IRCode code, DexClass clazz) {
        if (clazz.definesFinalizer(this.options.itemFactory)) {
            return null;
        }
        NonTrivialInstanceInitializerInfo.Builder builder = NonTrivialInstanceInitializerInfo.builder();
        Value receiver = code.getThis();
        boolean hasCatchHandler = false;
        for (BasicBlock block : code.blocks) {
            if (block.hasCatchHandlers()) {
                hasCatchHandler = true;
            }
            block12: for (Instruction instruction : block.getInstructions()) {
                block0 : switch (instruction.opcode()) {
                    case 5: 
                    case 9: 
                    case 15: 
                    case 24: 
                    case 54: {
                        break;
                    }
                    case 25: {
                        builder.setInstanceFieldInitializationMayDependOnEnvironment();
                        break;
                    }
                    case 0: 
                    case 4: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 20: 
                    case 21: 
                    case 28: 
                    case 44: 
                    case 46: 
                    case 51: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: {
                        if (!instruction.instructionMayHaveSideEffects(this.appView, clazz.type)) continue block12;
                        builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        break;
                    }
                    case 27: 
                    case 57: {
                        FieldInstruction fieldGet = instruction.asFieldInstruction();
                        DexEncodedField field = this.appView.appInfo().resolveField(fieldGet.getField());
                        if (field == null) {
                            return null;
                        }
                        builder.markFieldAsRead(field);
                        if (!fieldGet.instructionMayHaveSideEffects(this.appView, clazz.type)) continue block12;
                        builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        if (!fieldGet.isStaticGet()) continue block12;
                        builder.markAllFieldsAsRead();
                        break;
                    }
                    case 29: {
                        Value value;
                        InstancePut instancePut = instruction.asInstancePut();
                        DexEncodedField field = this.appView.appInfo().resolveField(instancePut.getField());
                        if (field == null) {
                            return null;
                        }
                        if (instancePut.object().getAliasedValue() != receiver || instancePut.instructionInstanceCanThrow(this.appView, clazz.type).isThrowing()) {
                            builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        }
                        if (!(value = instancePut.value().getAliasedValue()).onlyDependsOnArgument()) {
                            builder.setInstanceFieldInitializationMayDependOnEnvironment();
                        }
                        if (value != receiver) continue block12;
                        builder.setReceiverMayEscapeOutsideConstructorChain();
                        break;
                    }
                    case 32: {
                        Invoke invoke = instruction.asInvokeDirect();
                        DexMethod invokedMethod = ((InvokeMethod)invoke).getInvokedMethod();
                        DexEncodedMethod singleTarget = this.appView.definitionFor(invokedMethod);
                        if (singleTarget == null) {
                            return null;
                        }
                        if (singleTarget.isInstanceInitializer() && ((InvokeMethodWithReceiver)invoke).getReceiver() == receiver) {
                            if (builder.hasParent()) {
                                return null;
                            }
                            if (invokedMethod == this.dexItemFactory.enumMethods.constructor || invokedMethod == this.dexItemFactory.objectMethods.constructor) {
                                builder.setParent(invokedMethod);
                                break;
                            }
                            builder.merge(singleTarget.getOptimizationInfo().getInstanceInitializerInfo());
                            for (int i = 1; i < invoke.arguments().size(); ++i) {
                                Value argument = invoke.arguments().get(i).getAliasedValue();
                                if (argument == receiver) {
                                    builder.setReceiverMayEscapeOutsideConstructorChain();
                                }
                                if (argument.onlyDependsOnArgument()) continue;
                                builder.setInstanceFieldInitializationMayDependOnEnvironment();
                            }
                            builder.setParent(invokedMethod);
                            break;
                        }
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        for (Value inValue : invoke.inValues()) {
                            if (inValue.getAliasedValue() != receiver) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block12;
                    }
                    case 35: {
                        Invoke invoke = instruction.asInvokeNewArray();
                        if (((InvokeNewArray)invoke).instructionMayHaveSideEffects(this.appView, clazz.type)) {
                            builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        }
                        for (Value argument : invoke.arguments()) {
                            if (argument.getAliasedValue() != receiver) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block12;
                    }
                    case 33: 
                    case 37: 
                    case 39: {
                        Invoke invoke = instruction.asInvokeMethod();
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        for (Value argument : invoke.arguments()) {
                            if (argument.getAliasedValue() != receiver) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block12;
                    }
                    case 48: {
                        NewInstance newInstance = instruction.asNewInstance();
                        if (!newInstance.instructionMayHaveSideEffects(this.appView, clazz.type)) continue block12;
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        break;
                    }
                    default: {
                        builder.markAllFieldsAsRead().setInstanceFieldInitializationMayDependOnEnvironment().setMayHaveOtherSideEffectsThanInstanceFieldAssignments().setReceiverMayEscapeOutsideConstructorChain();
                    }
                }
            }
        }
        if (hasCatchHandler && builder.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
            builder.setInstanceFieldInitializationMayDependOnEnvironment();
        }
        return builder.build();
    }

    private void identifyInvokeSemanticsForInlining(DexEncodedMethod method, IRCode code, AppView<?> appView, OptimizationFeedback feedback) {
        if (method.isStatic()) {
            feedback.markTriggerClassInitBeforeAnySideEffect(method, MethodOptimizationInfoCollector.triggersClassInitializationBeforeSideEffect(method.method.holder, code, appView));
        } else {
            Value receiver = code.getThis();
            feedback.markCheckNullReceiverBeforeAnySideEffect(method, receiver.isUsed() && MethodOptimizationInfoCollector.checksNullBeforeSideEffect(code, receiver, appView));
        }
    }

    private static boolean triggersClassInitializationBeforeSideEffect(DexType clazz, IRCode code, AppView<?> appView) {
        return MethodOptimizationInfoCollector.alwaysTriggerExpectedEffectBeforeAnythingElse(code, (instruction, it) -> {
            DexType context = code.method.method.holder;
            if (instruction.definitelyTriggersClassInitialization(clazz, context, appView, ClassInitializationAnalysis.Query.DIRECTLY, ClassInitializationAnalysis.AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW)) {
                if (!instruction.getBlock().hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (instruction.instructionMayHaveSideEffects(appView, clazz)) {
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean alwaysTriggerExpectedEffectBeforeAnythingElse(IRCode code, BiFunction<Instruction, InstructionIterator, InstructionEffect> function) {
        int color = code.reserveMarkingColor();
        try {
            ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
            BasicBlock entry = code.entryBlock();
            worklist.add(entry);
            entry.mark(color);
            while (!worklist.isEmpty()) {
                Instruction lastInstruction;
                BasicBlock currentBlock = (BasicBlock)worklist.poll();
                assert (currentBlock.isMarked(color));
                InstructionEffect result = InstructionEffect.NO_EFFECT;
                InstructionIterator it = currentBlock.iterator();
                while (result == InstructionEffect.NO_EFFECT && it.hasNext()) {
                    result = function.apply((Instruction)it.next(), it);
                }
                if (result == InstructionEffect.OTHER_EFFECT) {
                    boolean bl = false;
                    return bl;
                }
                if (result == InstructionEffect.DESIRED_EFFECT) continue;
                if (result == InstructionEffect.CONDITIONAL_EFFECT) {
                    assert (!currentBlock.getNormalSuccessors().isEmpty());
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isIf());
                    BasicBlock targetIfReceiverIsNull = lastInstruction.asIf().targetFromCondition(0);
                    if (targetIfReceiverIsNull.isMarked(color)) continue;
                    worklist.add(targetIfReceiverIsNull);
                    targetIfReceiverIsNull.mark(color);
                    continue;
                }
                assert (result == InstructionEffect.NO_EFFECT);
                if (currentBlock.getNormalSuccessors().isEmpty()) {
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isReturn() || lastInstruction.isThrow());
                    boolean targetIfReceiverIsNull = false;
                    return targetIfReceiverIsNull;
                }
                for (BasicBlock successor : currentBlock.getSuccessors()) {
                    if (successor.isMarked(color)) continue;
                    worklist.add(successor);
                    successor.mark(color);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            code.returnMarkingColor(color);
        }
    }

    private static boolean checksNullBeforeSideEffect(IRCode code, Value value, AppView<?> appView) {
        return MethodOptimizationInfoCollector.alwaysTriggerExpectedEffectBeforeAnythingElse(code, (instr, it) -> {
            BasicBlock currentBlock = instr.getBlock();
            if (!currentBlock.hasCatchHandlers() && MethodOptimizationInfoCollector.isNullCheck(instr, value)) {
                return InstructionEffect.CONDITIONAL_EFFECT;
            }
            if (MethodOptimizationInfoCollector.isKotlinNullCheck(instr, value, appView)) {
                DexMethod invokedMethod = instr.asInvokeStatic().getInvokedMethod();
                if (invokedMethod.name == appView.dexItemFactory().kotlin.intrinsics.throwParameterIsNullException.name) {
                    for (BasicBlock predecessor : currentBlock.getPredecessors()) {
                        if (!MethodOptimizationInfoCollector.isNullCheck(predecessor.exit(), value)) continue;
                        return InstructionEffect.DESIRED_EFFECT;
                    }
                    return InstructionEffect.NO_EFFECT;
                }
                assert (invokedMethod.name == appView.dexItemFactory().kotlin.intrinsics.checkParameterIsNotNull.name);
                return InstructionEffect.DESIRED_EFFECT;
            }
            if (MethodOptimizationInfoCollector.isInstantiationOfNullPointerException(instr, it, appView.dexItemFactory())) {
                it.next();
                return InstructionEffect.NO_EFFECT;
            }
            if (instr.throwsNpeIfValueIsNull(value, appView.dexItemFactory())) {
                if (!currentBlock.hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (instr.instructionMayHaveSideEffects(appView, code.method.method.holder)) {
                if (instr.isConstString() && !instr.instructionInstanceCanThrow()) {
                    return InstructionEffect.NO_EFFECT;
                }
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    private static boolean isKotlinNullCheck(Instruction instr, Value value, AppView<?> appView) {
        if (appView.options().kotlinOptimizationOptions().disableKotlinSpecificOptimizations) {
            return false;
        }
        if (!instr.isInvokeStatic()) {
            return false;
        }
        MethodSignatureEquivalence wrapper = MethodSignatureEquivalence.get();
        Equivalence.Wrapper<DexMethod> checkParameterIsNotNull = wrapper.wrap(appView.dexItemFactory().kotlin.intrinsics.checkParameterIsNotNull);
        Equivalence.Wrapper<DexMethod> throwParamIsNullException = wrapper.wrap(appView.dexItemFactory().kotlin.intrinsics.throwParameterIsNullException);
        DexMethod invokedMethod = appView.graphLense().getOriginalMethodSignature(instr.asInvokeStatic().getInvokedMethod());
        Equivalence.Wrapper<DexMethod> methodWrap = wrapper.wrap(invokedMethod);
        return (methodWrap.equals(throwParamIsNullException) || methodWrap.equals(checkParameterIsNotNull) && instr.inValues().get(0).equals(value)) && invokedMethod.holder.getPackageDescriptor().startsWith(Kotlin.NAME);
    }

    private static boolean isNullCheck(Instruction instr, Value value) {
        return instr.isIf() && instr.asIf().isZeroTest() && instr.inValues().get(0).equals(value) && (instr.asIf().getType() == If.Type.EQ || instr.asIf().getType() == If.Type.NE);
    }

    private static boolean isInstantiationOfNullPointerException(Instruction instruction, InstructionIterator it, DexItemFactory dexItemFactory) {
        if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != dexItemFactory.npeType) {
            return false;
        }
        Instruction next = it.peekNext();
        return next != null && next.isInvokeDirect() && next.asInvokeDirect().getInvokedMethod() == dexItemFactory.npeMethods.init;
    }

    private void computeDynamicReturnType(DynamicTypeOptimization dynamicTypeOptimization, OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (dynamicTypeOptimization != null) {
            ClassTypeLatticeElement exactReturnType;
            TypeLatticeElement staticReturnType;
            DexType staticReturnTypeRaw = method.method.proto.returnType;
            if (!staticReturnTypeRaw.isReferenceType()) {
                return;
            }
            TypeLatticeElement dynamicReturnType = dynamicTypeOptimization.computeDynamicReturnType(method, code);
            if (dynamicReturnType != null && dynamicReturnType.strictlyLessThan(staticReturnType = TypeLatticeElement.fromDexType(staticReturnTypeRaw, Nullability.maybeNull(), this.appView), this.appView)) {
                feedback.methodReturnsObjectWithUpperBoundType(method, this.appView, dynamicReturnType);
            }
            if ((exactReturnType = dynamicTypeOptimization.computeDynamicLowerBoundType(method, code)) != null) {
                feedback.methodReturnsObjectWithLowerBoundType(method, exactReturnType);
            }
        }
    }

    private void computeInitializedClassesOnNormalExit(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        Set<DexType> initializedClasses;
        if (this.options.enableInitializedClassesAnalysis && this.appView.appInfo().hasLiveness() && (initializedClasses = InitializedClassesOnNormalExitAnalysis.computeInitializedClassesOnNormalExit(appViewWithLiveness = this.appView.withLiveness(), code)) != null && !initializedClasses.isEmpty()) {
            feedback.methodInitializesClassesOnNormalExit(method, initializedClasses);
        }
    }

    private void computeMayHaveSideEffects(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        assert (!method.accessFlags.isNative());
        if (!this.options.enableSideEffectAnalysis) {
            return;
        }
        if (this.appView.appInfo().mayHaveSideEffects.containsKey(method.method)) {
            return;
        }
        DexType context = method.method.holder;
        if (method.isClassInitializer()) {
            ClassInitializerSideEffectAnalysis.ClassInitializerSideEffect classInitializerSideEffect = ClassInitializerSideEffectAnalysis.classInitializerCanBePostponed(this.appView, code);
            if (classInitializerSideEffect.isNone()) {
                feedback.methodMayNotHaveSideEffects(method);
                feedback.classInitializerMayBePostponed(method);
            } else if (classInitializerSideEffect.canBePostponed()) {
                feedback.classInitializerMayBePostponed(method);
            } else assert (!context.isD8R8SynthesizedLambdaClassType() || this.options.debug || this.appView.appInfo().hasPinnedInstanceInitializer(context)) : "Unexpected observable side effects from lambda `" + context.toSourceString() + "`";
            return;
        }
        boolean mayHaveSideEffects = method.accessFlags.isSynchronized() ? true : (method.isInstanceInitializer() && this.hasNonTrivialFinalizeMethod(context) ? true : Streams.stream(code.instructions()).anyMatch(instruction -> instruction.instructionMayHaveSideEffects(this.appView, context)));
        if (!mayHaveSideEffects) {
            feedback.methodMayNotHaveSideEffects(method);
        }
    }

    private boolean hasNonTrivialFinalizeMethod(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz != null) {
            if (clazz.isProgramClass() && !clazz.isInterface()) {
                DexItemFactory dexItemFactory = this.appView.dexItemFactory();
                ResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(clazz, this.appView.dexItemFactory().objectMethods.finalize);
                DexEncodedMethod target = resolutionResult.getSingleTarget();
                return target != null && target.method != dexItemFactory.enumMethods.finalize && target.method != dexItemFactory.objectMethods.finalize;
            }
            return true;
        }
        return false;
    }

    private void computeReturnValueOnlyDependsOnArguments(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (!this.options.enableDeterminismAnalysis) {
            return;
        }
        boolean returnValueOnlyDependsOnArguments = DeterminismAnalysis.returnValueOnlyDependsOnArguments(this.appView.withLiveness(), code);
        if (returnValueOnlyDependsOnArguments) {
            feedback.methodReturnValueOnlyDependsOnArguments(method);
        }
    }

    private void computeNonNullParamOrThrow(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (method.getOptimizationInfo().getNonNullParamOrThrow() != null) {
            return;
        }
        List<Value> arguments = code.collectArguments();
        BitSet paramsCheckedForNull = new BitSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument = arguments.get(index);
            if (!argument.isUsed() || !MethodOptimizationInfoCollector.checksNullBeforeSideEffect(code, argument, this.appView)) continue;
            paramsCheckedForNull.set(index);
        }
        if (paramsCheckedForNull.length() > 0) {
            feedback.setNonNullParamOrThrow(method, paramsCheckedForNull);
        }
    }

    private void computeNonNullParamOnNormalExits(OptimizationFeedback feedback, IRCode code) {
        Set<BasicBlock> normalExits = Sets.newIdentityHashSet();
        normalExits.addAll(code.computeNormalExitBlocks());
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        List<Value> arguments = code.collectArguments();
        BitSet facts = new BitSet();
        Set<BasicBlock> nullCheckedBlocks = Sets.newIdentityHashSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument = arguments.get(index);
            if (!argument.getTypeLattice().isReference()) continue;
            if (argument.isThis()) {
                facts.set(index);
                continue;
            }
            nullCheckedBlocks.clear();
            for (Instruction user : argument.uniqueUsers()) {
                if (user.isAssumeNonNull()) {
                    nullCheckedBlocks.add(user.asAssumeNonNull().getBlock());
                }
                if (!user.isIf() || !user.asIf().isZeroTest() || user.asIf().getType() != If.Type.EQ && user.asIf().getType() != If.Type.NE) continue;
                nullCheckedBlocks.add(user.asIf().targetFromNonNullObject());
            }
            if (nullCheckedBlocks.isEmpty()) continue;
            boolean allExitsCovered = true;
            for (BasicBlock normalExit : normalExits) {
                if (this.isNormalExitDominated(normalExit, code, dominatorTree, nullCheckedBlocks)) continue;
                allExitsCovered = false;
                break;
            }
            if (!allExitsCovered) continue;
            facts.set(index);
        }
        if (facts.length() > 0) {
            feedback.setNonNullParamOnNormalExits(code.method, facts);
        }
    }

    private boolean isNormalExitDominated(BasicBlock normalExit, IRCode code, DominatorTree dominatorTree, Set<BasicBlock> nullCheckedBlocks) {
        for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
            if (!dominatorTree.dominatedBy(normalExit, nullCheckedBlock)) continue;
            return true;
        }
        Set<BasicBlock> visited = Sets.newIdentityHashSet();
        ArrayDeque<BasicBlock> uncoveredPaths = new ArrayDeque<BasicBlock>(normalExit.getPredecessors());
        while (!uncoveredPaths.isEmpty()) {
            BasicBlock uncoveredPath = (BasicBlock)uncoveredPaths.poll();
            if (uncoveredPath == code.entryBlock()) {
                return false;
            }
            if (!visited.add(uncoveredPath)) {
                if (!uncoveredPaths.isEmpty()) continue;
                return false;
            }
            boolean pathCovered = false;
            for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
                if (!dominatorTree.dominatedBy(uncoveredPath, nullCheckedBlock)) continue;
                pathCovered = true;
                break;
            }
            if (pathCovered) continue;
            uncoveredPaths.addAll(uncoveredPath.getPredecessors());
        }
        assert (uncoveredPaths.isEmpty());
        return true;
    }

    private static enum InstructionEffect {
        DESIRED_EFFECT,
        CONDITIONAL_EFFECT,
        OTHER_EFFECT,
        NO_EFFECT;

    }
}

