/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public abstract class MemberPoolCollection<T extends Descriptor> {
    final Equivalence<T> equivalence;
    final AppView<? extends AppInfoWithSubtyping> appView;
    final Map<DexClass, MemberPool<T>> memberPools = new ConcurrentHashMap<DexClass, MemberPool<T>>();

    MemberPoolCollection(AppView<? extends AppInfoWithSubtyping> appView, Equivalence<T> equivalence) {
        this.appView = appView;
        this.equivalence = equivalence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAll(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            TopDownClassHierarchyTraversal.forAllClasses(this.appView).visit((Iterable)this.appView.appInfo().classes(), clazz -> this.submit((DexClass)clazz, futures, executorService));
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberPool<T> buildForHierarchy(DexClass clazz, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            this.submitAll(this.getAllSuperTypesInclusive(clazz, this.memberPools::containsKey), futures, executorService);
            this.submitAll(this.getAllSubTypesExclusive(clazz, this.memberPools::containsKey), futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
        return this.get(clazz);
    }

    public boolean hasPool(DexClass clazz) {
        return this.memberPools.containsKey(clazz);
    }

    public MemberPool<T> get(DexClass clazz) {
        assert (this.hasPool(clazz));
        return this.memberPools.get(clazz);
    }

    public boolean markIfNotSeen(DexClass clazz, T reference) {
        Equivalence.Wrapper<T> key;
        MemberPool<T> memberPool = this.get(clazz);
        if (memberPool.hasSeen(key = this.equivalence.wrap(reference))) {
            return true;
        }
        memberPool.seen(key);
        return false;
    }

    private void submitAll(Iterable<? extends DexClass> classes, List<Future<?>> futures, ExecutorService executorService) {
        for (DexClass dexClass : classes) {
            this.submit(dexClass, futures, executorService);
        }
    }

    private void submit(DexClass clazz, List<Future<?>> futures, ExecutorService executorService) {
        futures.add(executorService.submit(this.computeMemberPoolForClass(clazz)));
    }

    abstract Runnable computeMemberPoolForClass(DexClass var1);

    private Set<DexClass> getAllSuperTypesInclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> superTypes = new HashSet<DexClass>();
        ArrayDeque<DexClass> worklist = new ArrayDeque<DexClass>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !superTypes.add(clazz)) continue;
            if (clazz.superType != null) {
                MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor(clazz.superType));
            }
            for (DexType interfaceType : clazz.interfaces.values) {
                MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor(interfaceType));
            }
        }
        return superTypes;
    }

    private Set<DexClass> getAllSubTypesExclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> subTypes = new HashSet<DexClass>();
        ArrayDeque worklist = new ArrayDeque();
        this.appView.appInfo().forAllImmediateExtendsSubtypes(subject.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        this.appView.appInfo().forAllImmediateImplementsSubtypes(subject.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !subTypes.add(clazz)) continue;
            this.appView.appInfo().forAllImmediateExtendsSubtypes(clazz.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
            this.appView.appInfo().forAllImmediateImplementsSubtypes(clazz.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        }
        return subTypes;
    }

    private static <T> void addNonNull(Collection<T> collection, T item) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static class MemberPool<T> {
        private Equivalence<T> equivalence;
        private MemberPool<T> superType;
        private final Set<MemberPool<T>> interfaces = new HashSet<MemberPool<T>>();
        private final Set<MemberPool<T>> subTypes = new HashSet<MemberPool<T>>();
        private final Set<Equivalence.Wrapper<T>> memberPool = new HashSet<Equivalence.Wrapper<T>>();

        MemberPool(Equivalence<T> equivalence) {
            this.equivalence = equivalence;
        }

        synchronized void linkSupertype(MemberPool<T> superType) {
            assert (this.superType == null);
            this.superType = superType;
        }

        synchronized void linkSubtype(MemberPool<T> subType) {
            boolean added = this.subTypes.add(subType);
            assert (added);
        }

        synchronized void linkInterface(MemberPool<T> itf) {
            boolean added = this.interfaces.add(itf);
            assert (added);
        }

        public void seen(T member) {
            this.seen(this.equivalence.wrap(member));
        }

        public synchronized void seen(Equivalence.Wrapper<T> member) {
            boolean added = this.memberPool.add(member);
            assert (added);
        }

        public boolean hasSeen(Equivalence.Wrapper<T> member) {
            return this.hasSeenAbove(member, true) || this.hasSeenStrictlyBelow(member);
        }

        public boolean hasSeenDirectly(Equivalence.Wrapper<T> member) {
            return this.memberPool.contains(member);
        }

        public boolean hasSeenStrictlyAbove(Equivalence.Wrapper<T> member) {
            return this.hasSeenAbove(member, false);
        }

        private boolean hasSeenAbove(Equivalence.Wrapper<T> member, boolean inclusive) {
            if (inclusive && this.hasSeenDirectly(member)) {
                return true;
            }
            return this.superType != null && super.hasSeenAbove(member, true) || this.interfaces.stream().anyMatch(itf -> itf.hasSeenAbove(member, true));
        }

        public boolean hasSeenStrictlyBelow(Equivalence.Wrapper<T> member) {
            return this.hasSeenBelow(member, false);
        }

        private boolean hasSeenBelow(Equivalence.Wrapper<T> member, boolean inclusive) {
            if (inclusive && (this.hasSeenDirectly(member) || this.interfaces.stream().anyMatch(itf -> itf.hasSeenAbove(member, true)))) {
                return true;
            }
            return this.subTypes.stream().anyMatch(subType -> subType.hasSeenBelow(member, true));
        }
    }
}

