/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class DebugLocalsChange
extends Instruction {
    private final Int2ReferenceMap<DebugLocalInfo> ending;
    private final Int2ReferenceMap<DebugLocalInfo> starting;

    public DebugLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        super(null);
        assert (!ending.isEmpty() || !starting.isEmpty());
        this.ending = ending;
        this.starting = starting;
    }

    @Override
    public int opcode() {
        return 18;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Int2ReferenceMap<DebugLocalInfo> getEnding() {
        return this.ending;
    }

    public Int2ReferenceMap<DebugLocalInfo> getStarting() {
        return this.starting;
    }

    @Override
    public boolean isDebugLocalsChange() {
        return true;
    }

    @Override
    public DebugLocalsChange asDebugLocalsChange() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addNothing(this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isDebugLocalsChange()) {
            return false;
        }
        DebugLocalsChange o = other.asDebugLocalsChange();
        return DebugLocalInfo.localsInfoMapsEqual(this.ending, o.ending) && DebugLocalInfo.localsInfoMapsEqual(this.starting, o.starting);
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable();
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("ending: ");
        StringUtils.append(builder, this.ending.int2ReferenceEntrySet());
        builder.append(", starting: ");
        StringUtils.append(builder, this.starting.int2ReferenceEntrySet());
        return builder.toString();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forDebugLocalsChange();
    }

    public boolean apply(Int2ReferenceMap<DebugLocalInfo> locals) {
        boolean changed = false;
        for (Int2ReferenceMap.Entry entry : this.getEnding().int2ReferenceEntrySet()) {
            assert (locals.get(entry.getIntKey()) == entry.getValue());
            if (locals.remove(entry.getIntKey()) == null) continue;
            changed = true;
        }
        for (Int2ReferenceMap.Entry entry : this.getStarting().int2ReferenceEntrySet()) {
            assert (!locals.containsKey(entry.getIntKey()));
            DebugLocalInfo old = locals.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            changed |= old == null || old != entry.getValue();
        }
        return changed;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }

    @Override
    public boolean isAllowedAfterThrowingInstruction() {
        return true;
    }
}

