/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfCheckCast;
import shadow.bundletool.com.android.tools.r8.code.MoveObject;
import shadow.bundletool.com.android.tools.r8.code.MoveObjectFrom16;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class CheckCast
extends Instruction {
    private final DexType type;

    public CheckCast(Value dest, Value value, DexType type) {
        super(dest, value);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 10;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public DexType getType() {
        return this.type;
    }

    public Value object() {
        return this.inValues().get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int inRegister = builder.allocatedRegister((Value)this.inValues.get(0), this.getNumber());
        if (this.outValue == null) {
            builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.CheckCast(inRegister, this.type));
        } else {
            int outRegister = builder.allocatedRegister(this.outValue, this.getNumber());
            if (inRegister == outRegister) {
                builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.CheckCast(outRegister, this.type));
            } else {
                shadow.bundletool.com.android.tools.r8.code.CheckCast cast = new shadow.bundletool.com.android.tools.r8.code.CheckCast(outRegister, this.type);
                if (outRegister <= 15 && inRegister <= 15) {
                    builder.add((Instruction)this, new MoveObject(outRegister, inRegister), cast);
                } else {
                    builder.add((Instruction)this, new MoveObjectFrom16(outRegister, inRegister), cast);
                }
            }
        }
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isCheckCast() && other.asCheckCast().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isCheckCast() {
        return true;
    }

    @Override
    public CheckCast asCheckCast() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forCheckCast(this.type, invocationContext);
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.type, this.object().getTypeLattice().nullability(), appView);
    }

    @Override
    public boolean verifyTypes(AppView<?> appView) {
        assert (super.verifyTypes(appView));
        TypeLatticeElement inType = this.object().getTypeLattice();
        assert (inType.isPreciseType());
        TypeLatticeElement outType = this.outValue().getTypeLattice();
        TypeLatticeElement castType = TypeLatticeElement.fromDexType(this.getType(), inType.nullability(), appView);
        if (inType.lessThanOrEqual(castType, appView)) {
            assert (inType.lessThanOrEqual(outType, appView));
        } else {
            assert (outType.equalUpToNullability(castType));
            assert (inType.nullability().lessThanOrEqual(outType.nullability()));
            assert (!inType.isNullType());
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfCheckCast(this.type));
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

