/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph.analysis;

import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.analysis.EnqueuerAnalysis;

public class InitializedClassesInInstanceMethodsAnalysis
extends EnqueuerAnalysis {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final Map<DexType, DexType> mapping = new IdentityHashMap<DexType, DexType>();

    public InitializedClassesInInstanceMethodsAnalysis(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
    }

    @Override
    public void processNewlyInstantiatedClass(DexProgramClass clazz, DexEncodedMethod context) {
        DexType key = clazz.type;
        DexType objectType = this.appView.dexItemFactory().objectType;
        if (context == null) {
            this.mapping.put(key, objectType);
            return;
        }
        AppInfoWithSubtyping appInfo = this.appView.appInfo();
        DexType guaranteedToBeInitialized = context.method.holder;
        DexType existingGuaranteedToBeInitialized = this.mapping.getOrDefault(key, guaranteedToBeInitialized);
        this.mapping.put(key, appInfo.computeLeastUpperBoundOfClasses(guaranteedToBeInitialized, existingGuaranteedToBeInitialized));
    }

    @Override
    public void done() {
        this.appView.setInitializedClassesInInstanceMethods(new InitializedClassesInInstanceMethods(this.appView, this.mapping));
    }

    public static class InitializedClassesInInstanceMethods {
        private final AppView<? extends AppInfoWithSubtyping> appView;
        private final Map<DexType, DexType> mapping;

        private InitializedClassesInInstanceMethods(AppView<? extends AppInfoWithSubtyping> appView, Map<DexType, DexType> mapping) {
            this.appView = appView;
            this.mapping = mapping;
        }

        public boolean isClassDefinitelyLoadedInInstanceMethodsOn(DexType subject, DexType context) {
            AppInfoWithSubtyping appInfo = this.appView.appInfo();
            if (appInfo.hasLiveness() && appInfo.withLiveness().isPinned(subject)) {
                return false;
            }
            DexType guaranteedToBeInitializedInContext = this.mapping.getOrDefault(context, this.appView.dexItemFactory().objectType);
            if (!appInfo.isSubtype(guaranteedToBeInitializedInContext, subject)) {
                return false;
            }
            DexClass clazz = this.appView.definitionFor(subject);
            return clazz != null && !clazz.isInterface();
        }
    }
}

