/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfo;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;

public class FieldAccessInfoImpl
implements FieldAccessInfo {
    public static final FieldAccessInfoImpl MISSING_FIELD_ACCESS_INFO = new FieldAccessInfoImpl(null);
    private DexField field;
    private Map<DexField, Set<DexEncodedMethod>> readsWithContexts;
    private Map<DexField, Set<DexEncodedMethod>> writesWithContexts;

    public FieldAccessInfoImpl(DexField field) {
        this.field = field;
    }

    @Override
    public FieldAccessInfoImpl asMutable() {
        return this;
    }

    @Override
    public DexField getField() {
        return this.field;
    }

    @Override
    public DexEncodedMethod getUniqueReadContext() {
        Set<DexEncodedMethod> contexts;
        if (this.readsWithContexts != null && this.readsWithContexts.size() == 1 && (contexts = this.readsWithContexts.values().iterator().next()).size() == 1) {
            return contexts.iterator().next();
        }
        return null;
    }

    @Override
    public void forEachIndirectAccess(Consumer<DexField> consumer) {
        Set visited = Sets.newIdentityHashSet();
        FieldAccessInfoImpl.forEachAccessInMap(this.readsWithContexts, access -> access != this.field && visited.add(access), consumer);
        FieldAccessInfoImpl.forEachAccessInMap(this.writesWithContexts, access -> access != this.field && visited.add(access), consumer);
    }

    private static void forEachAccessInMap(Map<DexField, Set<DexEncodedMethod>> accessesWithContexts, Predicate<DexField> predicate, Consumer<DexField> consumer) {
        if (accessesWithContexts != null) {
            accessesWithContexts.forEach((access, contexts) -> {
                if (predicate.test((DexField)access)) {
                    consumer.accept((DexField)access);
                }
            });
        }
    }

    @Override
    public void forEachIndirectAccessWithContexts(BiConsumer<DexField, Set<DexEncodedMethod>> consumer) {
        IdentityHashMap<DexField, Set<DexEncodedMethod>> indirectAccessesWithContexts = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
        this.extendAccessesWithContexts(indirectAccessesWithContexts, access -> access != this.field, this.readsWithContexts);
        this.extendAccessesWithContexts(indirectAccessesWithContexts, access -> access != this.field, this.writesWithContexts);
        indirectAccessesWithContexts.forEach(consumer);
    }

    private void extendAccessesWithContexts(Map<DexField, Set<DexEncodedMethod>> accessesWithContexts, Predicate<DexField> predicate, Map<DexField, Set<DexEncodedMethod>> extension) {
        if (extension != null) {
            extension.forEach((access, contexts) -> {
                if (predicate.test((DexField)access)) {
                    accessesWithContexts.computeIfAbsent((DexField)access, ignore -> Sets.newIdentityHashSet()).addAll(contexts);
                }
            });
        }
    }

    @Override
    public void forEachReadContext(Consumer<DexMethod> consumer) {
        Set<DexMethod> visited = Sets.newIdentityHashSet();
        if (this.readsWithContexts != null) {
            for (Set<DexEncodedMethod> encodedReadContexts : this.readsWithContexts.values()) {
                for (DexEncodedMethod encodedReadContext : encodedReadContexts) {
                    DexMethod readContext = encodedReadContext.method;
                    if (!visited.add(readContext)) continue;
                    consumer.accept(readContext);
                }
            }
        }
    }

    @Override
    public boolean isRead() {
        return this.readsWithContexts != null && !this.readsWithContexts.isEmpty();
    }

    @Override
    public boolean isReadOnlyIn(DexEncodedMethod method) {
        assert (this.isRead());
        assert (method != null);
        DexEncodedMethod uniqueReadContext = this.getUniqueReadContext();
        return uniqueReadContext != null && uniqueReadContext == method;
    }

    @Override
    public boolean isWritten() {
        return this.writesWithContexts != null && !this.writesWithContexts.isEmpty();
    }

    @Override
    public boolean isWrittenInMethodSatisfying(Predicate<DexEncodedMethod> predicate) {
        if (this.writesWithContexts != null) {
            for (Set<DexEncodedMethod> encodedWriteContexts : this.writesWithContexts.values()) {
                for (DexEncodedMethod encodedWriteContext : encodedWriteContexts) {
                    if (!predicate.test(encodedWriteContext)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isWrittenOutside(DexEncodedMethod method) {
        if (this.writesWithContexts != null) {
            for (Set<DexEncodedMethod> encodedWriteContexts : this.writesWithContexts.values()) {
                for (DexEncodedMethod encodedWriteContext : encodedWriteContexts) {
                    if (encodedWriteContext == method) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean recordRead(DexField access, DexEncodedMethod context) {
        if (this.readsWithContexts == null) {
            this.readsWithContexts = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
        }
        return this.readsWithContexts.computeIfAbsent(access, ignore -> Sets.newIdentityHashSet()).add(context);
    }

    public boolean recordWrite(DexField access, DexEncodedMethod context) {
        if (this.writesWithContexts == null) {
            this.writesWithContexts = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
        }
        return this.writesWithContexts.computeIfAbsent(access, ignore -> Sets.newIdentityHashSet()).add(context);
    }

    public void clearReads() {
        this.readsWithContexts = null;
    }

    public void clearWrites() {
        this.writesWithContexts = null;
    }

    public FieldAccessInfoImpl rewrittenWithLens(DexDefinitionSupplier definitions, GraphLense lens) {
        FieldAccessInfoImpl rewritten = new FieldAccessInfoImpl(lens.lookupField(this.field));
        if (this.readsWithContexts != null) {
            rewritten.readsWithContexts = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
            this.readsWithContexts.forEach((access, contexts) -> {
                Set newContexts = rewritten.readsWithContexts.computeIfAbsent(lens.lookupField((DexField)access), ignore -> Sets.newIdentityHashSet());
                for (DexEncodedMethod context : contexts) {
                    newContexts.add(lens.mapDexEncodedMethod(context, definitions));
                }
            });
        }
        if (this.writesWithContexts != null) {
            rewritten.writesWithContexts = new IdentityHashMap<DexField, Set<DexEncodedMethod>>();
            this.writesWithContexts.forEach((access, contexts) -> {
                Set newContexts = rewritten.writesWithContexts.computeIfAbsent(lens.lookupField((DexField)access), ignore -> Sets.newIdentityHashSet());
                for (DexEncodedMethod context : contexts) {
                    newContexts.add(lens.mapDexEncodedMethod(context, definitions));
                }
            });
        }
        return rewritten;
    }
}

