/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.experimental.graphinfo;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphNode;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;
import shadow.bundletool.com.android.tools.r8.position.TextRange;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleBase;

@Keep
public final class KeepRuleGraphNode
extends GraphNode {
    private final Origin origin;
    private final Position position;
    private final String content;
    private final Set<GraphNode> preconditions;

    public KeepRuleGraphNode(ProguardKeepRule rule) {
        this(rule, Collections.emptySet());
    }

    public KeepRuleGraphNode(ProguardKeepRuleBase rule, Set<GraphNode> preconditions) {
        super(false);
        assert (rule != null);
        assert (preconditions != null);
        this.origin = rule.getOrigin();
        this.position = rule.getPosition();
        this.content = rule.getSource();
        this.preconditions = preconditions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeepRuleGraphNode)) {
            return false;
        }
        KeepRuleGraphNode other = (KeepRuleGraphNode)o;
        return this.origin.equals(other.getOrigin()) && this.position.equals(other.getPosition()) && Objects.equals(this.content, other.getContent()) && this.preconditions.equals(other.getPreconditions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.origin, this.position, this.content, this.preconditions);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getContent() {
        return this.content;
    }

    public Set<GraphNode> getPreconditions() {
        return this.preconditions;
    }

    @Override
    public String toString() {
        return (this.getOrigin() == Origin.unknown() ? this.getContent() : this.getOrigin()) + ":" + KeepRuleGraphNode.shortPositionInfo(this.getPosition());
    }

    private static String shortPositionInfo(Position position) {
        if (position instanceof TextRange) {
            TextPosition start = ((TextRange)position).getStart();
            return start.getLine() + ":" + start.getColumn();
        }
        if (position instanceof TextPosition) {
            TextPosition start = (TextPosition)position;
            return start.getLine() + ":" + start.getColumn();
        }
        return position.getDescription();
    }
}

