/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.InstructionFactory;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.dex.ClassesChecksum;
import shadow.bundletool.com.android.tools.r8.dex.DexReader;
import shadow.bundletool.com.android.tools.r8.dex.DexSection;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.CachedHashValueDexItem;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedArray;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMemberAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.OffsetToObjectMapping;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2LongMap;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.EncodedValueUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class DexParser {
    private final int NO_INDEX = -1;
    private final Origin origin;
    private DexReader dexReader;
    private final DexSection[] dexSections;
    private int[] stringIDs;
    private final ClassKind classKind;
    private final InternalOptions options;
    private Object2LongMap<String> checksums;
    private OffsetToObjectMapping indexedItems = new OffsetToObjectMapping();
    private Int2ReferenceMap<DexCode> codes = new Int2ReferenceOpenHashMap<DexCode>();
    private Int2ReferenceMap<Object> offsetMap = new Int2ReferenceOpenHashMap<Object>();
    private final DexItemFactory dexItemFactory;

    public static DexSection[] parseMapFrom(Path file) throws IOException {
        return DexParser.parseMapFrom(Files.newInputStream(file, new OpenOption[0]), new PathOrigin(file));
    }

    public static DexSection[] parseMapFrom(InputStream stream, Origin origin) throws IOException {
        return DexParser.parseMapFrom(new DexReader(origin, ByteStreams.toByteArray(stream)));
    }

    private static DexSection[] parseMapFrom(DexReader dexReader) {
        DexParser dexParser = new DexParser(dexReader, ClassKind.PROGRAM, new InternalOptions());
        return dexParser.dexSections;
    }

    public void close() {
        this.indexedItems = null;
        this.codes = null;
        this.offsetMap = null;
        this.dexReader = null;
        this.stringIDs = null;
    }

    public DexParser(DexReader dexReader, ClassKind classKind, InternalOptions options) {
        assert (dexReader.getOrigin() != null);
        this.origin = dexReader.getOrigin();
        this.dexReader = dexReader;
        this.dexItemFactory = options.itemFactory;
        dexReader.setByteOrder();
        this.dexSections = this.parseMap();
        this.parseStringIDs();
        this.classKind = classKind;
        this.options = options;
    }

    private void ensureCodesInited(int offset) {
        if (offset == 0) {
            return;
        }
        if (this.codes == null) {
            this.codes = new Int2ReferenceOpenHashMap<DexCode>();
        }
        if (this.classKind == ClassKind.LIBRARY) {
            return;
        }
        DexSection dexSection = this.lookupSection(8193);
        if (dexSection.length == 0) {
            return;
        }
        if (!this.codes.containsKey(offset)) {
            int currentPos = this.dexReader.position();
            this.dexReader.position(offset);
            this.dexReader.align(4);
            DexCode code = this.parseCodeItem();
            this.codes.put(offset, code);
            this.dexReader.position(currentPos);
        }
    }

    private DexTypeList parseTypeList() {
        DexType[] result = new DexType[this.dexReader.getUint()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.indexedItems.getType(this.dexReader.getUshort());
        }
        return new DexTypeList(result);
    }

    private DexTypeList typeListAt(int offset) {
        if (offset == 0) {
            return DexTypeList.empty();
        }
        return (DexTypeList)this.cacheAt(offset, this::parseTypeList);
    }

    private DexValue parseEncodedValue() {
        int header = this.dexReader.get() & 0xFF;
        int valueArg = header >> 5;
        int valueType = header & 0x1F;
        switch (valueType) {
            case 0: {
                assert (valueArg == 0);
                byte value = (byte)EncodedValueUtils.parseSigned(this.dexReader, 1);
                return DexValue.DexValueByte.create(value);
            }
            case 2: {
                int size = valueArg + 1;
                short value = (short)EncodedValueUtils.parseSigned(this.dexReader, size);
                return DexValue.DexValueShort.create(value);
            }
            case 3: {
                int size = valueArg + 1;
                char value = (char)EncodedValueUtils.parseUnsigned(this.dexReader, size);
                return DexValue.DexValueChar.create(value);
            }
            case 4: {
                int size = valueArg + 1;
                int value = (int)EncodedValueUtils.parseSigned(this.dexReader, size);
                return DexValue.DexValueInt.create(value);
            }
            case 6: {
                int size = valueArg + 1;
                long value = EncodedValueUtils.parseSigned(this.dexReader, size);
                return DexValue.DexValueLong.create(value);
            }
            case 16: {
                int size = valueArg + 1;
                return DexValue.DexValueFloat.create(EncodedValueUtils.parseFloat(this.dexReader, size));
            }
            case 17: {
                int size = valueArg + 1;
                return DexValue.DexValueDouble.create(EncodedValueUtils.parseDouble(this.dexReader, size));
            }
            case 23: {
                int size = valueArg + 1;
                int index = (int)EncodedValueUtils.parseUnsigned(this.dexReader, size);
                DexString value = this.indexedItems.getString(index);
                return new DexValue.DexValueString(value);
            }
            case 24: {
                int size = valueArg + 1;
                DexType value = this.indexedItems.getType((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                return new DexValue.DexValueType(value);
            }
            case 25: {
                int size = valueArg + 1;
                DexField value = this.indexedItems.getField((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                this.checkName(value.name);
                return new DexValue.DexValueField(value);
            }
            case 26: {
                int size = valueArg + 1;
                DexMethod value = this.indexedItems.getMethod((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                this.checkName(value.name);
                return new DexValue.DexValueMethod(value);
            }
            case 27: {
                int size = valueArg + 1;
                DexField value = this.indexedItems.getField((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                return new DexValue.DexValueEnum(value);
            }
            case 28: {
                assert (valueArg == 0);
                return new DexValue.DexValueArray(this.parseEncodedArrayValues());
            }
            case 29: {
                assert (valueArg == 0);
                return new DexValue.DexValueAnnotation(this.parseEncodedAnnotation());
            }
            case 30: {
                assert (valueArg == 0);
                return DexValue.DexValueNull.NULL;
            }
            case 31: {
                return DexValue.DexValueBoolean.create(valueArg != 0);
            }
            case 21: {
                int size = valueArg + 1;
                DexProto value = this.indexedItems.getProto((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                return new DexValue.DexValueMethodType(value);
            }
            case 22: {
                int size = valueArg + 1;
                DexMethodHandle value = this.indexedItems.getMethodHandle((int)EncodedValueUtils.parseUnsigned(this.dexReader, size));
                return new DexValue.DexValueMethodHandle(value);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private void checkName(DexString name) {
        if (!this.options.itemFactory.getSkipNameValidationForTesting() && !name.isValidSimpleName(this.options.minApiLevel)) {
            throw new CompilationError("Space characters in SimpleName '" + name.toASCIIString() + "' are not allowed prior to DEX version 040");
        }
    }

    private DexEncodedAnnotation parseEncodedAnnotation() {
        int typeIdx = this.dexReader.getUleb128();
        int size = this.dexReader.getUleb128();
        DexAnnotationElement[] elements = new DexAnnotationElement[size];
        for (int i = 0; i < size; ++i) {
            int nameIdx = this.dexReader.getUleb128();
            DexValue value = this.parseEncodedValue();
            elements[i] = new DexAnnotationElement(this.indexedItems.getString(nameIdx), value);
        }
        return new DexEncodedAnnotation(this.indexedItems.getType(typeIdx), elements);
    }

    private DexValue[] parseEncodedArrayValues() {
        int size = this.dexReader.getUleb128();
        DexValue[] values2 = new DexValue[size];
        for (int i = 0; i < size; ++i) {
            values2[i] = this.parseEncodedValue();
        }
        return values2;
    }

    private DexEncodedArray parseEncodedArray() {
        return new DexEncodedArray(this.parseEncodedArrayValues());
    }

    private DexEncodedArray encodedArrayAt(int offset) {
        return (DexEncodedArray)this.cacheAt(offset, this::parseEncodedArray);
    }

    private DexMemberAnnotation.DexFieldAnnotation[] parseFieldAnnotations(int size) {
        if (size == 0) {
            return null;
        }
        int[] fieldIndices = new int[size];
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            fieldIndices[i] = this.dexReader.getUint();
            annotationOffsets[i] = this.dexReader.getUint();
        }
        int saved = this.dexReader.position();
        DexMemberAnnotation.DexFieldAnnotation[] result = new DexMemberAnnotation.DexFieldAnnotation[size];
        for (int i = 0; i < size; ++i) {
            DexField field = this.indexedItems.getField(fieldIndices[i]);
            DexAnnotationSet annotation = this.annotationSetAt(annotationOffsets[i]);
            result[i] = new DexMemberAnnotation.DexFieldAnnotation(field, annotation);
        }
        this.dexReader.position(saved);
        return result;
    }

    private DexMemberAnnotation.DexMethodAnnotation[] parseMethodAnnotations(int size) {
        if (size == 0) {
            return null;
        }
        int[] methodIndices = new int[size];
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            methodIndices[i] = this.dexReader.getUint();
            annotationOffsets[i] = this.dexReader.getUint();
        }
        int saved = this.dexReader.position();
        DexMemberAnnotation.DexMethodAnnotation[] result = new DexMemberAnnotation.DexMethodAnnotation[size];
        for (int i = 0; i < size; ++i) {
            DexMethod method = this.indexedItems.getMethod(methodIndices[i]);
            DexAnnotationSet annotation = this.annotationSetAt(annotationOffsets[i]);
            result[i] = new DexMemberAnnotation.DexMethodAnnotation(method, annotation);
        }
        this.dexReader.position(saved);
        return result;
    }

    private ParameterAnnotationsList annotationSetRefListAt(int offset) {
        return (ParameterAnnotationsList)this.cacheAt(offset, this::parseAnnotationSetRefList);
    }

    private ParameterAnnotationsList parseAnnotationSetRefList() {
        int size = this.dexReader.getUint();
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            annotationOffsets[i] = this.dexReader.getUint();
        }
        DexAnnotationSet[] values2 = new DexAnnotationSet[size];
        for (int i = 0; i < size; ++i) {
            values2[i] = this.annotationSetAt(annotationOffsets[i]);
        }
        return new ParameterAnnotationsList(values2);
    }

    private DexMemberAnnotation.DexParameterAnnotation[] parseParameterAnnotations(int size) {
        if (size == 0) {
            return null;
        }
        int[] methodIndices = new int[size];
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            methodIndices[i] = this.dexReader.getUint();
            annotationOffsets[i] = this.dexReader.getUint();
        }
        int saved = this.dexReader.position();
        DexMemberAnnotation.DexParameterAnnotation[] result = new DexMemberAnnotation.DexParameterAnnotation[size];
        for (int i = 0; i < size; ++i) {
            DexMethod method = this.indexedItems.getMethod(methodIndices[i]);
            result[i] = new DexMemberAnnotation.DexParameterAnnotation(method, this.annotationSetRefListAt(annotationOffsets[i]).withParameterCount(method.proto.parameters.size()));
        }
        this.dexReader.position(saved);
        return result;
    }

    private <T> Object cacheAt(int offset, Supplier<T> function, Supplier<T> defaultValue) {
        if (offset == 0) {
            return defaultValue.get();
        }
        return this.cacheAt(offset, function);
    }

    private <T> Object cacheAt(int offset, Supplier<T> function) {
        if (offset == 0) {
            return null;
        }
        Object result = this.offsetMap.get(offset);
        if (result != null) {
            return result;
        }
        this.dexReader.position(offset);
        result = function.get();
        this.offsetMap.put(offset, result);
        assert (this.offsetMap.get(offset) == result);
        return result;
    }

    private DexAnnotation parseAnnotation() {
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Reading Annotation @ 0x%08x.", this.dexReader.position());
        }
        byte visibility = this.dexReader.get();
        return new DexAnnotation(visibility, this.parseEncodedAnnotation());
    }

    private DexAnnotation annotationAt(int offset) {
        return (DexAnnotation)this.cacheAt(offset, this::parseAnnotation);
    }

    private DexAnnotationSet parseAnnotationSet() {
        DexType dupType;
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Reading AnnotationSet @ 0x%08x.", this.dexReader.position());
        }
        int size = this.dexReader.getUint();
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            annotationOffsets[i] = this.dexReader.getUint();
        }
        DexAnnotation[] result = new DexAnnotation[size];
        int actualSize = 0;
        for (int i = 0; i < size; ++i) {
            DexAnnotation dexAnnotation = this.annotationAt(annotationOffsets[i]);
            if (!this.retainAnnotation(dexAnnotation)) continue;
            result[actualSize++] = dexAnnotation;
        }
        if (actualSize < size) {
            DexAnnotation[] temp = new DexAnnotation[actualSize];
            System.arraycopy(result, 0, temp, 0, actualSize);
            result = temp;
        }
        if ((dupType = DexAnnotationSet.findDuplicateEntryType(result)) != null) {
            throw new CompilationError("Multiple annotations of type `" + dupType.toSourceString() + "`");
        }
        return new DexAnnotationSet(result);
    }

    private boolean retainAnnotation(DexAnnotation annotation) {
        return annotation.visibility != 0 || DexAnnotation.retainCompileTimeAnnotation(annotation.annotation.type, this.options);
    }

    private DexAnnotationSet annotationSetAt(int offset) {
        return (DexAnnotationSet)this.cacheAt(offset, this::parseAnnotationSet, DexAnnotationSet::empty);
    }

    private AnnotationsDirectory annotationsDirectoryAt(int offset) {
        return (AnnotationsDirectory)this.cacheAt(offset, this::parseAnnotationsDirectory, AnnotationsDirectory::empty);
    }

    private AnnotationsDirectory parseAnnotationsDirectory() {
        int classAnnotationsOff = this.dexReader.getUint();
        int fieldsSize = this.dexReader.getUint();
        int methodsSize = this.dexReader.getUint();
        int parametersSize = this.dexReader.getUint();
        DexMemberAnnotation.DexFieldAnnotation[] fields = this.parseFieldAnnotations(fieldsSize);
        DexMemberAnnotation.DexMethodAnnotation[] methods = this.parseMethodAnnotations(methodsSize);
        DexMemberAnnotation.DexParameterAnnotation[] parameters = this.parseParameterAnnotations(parametersSize);
        return new AnnotationsDirectory(this.annotationSetAt(classAnnotationsOff), fields, methods, parameters);
    }

    private DexDebugInfo debugInfoAt(int offset) {
        return (DexDebugInfo)this.cacheAt(offset, this::parseDebugInfo);
    }

    private DexDebugInfo parseDebugInfo() {
        int start = this.dexReader.getUleb128();
        int parametersSize = this.dexReader.getUleb128();
        DexString[] parameters = new DexString[parametersSize];
        for (int i = 0; i < parametersSize; ++i) {
            int index = this.dexReader.getUleb128p1();
            if (index == -1) continue;
            parameters[i] = this.indexedItems.getString(index);
        }
        ArrayList<DexDebugEvent> events = new ArrayList<DexDebugEvent>();
        int head = this.dexReader.getUbyte();
        while (head != 0) {
            switch (head) {
                case 1: {
                    events.add(this.dexItemFactory.createAdvancePC(this.dexReader.getUleb128()));
                    break;
                }
                case 2: {
                    events.add(this.dexItemFactory.createAdvanceLine(this.dexReader.getSleb128()));
                    break;
                }
                case 3: {
                    int registerNum = this.dexReader.getUleb128();
                    int nameIdx = this.dexReader.getUleb128p1();
                    int typeIdx = this.dexReader.getUleb128p1();
                    events.add(new DexDebugEvent.StartLocal(registerNum, nameIdx == -1 ? null : this.indexedItems.getString(nameIdx), typeIdx == -1 ? null : this.indexedItems.getType(typeIdx), null));
                    break;
                }
                case 4: {
                    int registerNum = this.dexReader.getUleb128();
                    int nameIdx = this.dexReader.getUleb128p1();
                    int typeIdx = this.dexReader.getUleb128p1();
                    int sigIdx = this.dexReader.getUleb128p1();
                    events.add(new DexDebugEvent.StartLocal(registerNum, nameIdx == -1 ? null : this.indexedItems.getString(nameIdx), typeIdx == -1 ? null : this.indexedItems.getType(typeIdx), sigIdx == -1 ? null : this.indexedItems.getString(sigIdx)));
                    break;
                }
                case 5: {
                    events.add(this.dexItemFactory.createEndLocal(this.dexReader.getUleb128()));
                    break;
                }
                case 6: {
                    events.add(this.dexItemFactory.createRestartLocal(this.dexReader.getUleb128()));
                    break;
                }
                case 7: {
                    events.add(this.dexItemFactory.createSetPrologueEnd());
                    break;
                }
                case 8: {
                    events.add(this.dexItemFactory.createSetEpilogueBegin());
                    break;
                }
                case 9: {
                    int nameIdx = this.dexReader.getUleb128p1();
                    DexString sourceFile = nameIdx == -1 ? null : this.indexedItems.getString(nameIdx);
                    events.add(this.dexItemFactory.createSetFile(sourceFile));
                    break;
                }
                default: {
                    assert (head >= 10 && head <= 255);
                    events.add(this.dexItemFactory.createDefault(head));
                }
            }
            head = this.dexReader.getUbyte();
        }
        return new DexDebugInfo(start, parameters, events.toArray(DexDebugEvent.EMPTY_ARRAY));
    }

    private DexEncodedField[] readFields(int size, DexMemberAnnotation.DexFieldAnnotation[] annotations, DexValue[] staticValues) {
        DexEncodedField[] fields = new DexEncodedField[size];
        int fieldIndex = 0;
        MemberAnnotationIterator annotationIterator = new MemberAnnotationIterator(annotations, DexAnnotationSet::empty);
        for (int i = 0; i < size; ++i) {
            DexField field = this.indexedItems.getField(fieldIndex += this.dexReader.getUleb128());
            FieldAccessFlags accessFlags = FieldAccessFlags.fromDexAccessFlags(this.dexReader.getUleb128());
            DexAnnotationSet fieldAnnotations = (DexAnnotationSet)annotationIterator.getNextFor(field);
            DexValue staticValue = null;
            if (accessFlags.isStatic() && staticValues != null && i < staticValues.length) {
                staticValue = staticValues[i];
            }
            fields[i] = new DexEncodedField(field, accessFlags, fieldAnnotations, staticValue);
        }
        return fields;
    }

    private DexEncodedMethod[] readMethods(int size, DexMemberAnnotation.DexMethodAnnotation[] annotations, DexMemberAnnotation.DexParameterAnnotation[] parameters, boolean skipCodes, boolean ensureNonAbstract) {
        DexEncodedMethod[] methods = new DexEncodedMethod[size];
        int methodIndex = 0;
        MemberAnnotationIterator annotationIterator = new MemberAnnotationIterator(annotations, DexAnnotationSet::empty);
        MemberAnnotationIterator parameterAnnotationsIterator = new MemberAnnotationIterator(parameters, ParameterAnnotationsList::empty);
        for (int i = 0; i < size; ++i) {
            methodIndex += this.dexReader.getUleb128();
            MethodAccessFlags accessFlags = MethodAccessFlags.fromDexAccessFlags(this.dexReader.getUleb128());
            int codeOff = this.dexReader.getUleb128();
            DexCode code = null;
            if (!skipCodes) {
                this.ensureCodesInited(codeOff);
                assert (codeOff == 0 || this.codes.get(codeOff) != null);
                code = (DexCode)this.codes.get(codeOff);
            }
            DexMethod method = this.indexedItems.getMethod(methodIndex);
            DexEncodedMethod encodedMethod = new DexEncodedMethod(method, accessFlags, (DexAnnotationSet)annotationIterator.getNextFor(method), (ParameterAnnotationsList)parameterAnnotationsIterator.getNextFor(method), code);
            if (accessFlags.isAbstract() && ensureNonAbstract) {
                accessFlags.unsetAbstract();
                encodedMethod = this.options.isGeneratingClassFiles() ? encodedMethod.toEmptyThrowingMethodCf() : encodedMethod.toEmptyThrowingMethodDex();
            }
            methods[i] = encodedMethod;
        }
        return methods;
    }

    void addClassDefsTo(Consumer<DexClass> classCollection) {
        int i;
        DexSection dexSection = this.lookupSection(6);
        int length = dexSection.length;
        this.indexedItems.initializeClasses(length);
        if (length == 0) {
            return;
        }
        this.dexReader.position(dexSection.offset);
        int[] classIndices = new int[length];
        int[] accessFlags = new int[length];
        int[] superclassIndices = new int[length];
        int[] interfacesOffsets = new int[length];
        int[] sourceFileIndices = new int[length];
        int[] annotationsOffsets = new int[length];
        int[] classDataOffsets = new int[length];
        int[] staticValuesOffsets = new int[length];
        for (i = 0; i < length; ++i) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Reading ClassDef @ 0x%08x.", this.dexReader.position());
            }
            classIndices[i] = this.dexReader.getUint();
            accessFlags[i] = this.dexReader.getUint();
            superclassIndices[i] = this.dexReader.getInt();
            interfacesOffsets[i] = this.dexReader.getUint();
            sourceFileIndices[i] = this.dexReader.getInt();
            annotationsOffsets[i] = this.dexReader.getUint();
            classDataOffsets[i] = this.dexReader.getUint();
            staticValuesOffsets[i] = this.dexReader.getUint();
        }
        for (i = 0; i < length; ++i) {
            String desc;
            int superclassIdx = superclassIndices[i];
            DexType superclass = superclassIdx == -1 ? null : this.indexedItems.getType(superclassIdx);
            int srcIdx = sourceFileIndices[i];
            DexString source = srcIdx == -1 ? null : this.indexedItems.getString(srcIdx);
            DexType type = this.indexedItems.getType(classIndices[i]);
            ClassAccessFlags flags = ClassAccessFlags.fromDexAccessFlags(accessFlags[i]);
            if (!flags.areValid(50, false)) {
                throw new CompilationError("Class " + type.toSourceString() + " has illegal access flags. Found: " + flags, this.origin);
            }
            DexEncodedField[] staticFields = DexEncodedField.EMPTY_ARRAY;
            DexEncodedField[] instanceFields = DexEncodedField.EMPTY_ARRAY;
            DexEncodedMethod[] directMethods = DexEncodedMethod.EMPTY_ARRAY;
            DexEncodedMethod[] virtualMethods = DexEncodedMethod.EMPTY_ARRAY;
            AnnotationsDirectory annotationsDirectory = this.annotationsDirectoryAt(annotationsOffsets[i]);
            Long checksum = null;
            if (this.checksums != null && !this.checksums.isEmpty() && !this.options.dexClassChecksumFilter.test(desc = type.toDescriptorString(), checksum = (Long)this.checksums.getOrDefault(desc, null))) continue;
            if (classDataOffsets[i] != 0) {
                DexEncodedArray staticValues = this.encodedArrayAt(staticValuesOffsets[i]);
                this.dexReader.position(classDataOffsets[i]);
                int staticFieldsSize = this.dexReader.getUleb128();
                int instanceFieldsSize = this.dexReader.getUleb128();
                int directMethodsSize = this.dexReader.getUleb128();
                int virtualMethodsSize = this.dexReader.getUleb128();
                staticFields = this.readFields(staticFieldsSize, annotationsDirectory.fields, staticValues != null ? staticValues.values : null);
                instanceFields = this.readFields(instanceFieldsSize, annotationsDirectory.fields, null);
                directMethods = this.readMethods(directMethodsSize, annotationsDirectory.methods, annotationsDirectory.parameters, this.classKind != ClassKind.PROGRAM, this.options.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() && !flags.isAbstract());
                virtualMethods = this.readMethods(virtualMethodsSize, annotationsDirectory.methods, annotationsDirectory.parameters, this.classKind != ClassKind.PROGRAM, this.options.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() && !flags.isAbstract());
            }
            AttributesAndAnnotations attrs = new AttributesAndAnnotations(type, annotationsDirectory.clazz, this.options.itemFactory);
            Long finalChecksum = checksum;
            DexProgramClass.ChecksumSupplier checksumSupplier = finalChecksum == null ? DexProgramClass::invalidChecksumRequest : c -> finalChecksum;
            DexClass clazz = this.classKind.create(type, ProgramResource.Kind.DEX, this.origin, flags, superclass, this.typeListAt(interfacesOffsets[i]), source, null, Collections.emptyList(), attrs.getEnclosingMethodAttribute(), attrs.getInnerClasses(), attrs.getAnnotations(), staticFields, instanceFields, directMethods, virtualMethods, this.dexItemFactory.getSkipNameValidationForTesting(), checksumSupplier);
            classCollection.accept(clazz);
        }
    }

    private void parseStringIDs() {
        DexSection dexSection = this.lookupSection(1);
        this.stringIDs = new int[dexSection.length];
        if (dexSection.length == 0) {
            return;
        }
        this.dexReader.position(dexSection.offset);
        for (int i = 0; i < dexSection.length; ++i) {
            this.stringIDs[i] = this.dexReader.getUint();
        }
    }

    private DexSection lookupSection(int type) {
        for (DexSection s : this.dexSections) {
            if (s.type != type) continue;
            return s;
        }
        return new DexSection(type, 0, 0, 0);
    }

    private DexSection[] parseMap() {
        int i;
        int mapOffset = this.dexReader.getUint(52);
        this.dexReader.position(mapOffset);
        int mapSize = this.dexReader.getUint();
        DexSection[] result = new DexSection[mapSize];
        for (i = 0; i < mapSize; ++i) {
            int type = this.dexReader.getUshort();
            int unused = this.dexReader.getUshort();
            int size = this.dexReader.getUint();
            int offset = this.dexReader.getUint();
            result[i] = new DexSection(type, unused, size, offset);
        }
        if (Log.ENABLED) {
            for (i = 0; i < result.length; ++i) {
                DexSection dexSection = result[i];
                int nextOffset = i < result.length - 1 ? result[i + 1].offset : dexSection.offset;
                Log.debug(this.getClass(), "Read section 0x%04x @ 0x%08x #items %08d size 0x%08x.", dexSection.type, dexSection.offset, dexSection.length, nextOffset - dexSection.offset);
            }
        }
        for (i = 0; i < mapSize - 1; ++i) {
            result[i].setEnd(result[i + 1].offset);
        }
        result[mapSize - 1].setEnd(this.dexReader.end());
        return result;
    }

    private DexCode parseCodeItem() {
        int registerSize = this.dexReader.getUshort();
        int insSize = this.dexReader.getUshort();
        int outsSize = this.dexReader.getUshort();
        int triesSize = this.dexReader.getUshort();
        int debugInfoOff = this.dexReader.getUint();
        int insnsSize = this.dexReader.getUint();
        short[] code = new short[insnsSize];
        DexCode.Try[] tries = new DexCode.Try[triesSize];
        DexCode.TryHandler[] handlers = null;
        if (insnsSize != 0) {
            for (int i = 0; i < insnsSize; ++i) {
                code[i] = this.dexReader.getShort();
            }
            if (insnsSize % 2 != 0) {
                this.dexReader.getUshort();
            }
            if (triesSize > 0) {
                Int2IntArrayMap handlerMap = new Int2IntArrayMap();
                for (int i = 0; i < triesSize; ++i) {
                    int startAddr = this.dexReader.getUint();
                    int insnCount = this.dexReader.getUshort();
                    int handlerOff = this.dexReader.getUshort();
                    tries[i] = new DexCode.Try(startAddr, insnCount, handlerOff);
                }
                int encodedCatchHandlerListPosition = this.dexReader.position();
                int size = this.dexReader.getUleb128();
                handlers = new DexCode.TryHandler[size];
                for (int i = 0; i < size; ++i) {
                    int encodedCatchHandlerOffset = this.dexReader.position() - encodedCatchHandlerListPosition;
                    handlerMap.put(encodedCatchHandlerOffset, i);
                    int hsize = this.dexReader.getSleb128();
                    int realHsize = Math.abs(hsize);
                    DexCode.TryHandler.TypeAddrPair[] pairs = new DexCode.TryHandler.TypeAddrPair[realHsize];
                    for (int j = 0; j < realHsize; ++j) {
                        int typeIdx = this.dexReader.getUleb128();
                        int addr = this.dexReader.getUleb128();
                        pairs[j] = new DexCode.TryHandler.TypeAddrPair(this.indexedItems.getType(typeIdx), addr);
                    }
                    int catchAllAddr = -1;
                    if (hsize <= 0) {
                        catchAllAddr = this.dexReader.getUleb128();
                    }
                    handlers[i] = new DexCode.TryHandler(pairs, catchAllAddr);
                }
                for (DexCode.Try t : tries) {
                    t.setHandlerIndex(handlerMap);
                }
            }
        }
        int saved = this.dexReader.position();
        DexDebugInfo debugInfo = this.debugInfoAt(debugInfoOff);
        this.dexReader.position(saved);
        InstructionFactory factory = new InstructionFactory();
        Instruction[] instructions = factory.readSequenceFrom(ShortBuffer.wrap(code), 0, code.length, this.indexedItems);
        return new DexCode(registerSize, insSize, outsSize, instructions, tries, handlers, debugInfo);
    }

    void populateIndexTables() {
        this.populateStrings();
        this.populateChecksums();
        this.populateTypes();
        this.populateFields();
        this.populateProtos();
        this.populateMethods();
        this.populateMethodHandles();
        this.populateCallSites();
    }

    private void populateStrings() {
        this.indexedItems.initializeStrings(this.stringIDs.length);
        for (int i = 0; i < this.stringIDs.length; ++i) {
            this.indexedItems.setString(i, this.stringAt(i));
        }
    }

    private void populateMethodHandles() {
        DexSection dexSection = this.lookupSection(8);
        this.indexedItems.initializeMethodHandles(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setMethodHandle(i, this.methodHandleAt(i));
        }
    }

    private void populateCallSites() {
        DexSection dexSection = this.lookupSection(7);
        this.indexedItems.initializeCallSites(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setCallSites(i, this.callSiteAt(i));
        }
    }

    private void populateTypes() {
        DexSection dexSection = this.lookupSection(2);
        assert (this.verifyOrderOfTypeIds(dexSection));
        this.indexedItems.initializeTypes(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setType(i, this.typeAt(i));
        }
    }

    private void populateChecksums() {
        DexString value;
        ClassesChecksum parsedChecksums = new ClassesChecksum();
        for (int i = this.stringIDs.length - 1; i >= 0 && !ClassesChecksum.definitelyPrecedesChecksumMarker(value = this.indexedItems.getString(i)); --i) {
            parsedChecksums.tryParseAndAppend(value);
        }
        this.checksums = parsedChecksums.getChecksums();
    }

    private boolean verifyOrderOfTypeIds(DexSection dexSection) {
        if (dexSection.length >= 2) {
            int initialOffset = dexSection.offset;
            this.dexReader.position(initialOffset);
            int prevStringIndex = this.dexReader.getUint();
            for (int index = 1; index < dexSection.length; ++index) {
                boolean isValidOrder;
                int offset = initialOffset + 4 * index;
                this.dexReader.position(offset);
                int stringIndex = this.dexReader.getUint();
                boolean bl = isValidOrder = stringIndex > prevStringIndex;
                assert (isValidOrder) : String.format("Out-of-order type ids (type #%s: `%s`, type #%s: `%s`)", index - 1, this.indexedItems.getString(prevStringIndex), index, this.indexedItems.getString(stringIndex));
                prevStringIndex = stringIndex;
            }
        }
        return true;
    }

    private void populateFields() {
        DexSection dexSection = this.lookupSection(4);
        assert (this.verifyOrderOfFieldIds(dexSection));
        this.indexedItems.initializeFields(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setField(i, this.fieldAt(i));
        }
    }

    private boolean verifyOrderOfFieldIds(DexSection dexSection) {
        if (dexSection.length >= 2) {
            int initialOffset = dexSection.offset;
            this.dexReader.position(initialOffset);
            int prevHolderIndex = this.dexReader.getUshort();
            int prevTypeIndex = this.dexReader.getUshort();
            int prevNameIndex = this.dexReader.getUint();
            for (int index = 1; index < dexSection.length; ++index) {
                boolean isValidOrder;
                int offset = initialOffset + 8 * index;
                this.dexReader.position(offset);
                int holderIndex = this.dexReader.getUshort();
                int typeIndex = this.dexReader.getUshort();
                int nameIndex = this.dexReader.getUint();
                if (holderIndex == prevHolderIndex) {
                    isValidOrder = nameIndex == prevNameIndex ? typeIndex > prevTypeIndex : nameIndex > prevNameIndex;
                } else {
                    boolean bl = isValidOrder = holderIndex > prevHolderIndex;
                }
                assert (isValidOrder) : String.format("Out-of-order field ids (field #%s: `%s`, field #%s: `%s`)", index - 1, this.dexItemFactory.createField(this.indexedItems.getType(prevHolderIndex), this.indexedItems.getType(prevTypeIndex), this.indexedItems.getString(prevNameIndex)).toSourceString(), index, this.dexItemFactory.createField(this.indexedItems.getType(holderIndex), this.indexedItems.getType(typeIndex), this.indexedItems.getString(nameIndex)).toSourceString());
                prevHolderIndex = holderIndex;
                prevTypeIndex = typeIndex;
                prevNameIndex = nameIndex;
            }
        }
        return true;
    }

    private void populateProtos() {
        DexSection dexSection = this.lookupSection(3);
        this.indexedItems.initializeProtos(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setProto(i, this.protoAt(i));
        }
    }

    private void populateMethods() {
        DexSection dexSection = this.lookupSection(5);
        assert (this.verifyOrderOfMethodIds(dexSection));
        this.indexedItems.initializeMethods(dexSection.length);
        for (int i = 0; i < dexSection.length; ++i) {
            this.indexedItems.setMethod(i, this.methodAt(i));
        }
    }

    private boolean verifyOrderOfMethodIds(DexSection dexSection) {
        if (dexSection.length >= 2) {
            int initialOffset = dexSection.offset;
            this.dexReader.position(initialOffset);
            int prevHolderIndex = this.dexReader.getUshort();
            int prevProtoIndex = this.dexReader.getUshort();
            int prevNameIndex = this.dexReader.getUint();
            for (int index = 1; index < dexSection.length; ++index) {
                boolean isValidOrder;
                int offset = initialOffset + 8 * index;
                this.dexReader.position(offset);
                int holderIndex = this.dexReader.getUshort();
                int protoIndex = this.dexReader.getUshort();
                int nameIndex = this.dexReader.getUint();
                if (holderIndex == prevHolderIndex) {
                    isValidOrder = nameIndex == prevNameIndex ? protoIndex > prevProtoIndex : nameIndex > prevNameIndex;
                } else {
                    boolean bl = isValidOrder = holderIndex > prevHolderIndex;
                }
                assert (isValidOrder) : String.format("Out-of-order method ids (method #%s: `%s`, method #%s: `%s`)", index - 1, this.dexItemFactory.createMethod(this.indexedItems.getType(prevHolderIndex), this.indexedItems.getProto(prevProtoIndex), this.indexedItems.getString(prevNameIndex)).toSourceString(), index, this.dexItemFactory.createMethod(this.indexedItems.getType(holderIndex), this.indexedItems.getProto(protoIndex), this.indexedItems.getString(nameIndex)).toSourceString());
                prevHolderIndex = holderIndex;
                prevProtoIndex = protoIndex;
                prevNameIndex = nameIndex;
            }
        }
        return true;
    }

    private DexString stringAt(int index) {
        byte read;
        int offset = this.stringIDs[index];
        this.dexReader.position(offset);
        int size = this.dexReader.getUleb128();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        do {
            read = this.dexReader.get();
            os.write(read);
        } while (read != 0);
        return this.dexItemFactory.createString(size, os.toByteArray());
    }

    private DexType typeAt(int index) {
        DexSection dexSection = this.lookupSection(2);
        if (index >= dexSection.length) {
            return null;
        }
        int offset = dexSection.offset + 4 * index;
        int stringIndex = this.dexReader.getUint(offset);
        return this.dexItemFactory.createType(this.indexedItems.getString(stringIndex));
    }

    private DexField fieldAt(int index) {
        DexSection dexSection = this.lookupSection(4);
        if (index >= dexSection.length) {
            return null;
        }
        int offset = dexSection.offset + 8 * index;
        this.dexReader.position(offset);
        int classIndex = this.dexReader.getUshort();
        int typeIndex = this.dexReader.getUshort();
        int nameIndex = this.dexReader.getUint();
        DexType clazz = this.indexedItems.getType(classIndex);
        DexType type = this.indexedItems.getType(typeIndex);
        DexString name = this.indexedItems.getString(nameIndex);
        return this.dexItemFactory.createField(clazz, type, name);
    }

    private DexMethodHandle methodHandleAt(int index) {
        Descriptor fieldOrMethod;
        DexSection dexSection = this.lookupSection(8);
        if (index >= dexSection.length) {
            return null;
        }
        int offset = dexSection.offset + 8 * index;
        this.dexReader.position(offset);
        DexMethodHandle.MethodHandleType type = DexMethodHandle.MethodHandleType.getKind(this.dexReader.getUshort());
        this.dexReader.getUshort();
        int indexFieldOrMethod = this.dexReader.getUshort();
        switch (type) {
            case INSTANCE_GET: 
            case INSTANCE_PUT: 
            case STATIC_GET: 
            case STATIC_PUT: {
                fieldOrMethod = this.indexedItems.getField(indexFieldOrMethod);
                break;
            }
            case INVOKE_CONSTRUCTOR: 
            case INVOKE_DIRECT: 
            case INVOKE_INTERFACE: 
            case INVOKE_INSTANCE: 
            case INVOKE_STATIC: {
                fieldOrMethod = this.indexedItems.getMethod(indexFieldOrMethod);
                break;
            }
            default: {
                throw new AssertionError((Object)"Method handle type unsupported in a dex file.");
            }
        }
        this.dexReader.getUshort();
        return this.dexItemFactory.createMethodHandle(type, fieldOrMethod, type == DexMethodHandle.MethodHandleType.INVOKE_INTERFACE);
    }

    private DexCallSite callSiteAt(int index) {
        DexSection dexSection = this.lookupSection(7);
        if (index >= dexSection.length) {
            return null;
        }
        int callSiteOffset = this.dexReader.getUint(dexSection.offset + 4 * index);
        DexEncodedArray callSiteEncodedArray = this.encodedArrayAt(callSiteOffset);
        DexValue[] values2 = callSiteEncodedArray.values;
        assert (values2[0] instanceof DexValue.DexValueMethodHandle);
        assert (values2[1] instanceof DexValue.DexValueString);
        assert (values2[2] instanceof DexValue.DexValueMethodType);
        return this.dexItemFactory.createCallSite((DexString)((DexValue.DexValueString)values2[1]).value, (DexProto)((DexValue.DexValueMethodType)values2[2]).value, (DexMethodHandle)((DexValue.DexValueMethodHandle)values2[0]).value, Arrays.asList(Arrays.copyOfRange(values2, 3, values2.length)));
    }

    private DexProto protoAt(int index) {
        DexSection dexSection = this.lookupSection(3);
        if (index >= dexSection.length) {
            return null;
        }
        int offset = dexSection.offset + 12 * index;
        this.dexReader.position(offset);
        int shortyIndex = this.dexReader.getUint();
        int returnTypeIndex = this.dexReader.getUint();
        int parametersOffsetIndex = this.dexReader.getUint();
        DexString shorty = this.indexedItems.getString(shortyIndex);
        DexType returnType = this.indexedItems.getType(returnTypeIndex);
        DexTypeList parameters = this.typeListAt(parametersOffsetIndex);
        return this.dexItemFactory.createProto(returnType, parameters, shorty);
    }

    private DexMethod methodAt(int index) {
        DexSection dexSection = this.lookupSection(5);
        if (index >= dexSection.length) {
            return null;
        }
        int offset = dexSection.offset + 8 * index;
        this.dexReader.position(offset);
        int classIndex = this.dexReader.getUshort();
        int protoIndex = this.dexReader.getUshort();
        int nameIndex = this.dexReader.getUint();
        return this.dexItemFactory.createMethod(this.indexedItems.getType(classIndex), this.indexedItems.getProto(protoIndex), this.indexedItems.getString(nameIndex));
    }

    private static class AttributesAndAnnotations {
        private final DexAnnotationSet originalAnnotations;
        private EnclosingMethodAttribute enclosingMethodAttribute = null;
        private List<InnerClassAttribute> innerClasses = null;
        private List<DexAnnotation> lazyAnnotations = null;

        public DexAnnotationSet getAnnotations() {
            if (this.lazyAnnotations != null) {
                int size = this.lazyAnnotations.size();
                return size == 0 ? DexAnnotationSet.empty() : new DexAnnotationSet(this.lazyAnnotations.toArray(DexAnnotation.EMPTY_ARRAY));
            }
            return this.originalAnnotations;
        }

        public List<InnerClassAttribute> getInnerClasses() {
            return this.innerClasses == null ? Collections.emptyList() : this.innerClasses;
        }

        public EnclosingMethodAttribute getEnclosingMethodAttribute() {
            return this.enclosingMethodAttribute;
        }

        public AttributesAndAnnotations(DexType type, DexAnnotationSet annotations, DexItemFactory factory) {
            this.originalAnnotations = annotations;
            DexType enclosingClass = null;
            DexMethod enclosingMethod = null;
            List<DexType> memberClasses = null;
            for (int i = 0; i < annotations.annotations.length; ++i) {
                DexAnnotation annotation = annotations.annotations[i];
                if (DexAnnotation.isEnclosingClassAnnotation(annotation, factory)) {
                    this.ensureAnnotations(i);
                    enclosingClass = DexAnnotation.getEnclosingClassFromAnnotation(annotation, factory);
                    continue;
                }
                if (DexAnnotation.isEnclosingMethodAnnotation(annotation, factory)) {
                    this.ensureAnnotations(i);
                    enclosingMethod = DexAnnotation.getEnclosingMethodFromAnnotation(annotation, factory);
                    continue;
                }
                if (DexAnnotation.isInnerClassAnnotation(annotation, factory)) {
                    this.ensureAnnotations(i);
                    if (this.innerClasses == null) {
                        this.innerClasses = new ArrayList<InnerClassAttribute>(annotations.annotations.length - i);
                    }
                    Pair<DexString, Integer> entry = DexAnnotation.getInnerClassFromAnnotation(annotation, factory);
                    this.innerClasses.add(new InnerClassAttribute(entry.getSecond(), type, null, entry.getFirst()));
                    continue;
                }
                if (DexAnnotation.isMemberClassesAnnotation(annotation, factory)) {
                    this.ensureAnnotations(i);
                    List<DexType> members = DexAnnotation.getMemberClassesFromAnnotation(annotation, factory);
                    if (memberClasses == null) {
                        memberClasses = members;
                        continue;
                    }
                    memberClasses.addAll(members);
                    continue;
                }
                this.copyAnnotation(annotation);
            }
            if (enclosingClass != null || enclosingMethod != null) {
                assert (enclosingClass == null || enclosingMethod == null);
                if (enclosingMethod != null) {
                    this.enclosingMethodAttribute = new EnclosingMethodAttribute(enclosingMethod);
                } else {
                    InnerClassAttribute namedEnclosing = null;
                    if (this.innerClasses != null) {
                        for (InnerClassAttribute innerClass : this.innerClasses) {
                            if (type != innerClass.getInner()) continue;
                            namedEnclosing = innerClass.isNamed() ? innerClass : null;
                            break;
                        }
                    }
                    if (namedEnclosing == null) {
                        this.enclosingMethodAttribute = new EnclosingMethodAttribute(enclosingClass);
                    } else {
                        assert (this.innerClasses != null);
                        this.innerClasses.remove(namedEnclosing);
                        this.innerClasses.add(new InnerClassAttribute(namedEnclosing.getAccess(), type, enclosingClass, namedEnclosing.getInnerName()));
                    }
                }
            }
            if (memberClasses != null) {
                if (this.innerClasses == null) {
                    this.innerClasses = new ArrayList<InnerClassAttribute>(memberClasses.size());
                }
                for (DexType memberClass : memberClasses) {
                    this.innerClasses.add(InnerClassAttribute.createUnknownNamedInnerClass(memberClass, type));
                }
            }
        }

        private void ensureAnnotations(int index) {
            if (this.lazyAnnotations == null) {
                this.lazyAnnotations = new ArrayList<DexAnnotation>(this.originalAnnotations.annotations.length);
                this.lazyAnnotations.addAll(Arrays.asList(this.originalAnnotations.annotations).subList(0, index));
            }
        }

        private void copyAnnotation(DexAnnotation annotation) {
            if (this.lazyAnnotations != null) {
                this.lazyAnnotations.add(annotation);
            }
        }
    }

    private static class AnnotationsDirectory {
        private static final DexMemberAnnotation.DexParameterAnnotation[] NO_PARAMETER_ANNOTATIONS = new DexMemberAnnotation.DexParameterAnnotation[0];
        private static final DexMemberAnnotation.DexFieldAnnotation[] NO_FIELD_ANNOTATIONS = new DexMemberAnnotation.DexFieldAnnotation[0];
        private static final DexMemberAnnotation.DexMethodAnnotation[] NO_METHOD_ANNOTATIONS = new DexMemberAnnotation.DexMethodAnnotation[0];
        private static final AnnotationsDirectory THE_EMPTY_ANNOTATIONS_DIRECTORY = new AnnotationsDirectory(DexAnnotationSet.empty(), NO_FIELD_ANNOTATIONS, new DexMemberAnnotation.DexMethodAnnotation[0], NO_PARAMETER_ANNOTATIONS);
        public final DexAnnotationSet clazz;
        public final DexMemberAnnotation.DexFieldAnnotation[] fields;
        public final DexMemberAnnotation.DexMethodAnnotation[] methods;
        public final DexMemberAnnotation.DexParameterAnnotation[] parameters;

        AnnotationsDirectory(DexAnnotationSet clazz, DexMemberAnnotation.DexFieldAnnotation[] fields, DexMemberAnnotation.DexMethodAnnotation[] methods, DexMemberAnnotation.DexParameterAnnotation[] parameters) {
            this.clazz = clazz == null ? DexAnnotationSet.empty() : clazz;
            this.fields = fields == null ? NO_FIELD_ANNOTATIONS : fields;
            this.methods = methods == null ? NO_METHOD_ANNOTATIONS : methods;
            this.parameters = parameters == null ? NO_PARAMETER_ANNOTATIONS : parameters;
        }

        public static AnnotationsDirectory empty() {
            return THE_EMPTY_ANNOTATIONS_DIRECTORY;
        }
    }

    private static class MemberAnnotationIterator<S extends Descriptor<?, S>, T extends DexItem> {
        private int index = 0;
        private final DexMemberAnnotation<S, T>[] annotations;
        private final Supplier<T> emptyValue;

        private MemberAnnotationIterator(DexMemberAnnotation<S, T>[] annotations, Supplier<T> emptyValue) {
            this.annotations = annotations;
            this.emptyValue = emptyValue;
        }

        T getNextFor(S item) {
            while (this.index < this.annotations.length && this.annotations[this.index].item.slowCompareTo(item) < 0) {
                ++this.index;
            }
            if (this.index >= this.annotations.length || !((CachedHashValueDexItem)this.annotations[this.index].item).equals(item)) {
                return (T)((DexItem)this.emptyValue.get());
            }
            return (T)this.annotations[this.index].annotations;
        }
    }
}

